/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.shadowgraph;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.threading.framework.Stoppable;
import com.swirlds.common.threading.pool.ParallelExecutionException;
import com.swirlds.common.threading.pool.ParallelExecutor;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.gossip.IntakeEventCounter;
import com.swirlds.platform.gossip.SyncException;
import com.swirlds.platform.gossip.shadowgraph.ReservedEventWindow;
import com.swirlds.platform.gossip.shadowgraph.ShadowEvent;
import com.swirlds.platform.gossip.shadowgraph.Shadowgraph;
import com.swirlds.platform.gossip.shadowgraph.SyncFallenBehindStatus;
import com.swirlds.platform.gossip.shadowgraph.SyncResult;
import com.swirlds.platform.gossip.shadowgraph.SyncTiming;
import com.swirlds.platform.gossip.shadowgraph.SyncUtils;
import com.swirlds.platform.gossip.shadowgraph.TheirTipsAndEventWindow;
import com.swirlds.platform.gossip.sync.config.SyncConfig;
import com.swirlds.platform.metrics.SyncMetrics;
import com.swirlds.platform.network.Connection;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.consensus.gossip.FallenBehindManager;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;

public class ShadowgraphSynchronizer {
    private static final Logger logger = LogManager.getLogger();
    private final Shadowgraph shadowGraph;
    private final int numberOfNodes;
    private final SyncMetrics syncMetrics;
    private final Consumer<PlatformEvent> eventHandler;
    private final FallenBehindManager fallenBehindManager;
    private final IntakeEventCounter intakeEventCounter;
    private final ParallelExecutor executor;
    private final Time time;
    private final boolean filterLikelyDuplicates;
    private final Duration nonAncestorFilterThreshold;
    private final int maximumEventsPerSync;

    public ShadowgraphSynchronizer(@NonNull PlatformContext platformContext, @NonNull Shadowgraph shadowGraph, int numberOfNodes, @NonNull SyncMetrics syncMetrics, @NonNull Consumer<PlatformEvent> receivedEventHandler, @NonNull FallenBehindManager fallenBehindManager, @NonNull IntakeEventCounter intakeEventCounter, @NonNull ParallelExecutor executor) {
        Objects.requireNonNull(platformContext);
        this.time = platformContext.getTime();
        this.shadowGraph = Objects.requireNonNull(shadowGraph);
        this.numberOfNodes = numberOfNodes;
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.executor = Objects.requireNonNull(executor);
        this.eventHandler = Objects.requireNonNull(receivedEventHandler);
        SyncConfig syncConfig = (SyncConfig)platformContext.getConfiguration().getConfigData(SyncConfig.class);
        this.nonAncestorFilterThreshold = syncConfig.nonAncestorFilterThreshold();
        this.filterLikelyDuplicates = syncConfig.filterLikelyDuplicates();
        this.maximumEventsPerSync = syncConfig.maxSyncEventCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean synchronize(@NonNull PlatformContext platformContext, @NonNull Connection connection) throws IOException, ParallelExecutionException, SyncException, InterruptedException {
        logger.info(LogMarker.SYNC_INFO.getMarker(), "{} sync start", (Object)connection.getDescription());
        try {
            boolean bl = this.reserveSynchronize(platformContext, connection);
            return bl;
        }
        finally {
            logger.info(LogMarker.SYNC_INFO.getMarker(), "{} sync end", (Object)connection.getDescription());
        }
    }

    private boolean reserveSynchronize(@NonNull PlatformContext platformContext, @NonNull Connection connection) throws IOException, ParallelExecutionException, SyncException, InterruptedException {
        List<PlatformEvent> sendList;
        SyncTiming timing = new SyncTiming();
        try (ReservedEventWindow reservation = this.shadowGraph.reserve();){
            connection.initForSync();
            timing.start();
            EventWindow myWindow = reservation.getEventWindow();
            List<ShadowEvent> myTips = this.getTips();
            TheirTipsAndEventWindow theirTipsAndEventWindow = this.readWriteParallel(SyncUtils.readTheirTipsAndEventWindow(connection, this.numberOfNodes), SyncUtils.writeMyTipsAndEventWindow(connection, myWindow, myTips), connection);
            timing.setTimePoint(1);
            this.syncMetrics.eventWindow(myWindow, theirTipsAndEventWindow.eventWindow());
            if (this.fallenBehind(myWindow, theirTipsAndEventWindow.eventWindow(), connection)) {
                boolean bl = false;
                return bl;
            }
            HashSet<ShadowEvent> eventsTheyHave = new HashSet<ShadowEvent>();
            List<ShadowEvent> theirTips = this.shadowGraph.shadows(theirTipsAndEventWindow.tips());
            List<Boolean> theirTipsIHave = SyncUtils.getTheirTipsIHave(theirTips);
            theirTips.stream().filter(Objects::nonNull).forEach(eventsTheyHave::add);
            timing.setTimePoint(2);
            List<Boolean> theirBooleans = this.readWriteParallel(SyncUtils.readMyTipsTheyHave(connection, myTips.size()), SyncUtils.writeTheirTipsIHave(connection, theirTipsIHave), connection);
            timing.setTimePoint(3);
            List<ShadowEvent> knownTips = SyncUtils.getMyTipsTheyKnow(connection, myTips, theirBooleans);
            eventsTheyHave.addAll(knownTips);
            sendList = this.createSendList(connection.getSelfId(), eventsTheyHave, myWindow, theirTipsAndEventWindow.eventWindow());
        }
        SyncConfig syncConfig = (SyncConfig)platformContext.getConfiguration().getConfigData(SyncConfig.class);
        return this.sendAndReceiveEvents(connection, timing, sendList, syncConfig.syncKeepalivePeriod(), syncConfig.maxSyncTime());
    }

    @NonNull
    private List<ShadowEvent> getTips() {
        List<ShadowEvent> myTips = this.shadowGraph.getTips();
        this.syncMetrics.updateTipsPerSync(myTips.size());
        this.syncMetrics.updateMultiTipsPerSync(SyncUtils.computeMultiTipCount(myTips));
        return myTips;
    }

    private boolean fallenBehind(@NonNull EventWindow self, @NonNull EventWindow other, @NonNull Connection connection) {
        Objects.requireNonNull(self);
        Objects.requireNonNull(other);
        Objects.requireNonNull(connection);
        SyncFallenBehindStatus status = SyncFallenBehindStatus.getStatus(self, other);
        if (status == SyncFallenBehindStatus.SELF_FALLEN_BEHIND) {
            this.fallenBehindManager.reportFallenBehind(connection.getOtherId());
        } else {
            this.fallenBehindManager.clearFallenBehind(connection.getOtherId());
        }
        if (status != SyncFallenBehindStatus.NONE_FALLEN_BEHIND) {
            logger.info(LogMarker.SYNC_INFO.getMarker(), "{} aborting sync due to {}", (Object)connection.getDescription(), (Object)status);
            return true;
        }
        return false;
    }

    @NonNull
    private List<PlatformEvent> createSendList(@NonNull NodeId selfId, @NonNull Set<ShadowEvent> knownSet, @NonNull EventWindow myEventWindow, @NonNull EventWindow theirEventWindow) {
        List<PlatformEvent> sendList;
        Objects.requireNonNull(selfId);
        Objects.requireNonNull(knownSet);
        Objects.requireNonNull(myEventWindow);
        Objects.requireNonNull(theirEventWindow);
        Set<ShadowEvent> knownAncestors = this.shadowGraph.findAncestors(knownSet, SyncUtils.unknownNonAncient(knownSet, myEventWindow, theirEventWindow));
        knownAncestors.addAll(knownSet);
        this.syncMetrics.knownSetSize(knownAncestors.size());
        Predicate<ShadowEvent> knownAncestorsPredicate = SyncUtils.unknownNonAncient(knownAncestors, myEventWindow, theirEventWindow);
        List<ShadowEvent> myNewTips = this.shadowGraph.getTips();
        List<ShadowEvent> unknownTips = myNewTips.stream().filter(knownAncestorsPredicate).collect(Collectors.toList());
        Set<ShadowEvent> sendSet = this.shadowGraph.findAncestors(unknownTips, knownAncestorsPredicate);
        sendSet.addAll(unknownTips);
        List<PlatformEvent> eventsTheyMayNeed = sendSet.stream().map(ShadowEvent::getEvent).collect(Collectors.toCollection(ArrayList::new));
        SyncUtils.sort(eventsTheyMayNeed);
        if (this.filterLikelyDuplicates) {
            long startFilterTime = this.time.nanoTime();
            sendList = SyncUtils.filterLikelyDuplicates(selfId, this.nonAncestorFilterThreshold, this.time.now(), eventsTheyMayNeed);
            long endFilterTime = this.time.nanoTime();
            this.syncMetrics.recordSyncFilterTime(endFilterTime - startFilterTime);
        } else {
            sendList = eventsTheyMayNeed;
        }
        if (this.maximumEventsPerSync > 0 && sendList.size() > this.maximumEventsPerSync) {
            sendList = sendList.subList(0, this.maximumEventsPerSync);
        }
        return sendList;
    }

    private boolean sendAndReceiveEvents(@NonNull Connection connection, @NonNull SyncTiming timing, @NonNull List<PlatformEvent> sendList, @NonNull Duration syncKeepAlivePeriod, @NonNull Duration maxSyncTime) throws ParallelExecutionException {
        Objects.requireNonNull(connection);
        Objects.requireNonNull(sendList);
        timing.setTimePoint(4);
        CountDownLatch eventReadingDone = new CountDownLatch(1);
        AtomicBoolean writeAborted = new AtomicBoolean(false);
        Integer eventsRead = this.readWriteParallel(SyncUtils.readEventsINeed(connection, this.eventHandler, this.maximumEventsPerSync, this.syncMetrics, eventReadingDone, this.intakeEventCounter, maxSyncTime), SyncUtils.sendEventsTheyNeed(connection, sendList, eventReadingDone, writeAborted, syncKeepAlivePeriod), connection);
        if (eventsRead < 0 || writeAborted.get()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = connection::getDescription;
            logger.info(LogMarker.SYNC_INFO.getMarker(), "{} sync aborted", supplierArray);
            return false;
        }
        logger.info(LogMarker.SYNC_INFO.getMarker(), "{} writing events done, wrote {} events", (Object)connection.getDescription(), (Object)sendList.size());
        logger.info(LogMarker.SYNC_INFO.getMarker(), "{} reading events done, read {} events", (Object)connection.getDescription(), (Object)eventsRead);
        this.syncMetrics.syncDone(new SyncResult(connection.isOutbound(), connection.getOtherId(), eventsRead, sendList.size()));
        timing.setTimePoint(5);
        this.syncMetrics.recordSyncTiming(timing, connection);
        return true;
    }

    @Nullable
    private <T> T readWriteParallel(@NonNull Callable<T> readTask, @NonNull Callable<Void> writeTask, @NonNull Connection connection) throws ParallelExecutionException {
        Objects.requireNonNull(readTask);
        Objects.requireNonNull(writeTask);
        Objects.requireNonNull(connection);
        return (T)this.executor.doParallel(readTask, writeTask, connection::disconnect);
    }

    public void clear() {
        this.shadowGraph.clear();
    }

    public void addEvent(@NonNull PlatformEvent platformEvent) {
        this.shadowGraph.addEvent(platformEvent);
    }

    public void updateEventWindow(@NonNull EventWindow eventWindow) {
        this.shadowGraph.updateEventWindow(eventWindow);
    }

    public void start() {
        this.executor.start();
    }

    public void stop() {
        ParallelExecutor parallelExecutor = this.executor;
        if (parallelExecutor instanceof Stoppable) {
            Stoppable stoppable = (Stoppable)parallelExecutor;
            stoppable.stop(Stoppable.StopBehavior.INTERRUPTABLE);
        }
    }
}

