/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.health.filesystem;

import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.platform.health.OSHealthCheckConfig;
import com.swirlds.platform.health.OSHealthCheckUtils;
import com.swirlds.platform.health.filesystem.OSFileSystemCheck;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public final class OSFileSystemChecker {
    private final Path configPath;

    public OSFileSystemChecker(@NonNull Path configPath) {
        this.configPath = Objects.requireNonNull(configPath);
    }

    public boolean performFileSystemCheck(@NonNull StringBuilder sb, @NonNull OSHealthCheckConfig osHealthConfig) {
        Objects.requireNonNull(sb, "sb must not be null");
        Objects.requireNonNull(osHealthConfig, "osHealthConfig must not be null");
        try {
            OSFileSystemCheck.Report fileSystemReport = OSFileSystemCheck.execute(this.configPath, osHealthConfig.fileReadTimeoutMillis());
            return this.appendReport(sb, fileSystemReport, osHealthConfig.maxFileReadMillis());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Thread interrupted while performing OS file system check", e);
        }
    }

    private boolean appendReport(StringBuilder sb, OSFileSystemCheck.Report fileSystemReport, long maxFileReadMillis) {
        if (fileSystemReport.code() == OSFileSystemCheck.TestResultCode.SUCCESS) {
            double readMillis = (double)fileSystemReport.readNanos().longValue() * 1.0E-6;
            if (TimeUnit.NANOSECONDS.toMillis(fileSystemReport.readNanos()) > maxFileReadMillis) {
                OSHealthCheckUtils.reportHeader(sb, OSFileSystemCheck.Report.name(), false);
                StringFormattingUtils.addLine((StringBuilder)sb, (String)String.format("OS file read time was too slow. Maximum millis allowed: %d, Took: %s", maxFileReadMillis, readMillis));
                return false;
            }
            OSHealthCheckUtils.reportHeader(sb, OSFileSystemCheck.Report.name(), true);
            StringFormattingUtils.addLine((StringBuilder)sb, (String)fileSystemReport.toString());
            return true;
        }
        OSHealthCheckUtils.reportHeader(sb, OSFileSystemCheck.Report.name(), false);
        if (fileSystemReport.exception() == null) {
            StringFormattingUtils.addLine((StringBuilder)sb, (String)String.format("OS file check failed. Code: %s", new Object[]{fileSystemReport.code()}));
        } else {
            StringFormattingUtils.addLine((StringBuilder)sb, (String)String.format("OS file check failed with exception. Code: %s%n%s", new Object[]{fileSystemReport.code(), fileSystemReport.exception()}));
        }
        return false;
    }
}

