/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.VirtualStateAccessor;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class RecordAccessorImpl<K extends VirtualKey, V extends VirtualValue>
implements RecordAccessor<K, V> {
    private final VirtualStateAccessor state;
    private final VirtualNodeCache<K, V> cache;
    private final KeySerializer<K> keySerializer;
    private final ValueSerializer<V> valueSerializer;
    private final VirtualDataSource dataSource;

    public RecordAccessorImpl(VirtualStateAccessor state, VirtualNodeCache<K, V> cache, KeySerializer<K> keySerializer, ValueSerializer<V> valueSerializer, VirtualDataSource dataSource) {
        this.state = Objects.requireNonNull(state);
        this.cache = Objects.requireNonNull(cache);
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.dataSource = dataSource;
    }

    @Override
    public VirtualStateAccessor getState() {
        return this.state;
    }

    @Override
    public VirtualNodeCache<K, V> getCache() {
        return this.cache;
    }

    @Override
    public VirtualDataSource getDataSource() {
        return this.dataSource;
    }

    @Override
    public Hash findHash(long path) {
        assert (path >= 0L);
        Hash hash = this.cache.lookupHashByPath(path, false);
        if (hash == VirtualNodeCache.DELETED_HASH) {
            return null;
        }
        if (hash != null) {
            return hash;
        }
        try {
            return this.dataSource.loadHash(path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to read node hash from data source by path", e);
        }
    }

    @Override
    public boolean findAndWriteHash(long path, SerializableDataOutputStream out) throws IOException {
        assert (path >= 0L);
        Hash hash = this.cache.lookupHashByPath(path, false);
        if (hash == VirtualNodeCache.DELETED_HASH) {
            return false;
        }
        if (hash != null) {
            hash.serialize(out);
            return true;
        }
        return this.dataSource.loadAndWriteHash(path, out);
    }

    @Override
    public VirtualLeafRecord<K, V> findLeafRecord(K key, boolean copy) {
        VirtualLeafRecord<K, V> rec = this.cache.lookupLeafByKey(key, copy);
        if (rec == null) {
            try {
                Bytes keyBytes = this.keySerializer.toBytes(key);
                VirtualLeafBytes leafBytes = this.dataSource.loadLeafRecord(keyBytes, key.hashCode());
                if (leafBytes != null) {
                    rec = leafBytes.toRecord(this.keySerializer, this.valueSerializer);
                    assert (rec.getKey().equals(key)) : "The key we found from the DB does not match the one we were looking for! key=" + String.valueOf(key);
                    if (copy) {
                        this.cache.putLeaf(rec);
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read a leaf record from the data source by key", ex);
            }
        }
        return rec == VirtualNodeCache.DELETED_LEAF_RECORD ? null : rec;
    }

    @Override
    public VirtualLeafRecord<K, V> findLeafRecord(long path, boolean copy) {
        assert (path != -1L);
        assert (path != 0L);
        if (path < this.state.getFirstLeafPath() || path > this.state.getLastLeafPath()) {
            return null;
        }
        VirtualLeafRecord<K, V> rec = this.cache.lookupLeafByPath(path, copy);
        if (rec == null) {
            try {
                VirtualLeafBytes leafBytes = this.dataSource.loadLeafRecord(path);
                if (leafBytes != null) {
                    rec = leafBytes.toRecord(this.keySerializer, this.valueSerializer);
                    if (copy) {
                        this.cache.putLeaf(rec);
                    }
                }
            }
            catch (IOException ex) {
                throw new UncheckedIOException("Failed to read a leaf record from the data source by path", ex);
            }
        }
        return rec == VirtualNodeCache.DELETED_LEAF_RECORD ? null : rec;
    }

    @Override
    public long findKey(K key) {
        VirtualLeafRecord<K, V> rec = this.cache.lookupLeafByKey(key, false);
        if (rec != null) {
            return rec.getPath();
        }
        try {
            Bytes keyBytes = this.keySerializer.toBytes(key);
            return this.dataSource.findKey(keyBytes, key.hashCode());
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Failed to find key in the data source", ex);
        }
    }
}

