/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.memory;

import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.state.merkle.logging.StateLogger;
import com.swirlds.state.merkle.memory.InMemoryKey;
import com.swirlds.state.merkle.memory.InMemoryValue;
import com.swirlds.state.spi.ReadableKVStateBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;

public final class InMemoryReadableKVState<K, V>
extends ReadableKVStateBase<K, V> {
    private final MerkleMap<InMemoryKey<K>, InMemoryValue<K, V>> merkle;

    public InMemoryReadableKVState(@NonNull String stateKey, @NonNull MerkleMap<InMemoryKey<K>, InMemoryValue<K, V>> merkleMap) {
        super(stateKey);
        this.merkle = Objects.requireNonNull(merkleMap);
    }

    protected V readFromDataSource(@NonNull K key) {
        InMemoryKey<K> k = new InMemoryKey<K>(key);
        InMemoryValue leaf = (InMemoryValue)this.merkle.get(k);
        V value = leaf == null ? null : (V)leaf.getValue();
        StateLogger.logMapGet(this.getStateKey(), key, value);
        return value;
    }

    @NonNull
    protected Iterator<K> iterateFromDataSource() {
        Set keySet = this.merkle.keySet();
        StateLogger.logMapIterate(this.getStateKey(), keySet);
        return keySet.stream().map(InMemoryKey::key).iterator();
    }

    @Deprecated
    public long size() {
        int size = this.merkle.size();
        StateLogger.logMapGetSize(this.getStateKey(), size);
        return size;
    }
}

