/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.state;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.platform.test.fixtures.state.TestMerkleStateRoot;
import com.swirlds.platform.test.fixtures.state.TestPlatformStateFacade;
import com.swirlds.state.State;
import com.swirlds.state.merkle.singleton.StringLeaf;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import org.hiero.base.concurrent.interrupt.Uninterruptable;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class BlockingState
extends TestMerkleStateRoot {
    private static final int VERSION_MIGRATE_TO_SERIALIZABLE = 31;
    private static final int CLASS_VERSION = 31;
    private static final long CLASS_ID = -6352638754043560731L;
    private final BlockingStringLeaf value;
    private TestPlatformStateFacade platformStateFacade;

    public BlockingState() {
        this(new TestPlatformStateFacade());
    }

    public BlockingState(TestPlatformStateFacade platformStateFacade) {
        this.platformStateFacade = platformStateFacade;
        this.value = new BlockingStringLeaf();
        this.setChild(1, (MerkleNode)this.value);
    }

    private BlockingState(BlockingState that) {
        super(that);
        this.value = that.value;
        this.setChild(1, (MerkleNode)this.value);
    }

    @Override
    @NonNull
    public BlockingState copy() {
        this.throwIfImmutable();
        this.setImmutable(true);
        return new BlockingState(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof BlockingState)) {
            return false;
        }
        BlockingState that = (BlockingState)((Object)obj);
        return Objects.equals(this.platformStateFacade.platformStateOf((State)this), this.platformStateFacade.platformStateOf((State)that));
    }

    public int hashCode() {
        return 0;
    }

    @Override
    public long getClassId() {
        return -6352638754043560731L;
    }

    public int getVersion() {
        return 31;
    }

    public void enableBlockingSerialization() {
        this.value.enableBlockingSerialization();
    }

    public void unblockSerialization() {
        this.value.unblockSerialization();
    }

    static {
        try {
            ConstructableRegistry.getInstance().registerConstructable(new ClassConstructorPair(BlockingStringLeaf.class, BlockingStringLeaf::new));
        }
        catch (ConstructableRegistryException e) {
            throw new RuntimeException(e);
        }
    }

    private static class BlockingStringLeaf
    extends StringLeaf {
        private static final long CLASS_ID = 2753357491675780L;
        private CountDownLatch serializationLatch;

        public BlockingStringLeaf() {
            super("BlockingStringLeaf");
        }

        public void enableBlockingSerialization() {
            this.serializationLatch = new CountDownLatch(1);
        }

        public void unblockSerialization() {
            this.serializationLatch.countDown();
        }

        public long getClassId() {
            return 2753357491675780L;
        }

        public void serialize(SerializableDataOutputStream out) throws IOException {
            if (this.serializationLatch != null) {
                Uninterruptable.abortAndThrowIfInterrupted(this.serializationLatch::await, (String)"interrupted while waiting for latch");
            }
            super.serialize(out);
        }

        public void deserialize(SerializableDataInputStream in, int version) throws IOException {
            super.deserialize(in, version);
        }
    }
}

