/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.migration.virtual;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.hedera.pbj.runtime.io.buffer.BufferedData;
import com.swirlds.virtualmap.VirtualKey;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class AccountVirtualMapKey
implements VirtualKey {
    private static final long CLASS_ID = -29917391195398950L;
    private long realmID;
    private long shardID;
    private long accountID;

    public AccountVirtualMapKey() {
        this(0L, 0L, 0L);
    }

    public AccountVirtualMapKey(long realmID, long shardID, long accountID) {
        this.realmID = realmID;
        this.shardID = shardID;
        this.accountID = accountID;
    }

    public int getVersion() {
        return 1;
    }

    public long getClassId() {
        return -29917391195398950L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.realmID);
        out.writeLong(this.shardID);
        out.writeLong(this.accountID);
    }

    void serialize(WritableSequentialData out) {
        out.writeLong(this.realmID);
        out.writeLong(this.shardID);
        out.writeLong(this.accountID);
    }

    @Deprecated
    void serialize(ByteBuffer buffer) {
        buffer.putLong(this.realmID);
        buffer.putLong(this.shardID);
        buffer.putLong(this.accountID);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.realmID = in.readLong();
        this.shardID = in.readLong();
        this.accountID = in.readLong();
    }

    void deserialize(ReadableSequentialData in) {
        this.realmID = in.readLong();
        this.shardID = in.readLong();
        this.accountID = in.readLong();
    }

    @Deprecated
    void deserialize(ByteBuffer buffer) {
        this.realmID = buffer.getLong();
        this.shardID = buffer.getLong();
        this.accountID = buffer.getLong();
    }

    boolean equals(BufferedData buffer) {
        return this.realmID == buffer.readLong() && this.shardID == buffer.readLong() && this.accountID == buffer.readLong();
    }

    @Deprecated
    boolean equals(ByteBuffer buffer, int version) {
        return this.realmID == buffer.getLong() && this.shardID == buffer.getLong() && this.accountID == buffer.getLong();
    }

    public String toString() {
        return "AccountVirtualMapKey{realmID=" + this.realmID + ", shardId=" + this.shardID + ", accountID=" + this.accountID + "}";
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AccountVirtualMapKey that = (AccountVirtualMapKey)other;
        return this.realmID == that.realmID && this.shardID == that.shardID && this.accountID == that.accountID;
    }

    public int hashCode() {
        return Objects.hash(this.realmID, this.shardID, this.accountID);
    }

    public static int getSizeInBytes() {
        return 24;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

