/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.token;

import com.hedera.hapi.node.base.Transaction;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.hapi.node.transaction.TransactionResponse;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.grpc.Pipeline;
import com.hedera.pbj.runtime.grpc.Pipelines;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public interface CryptoServiceInterface
extends ServiceInterface {
    public static final String SERVICE_NAME = "CryptoService";
    public static final String FULL_NAME = "proto.CryptoService";

    public TransactionResponse createAccount(Transaction var1);

    public TransactionResponse updateAccount(Transaction var1);

    public TransactionResponse cryptoTransfer(Transaction var1);

    public TransactionResponse cryptoDelete(Transaction var1);

    public TransactionResponse approveAllowances(Transaction var1);

    public TransactionResponse deleteAllowances(Transaction var1);

    public TransactionResponse addLiveHash(Transaction var1);

    public TransactionResponse deleteLiveHash(Transaction var1);

    public Response getLiveHash(Query var1);

    public Response getAccountRecords(Query var1);

    public Response cryptoGetBalance(Query var1);

    public Response getAccountInfo(Query var1);

    public Response getTransactionReceipts(Query var1);

    public Response getTxRecordByTxID(Query var1);

    @NonNull
    default public String serviceName() {
        return SERVICE_NAME;
    }

    @NonNull
    default public String fullName() {
        return FULL_NAME;
    }

    @NonNull
    default public List<ServiceInterface.Method> methods() {
        return Arrays.asList(CryptoServiceMethod.values());
    }

    @NonNull
    default public Pipeline<? super Bytes> open(@NonNull ServiceInterface.Method method, @NonNull ServiceInterface.RequestOptions options, @NonNull Pipeline<? super Bytes> replies) {
        CryptoServiceMethod m = (CryptoServiceMethod)method;
        try {
            return switch (m.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::createAccount).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 1 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::updateAccount).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 2 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::cryptoTransfer).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 3 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::cryptoDelete).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 4 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::approveAllowances).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 5 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::deleteAllowances).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 6 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::addLiveHash).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 7 -> Pipelines.unary().mapRequest(bytes -> this.parseTransaction((Bytes)bytes, options)).method(this::deleteLiveHash).mapResponse(reply -> this.serializeTransactionResponse((TransactionResponse)reply, options)).respondTo(replies).build();
                case 8 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::getLiveHash).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
                case 9 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::getAccountRecords).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
                case 10 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::cryptoGetBalance).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
                case 11 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::getAccountInfo).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
                case 12 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::getTransactionReceipts).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
                case 13 -> Pipelines.unary().mapRequest(bytes -> this.parseQuery((Bytes)bytes, options)).method(this::getTxRecordByTxID).mapResponse(reply -> this.serializeResponse((Response)reply, options)).respondTo(replies).build();
            };
        }
        catch (Exception e) {
            replies.onError((Throwable)e);
            return Pipelines.noop();
        }
    }

    @NonNull
    private Transaction parseTransaction(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return (Transaction)Transaction.JSON.parse(message.toReadableSequentialData(), false, 16);
        }
        return (Transaction)Transaction.PROTOBUF.parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private Query parseQuery(@NonNull Bytes message, @NonNull ServiceInterface.RequestOptions options) throws ParseException {
        Objects.requireNonNull(message);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return (Query)Query.JSON.parse(message.toReadableSequentialData(), false, 16);
        }
        return (Query)Query.PROTOBUF.parse(message.toReadableSequentialData(), false, 16);
    }

    @NonNull
    private Bytes serializeTransactionResponse(@NonNull TransactionResponse reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Bytes.wrap((String)TransactionResponse.JSON.toJSON((Object)reply));
        }
        return TransactionResponse.PROTOBUF.toBytes((Object)reply);
    }

    @NonNull
    private Bytes serializeResponse(@NonNull Response reply, @NonNull ServiceInterface.RequestOptions options) {
        Objects.requireNonNull(reply);
        Objects.requireNonNull(options);
        if (options.isJson() && !options.isProtobuf()) {
            return Bytes.wrap((String)Response.JSON.toJSON((Object)reply));
        }
        return Response.PROTOBUF.toBytes((Object)reply);
    }

    public static enum CryptoServiceMethod implements ServiceInterface.Method
    {
        createAccount,
        updateAccount,
        cryptoTransfer,
        cryptoDelete,
        approveAllowances,
        deleteAllowances,
        addLiveHash,
        deleteLiveHash,
        getLiveHash,
        getAccountRecords,
        cryptoGetBalance,
        getAccountInfo,
        getTransactionReceipts,
        getTxRecordByTxID;

    }
}

