/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats.signing;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.demo.stats.signing.StatsSigningTestingToolState;
import com.swirlds.demo.stats.signing.SttTransactionPool;
import com.swirlds.demo.stats.signing.TransactionCodec;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.CryptographyProvider;
import org.hiero.base.crypto.TransactionSignature;
import org.hiero.base.crypto.VerificationStatus;
import org.hiero.base.utility.CommonUtils;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class StatsSigningTestingToolConsensusStateEventHandler
implements ConsensusStateEventHandler<StatsSigningTestingToolState> {
    private static final Logger logger = LogManager.getLogger(StatsSigningTestingToolConsensusStateEventHandler.class);
    private static final Cryptography CRYPTOGRAPHY = CryptographyProvider.getInstance();
    private static final boolean SYNTHETIC_HANDLE_TIME = false;
    private static final int HANDLE_MICROS = 100;
    private final Supplier<SttTransactionPool> transactionPoolSupplier;

    public StatsSigningTestingToolConsensusStateEventHandler(Supplier<SttTransactionPool> transactionPoolSupplier) {
        this.transactionPoolSupplier = transactionPoolSupplier;
    }

    public void onStateInitialized(@NonNull StatsSigningTestingToolState state, @NonNull Platform platform, @NonNull InitTrigger trigger, @Nullable SemanticVersion previousVersion) {
    }

    public void onPreHandle(@NonNull Event event, @NonNull StatsSigningTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        SttTransactionPool sttTransactionPool = this.transactionPoolSupplier.get();
        if (sttTransactionPool != null) {
            event.forEachTransaction(transaction -> {
                if (this.areTransactionBytesSystemOnes((Transaction)transaction)) {
                    this.consumeSystemTransaction((Transaction)transaction, event, stateSignatureTransactionCallback);
                    return;
                }
                TransactionSignature transactionSignature = sttTransactionPool.expandSignatures(transaction.getApplicationTransaction());
                if (transactionSignature != null) {
                    transaction.setMetadata((Object)transactionSignature);
                    CRYPTOGRAPHY.verifySync(List.of(transactionSignature));
                }
            });
        }
    }

    public void onHandleConsensusRound(@NonNull Round round, @NonNull StatsSigningTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        state.throwIfImmutable();
        round.forEachEventTransaction((event, transaction) -> {
            if (this.areTransactionBytesSystemOnes((Transaction)transaction)) {
                this.consumeSystemTransaction((Transaction)transaction, (Event)event, stateSignatureTransactionCallback);
            } else {
                this.handleTransaction((ConsensusTransaction)transaction, state);
            }
        });
    }

    private void handleTransaction(ConsensusTransaction trans, StatsSigningTestingToolState state) {
        TransactionSignature s = (TransactionSignature)trans.getMetadata();
        if (s != null && s.getSignatureStatus() != VerificationStatus.VALID) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Invalid Transaction Signature [ transactionId = {}, status = {}, signatureType = {}, publicKey = {}, signature = {}, data = {} ]", (Object)TransactionCodec.txId(trans.getApplicationTransaction()), (Object)s.getSignatureStatus(), (Object)s.getSignatureType(), (Object)CommonUtils.hex((Bytes)s.getPublicKey()), (Object)CommonUtils.hex((Bytes)s.getSignature()), (Object)CommonUtils.hex((Bytes)s.getMessage()));
        }
        state.incrementRunningSum(TransactionCodec.txId(trans.getApplicationTransaction()));
        this.maybeDelay();
    }

    private boolean areTransactionBytesSystemOnes(@NonNull Transaction transaction) {
        Bytes transactionBytes = transaction.getApplicationTransaction();
        if (transactionBytes.length() == 0L) {
            return false;
        }
        return transactionBytes.getByte(0L) == 0;
    }

    private void consumeSystemTransaction(@NonNull Transaction transaction, @NonNull Event event, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            Bytes transactionBytes = transaction.getApplicationTransaction();
            Bytes strippedSystemTransactionBytes = transactionBytes.slice(1L, transactionBytes.length() - 1L);
            StateSignatureTransaction stateSignatureTransaction = (StateSignatureTransaction)StateSignatureTransaction.PROTOBUF.parse(strippedSystemTransactionBytes);
            stateSignatureTransactionCallback.accept((ScopedSystemTransaction<StateSignatureTransaction>)new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), (Object)stateSignatureTransaction));
        }
        catch (ParseException e) {
            logger.error("Failed to parse StateSignatureTransaction", (Throwable)e);
        }
    }

    private void maybeDelay() {
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull StatsSigningTestingToolState state) {
        return true;
    }

    public void onUpdateWeight(@NonNull StatsSigningTestingToolState state, @NonNull AddressBook configAddressBook, @NonNull PlatformContext context) {
    }

    public void onNewRecoveredState(@NonNull StatsSigningTestingToolState recoveredState) {
    }
}

