/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.nativelib.secp256k1;

import com.sun.jna.Callback;
import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.nio.ByteBuffer;
import java.security.SecureRandom;

public class LibSecp256k1
implements Library {
    private static final int SECP256K1_FLAGS_TYPE_CONTEXT = 1;
    private static final int SECP256K1_FLAGS_TYPE_COMPRESSION = 2;
    private static final int SECP256K1_FLAGS_BIT_CONTEXT_VERIFY = 256;
    private static final int SECP256K1_FLAGS_BIT_CONTEXT_SIGN = 512;
    private static final int SECP256K1_FLAGS_BIT_CONTEXT_DECLASSIFY = 1024;
    private static final int SECP256K1_FLAGS_BIT_COMPRESSION = 256;
    public static final int SECP256K1_CONTEXT_VERIFY = 257;
    public static final int SECP256K1_CONTEXT_SIGN = 513;
    public static final int SECP256K1_CONTEXT_DECLASSIFY = 1025;
    public static final int SECP256K1_CONTEXT_NONE = 1;
    public static final int SECP256K1_EC_COMPRESSED = 258;
    public static final int SECP256K1_EC_UNCOMPRESSED = 2;
    public static final PointerByReference CONTEXT = LibSecp256k1.createContext();

    private static PointerByReference createContext() {
        try {
            Native.register(LibSecp256k1.class, (String)"secp256k1");
            PointerByReference context = LibSecp256k1.secp256k1_context_create(769);
            if (Boolean.parseBoolean(System.getProperty("secp256k1.randomize", "true"))) {
                byte[] seed = new byte[32];
                SecureRandom.getInstanceStrong().nextBytes(seed);
                if (LibSecp256k1.secp256k1_context_randomize(context, seed) != 1) {
                    return null;
                }
            }
            return context;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static native PointerByReference secp256k1_context_create(int var0);

    public static native int secp256k1_ec_pubkey_parse(PointerByReference var0, secp256k1_pubkey var1, byte[] var2, long var3);

    public static native int secp256k1_ec_pubkey_serialize(PointerByReference var0, ByteBuffer var1, LongByReference var2, secp256k1_pubkey var3, int var4);

    public static native int secp256k1_ecdsa_signature_parse_compact(PointerByReference var0, secp256k1_ecdsa_signature var1, byte[] var2);

    public static native int secp256k1_ecdsa_signature_normalize(PointerByReference var0, secp256k1_ecdsa_signature var1, secp256k1_ecdsa_signature var2);

    public static native int secp256k1_ecdsa_verify(PointerByReference var0, secp256k1_ecdsa_signature var1, byte[] var2, secp256k1_pubkey var3);

    public static native int secp256k1_ec_pubkey_create(PointerByReference var0, secp256k1_pubkey var1, byte[] var2);

    public static native int secp256k1_context_randomize(PointerByReference var0, byte[] var1);

    public static native int secp256k1_ecdsa_recoverable_signature_parse_compact(PointerByReference var0, secp256k1_ecdsa_recoverable_signature var1, byte[] var2, int var3);

    public static native void secp256k1_ecdsa_recoverable_signature_serialize_compact(PointerByReference var0, ByteBuffer var1, IntByReference var2, secp256k1_ecdsa_recoverable_signature var3);

    public static native int secp256k1_ecdsa_sign_recoverable(PointerByReference var0, secp256k1_ecdsa_recoverable_signature var1, byte[] var2, byte[] var3, secp256k1_nonce_function var4, Pointer var5);

    public static native int secp256k1_ecdsa_recover(PointerByReference var0, secp256k1_pubkey var1, secp256k1_ecdsa_recoverable_signature var2, byte[] var3);

    @Structure.FieldOrder(value={"data"})
    public static class secp256k1_ecdsa_recoverable_signature
    extends Structure {
        public byte[] data = new byte[65];
    }

    @Structure.FieldOrder(value={"data"})
    public static class secp256k1_ecdsa_signature
    extends Structure {
        public byte[] data = new byte[64];
    }

    @Structure.FieldOrder(value={"data"})
    public static class secp256k1_pubkey
    extends Structure {
        public byte[] data = new byte[64];
    }

    public static interface secp256k1_nonce_function
    extends Callback {
        public int apply(Pointer var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5, int var6);
    }
}

