/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.node.base;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.codec.NftTransferJsonCodec;
import com.hedera.hapi.node.base.codec.NftTransferProtoCodec;
import com.hedera.hapi.node.base.schema.NftTransferSchema;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class NftTransfer {
    public static final Codec<NftTransfer> PROTOBUF = new NftTransferProtoCodec();
    public static final JsonCodec<NftTransfer> JSON = new NftTransferJsonCodec();
    public static final NftTransfer DEFAULT = NftTransfer.newBuilder().build();
    @Nullable
    private final AccountID senderAccountID;
    @Nullable
    private final AccountID receiverAccountID;
    private final long serialNumber;
    private final boolean isApproval;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public NftTransfer(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval) {
        this.$unknownFields = null;
        this.senderAccountID = senderAccountID;
        this.receiverAccountID = receiverAccountID;
        this.serialNumber = serialNumber;
        this.isApproval = isApproval;
    }

    public NftTransfer(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.senderAccountID = senderAccountID;
        this.receiverAccountID = receiverAccountID;
        this.serialNumber = serialNumber;
        this.isApproval = isApproval;
    }

    public AccountID senderAccountID() {
        return this.senderAccountID;
    }

    public AccountID receiverAccountID() {
        return this.receiverAccountID;
    }

    public long serialNumber() {
        return this.serialNumber;
    }

    public boolean isApproval() {
        return this.isApproval;
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.SENDER_ACCOUNT_ID, (Object)this.senderAccountID, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)NftTransferSchema.RECEIVER_ACCOUNT_ID, (Object)this.receiverAccountID, AccountID.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)NftTransferSchema.SERIAL_NUMBER, (long)this.serialNumber, (boolean)true);
            _size += ProtoWriterTools.sizeOfBoolean((FieldDefinition)NftTransferSchema.IS_APPROVAL, (boolean)this.isApproval, (boolean)true);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.senderAccountID != null && !this.senderAccountID.equals(NftTransfer.DEFAULT.senderAccountID)) {
                result = 31 * result + this.senderAccountID.hashCode();
            }
            if (this.receiverAccountID != null && !this.receiverAccountID.equals(NftTransfer.DEFAULT.receiverAccountID)) {
                result = 31 * result + this.receiverAccountID.hashCode();
            }
            if (this.serialNumber != NftTransfer.DEFAULT.serialNumber) {
                result = 31 * result + Long.hashCode(this.serialNumber);
            }
            if (this.isApproval != NftTransfer.DEFAULT.isApproval) {
                result = 31 * result + Boolean.hashCode(this.isApproval);
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        NftTransfer thatObj = (NftTransfer)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.senderAccountID == null && thatObj.senderAccountID != null) {
            return false;
        }
        if (this.senderAccountID != null && !this.senderAccountID.equals(thatObj.senderAccountID)) {
            return false;
        }
        if (this.receiverAccountID == null && thatObj.receiverAccountID != null) {
            return false;
        }
        if (this.receiverAccountID != null && !this.receiverAccountID.equals(thatObj.receiverAccountID)) {
            return false;
        }
        if (this.serialNumber != thatObj.serialNumber) {
            return false;
        }
        if (this.isApproval != thatObj.isApproval) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "NftTransfer[senderAccountID=" + String.valueOf(this.senderAccountID) + ", receiverAccountID=" + String.valueOf(this.receiverAccountID) + ", serialNumber=" + this.serialNumber + ", isApproval=" + this.isApproval + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasSenderAccountID() {
        return this.senderAccountID != null;
    }

    public AccountID senderAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasSenderAccountID() ? this.senderAccountID : defaultValue;
    }

    @NonNull
    public AccountID senderAccountIDOrThrow() {
        return Objects.requireNonNull(this.senderAccountID, "Field senderAccountID is null");
    }

    public void ifSenderAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasSenderAccountID()) {
            ifPresent.accept(this.senderAccountID);
        }
    }

    public boolean hasReceiverAccountID() {
        return this.receiverAccountID != null;
    }

    public AccountID receiverAccountIDOrElse(@NonNull AccountID defaultValue) {
        return this.hasReceiverAccountID() ? this.receiverAccountID : defaultValue;
    }

    @NonNull
    public AccountID receiverAccountIDOrThrow() {
        return Objects.requireNonNull(this.receiverAccountID, "Field receiverAccountID is null");
    }

    public void ifReceiverAccountID(@NonNull Consumer<AccountID> ifPresent) {
        if (this.hasReceiverAccountID()) {
            ifPresent.accept(this.receiverAccountID);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.senderAccountID, this.receiverAccountID, this.serialNumber, this.isApproval, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private AccountID senderAccountID = null;
        @Nullable
        private AccountID receiverAccountID = null;
        private long serialNumber = 0L;
        private boolean isApproval = false;
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval) {
            this.$unknownFields = null;
            this.senderAccountID = senderAccountID;
            this.receiverAccountID = receiverAccountID;
            this.serialNumber = serialNumber;
            this.isApproval = isApproval;
        }

        public Builder(AccountID senderAccountID, AccountID receiverAccountID, long serialNumber, boolean isApproval, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.senderAccountID = senderAccountID;
            this.receiverAccountID = receiverAccountID;
            this.serialNumber = serialNumber;
            this.isApproval = isApproval;
        }

        public NftTransfer build() {
            return new NftTransfer(this.senderAccountID, this.receiverAccountID, this.serialNumber, this.isApproval);
        }

        public Builder senderAccountID(@Nullable AccountID senderAccountID) {
            this.senderAccountID = senderAccountID;
            return this;
        }

        public Builder senderAccountID(AccountID.Builder builder) {
            this.senderAccountID = builder.build();
            return this;
        }

        public Builder receiverAccountID(@Nullable AccountID receiverAccountID) {
            this.receiverAccountID = receiverAccountID;
            return this;
        }

        public Builder receiverAccountID(AccountID.Builder builder) {
            this.receiverAccountID = builder.build();
            return this;
        }

        public Builder serialNumber(long serialNumber) {
            this.serialNumber = serialNumber;
            return this;
        }

        public Builder isApproval(boolean isApproval) {
            this.isApproval = isApproval;
            return this;
        }
    }
}

