/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.hash.VirtualHashListener;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashLeafFlusher;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hiero.base.crypto.Hash;

public class ReconnectHashListener<K extends VirtualKey, V extends VirtualValue>
implements VirtualHashListener<K, V> {
    private final ReconnectHashLeafFlusher<K, V> flusher;

    public ReconnectHashListener(@NonNull ReconnectHashLeafFlusher<K, V> flusher) {
        this.flusher = Objects.requireNonNull(flusher);
    }

    @Override
    public void onHashingStarted(long firstLeafPath, long lastLeafPath) {
        this.flusher.start(firstLeafPath, lastLeafPath);
    }

    @Override
    public void onNodeHashed(long path, Hash hash) {
        this.flusher.updateHash(path, hash);
    }

    @Override
    public void onLeafHashed(VirtualLeafRecord<K, V> leaf) {
        this.flusher.updateLeaf(leaf);
    }

    @Override
    public void onHashingCompleted() {
        this.flusher.finish();
    }
}

