/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.event.linking;

import com.swirlds.common.context.PlatformContext;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.platform.event.linking.AbstractInOrderLinker;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;

public class ConsensusLinker
extends AbstractInOrderLinker {
    private final LongAccumulator missingParentAccumulator;
    private final LongAccumulator generationMismatchAccumulator;
    private final LongAccumulator birthRoundMismatchAccumulator;
    private final LongAccumulator timeCreatedMismatchAccumulator;

    public ConsensusLinker(@NonNull PlatformContext platformContext, @NonNull NodeId selfId) {
        super(platformContext);
        this.missingParentAccumulator = (LongAccumulator)platformContext.getMetrics().getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "missingParents").withDescription("Parent child relationships where a parent was missing"));
        this.generationMismatchAccumulator = (LongAccumulator)platformContext.getMetrics().getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "parentGenerationMismatch").withDescription("Parent child relationships where claimed parent generation did not match actual parent generation"));
        this.birthRoundMismatchAccumulator = (LongAccumulator)platformContext.getMetrics().getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "parentBirthRoundMismatch").withDescription("Parent child relationships where claimed parent birth round did not match actual parent birth round"));
        this.timeCreatedMismatchAccumulator = (LongAccumulator)platformContext.getMetrics().getOrCreate((MetricConfig)new LongAccumulator.Config("platform", "timeCreatedMismatch").withDescription("Parent child relationships where child time created wasn't strictly after parent time created"));
    }

    @Override
    protected void eventHasBecomeAncient(@NonNull EventImpl event) {
        event.clear();
    }

    @Override
    protected void childHasMissingParent(@NonNull PlatformEvent child, @NonNull EventDescriptorWrapper parentDescriptor) {
        super.childHasMissingParent(child, parentDescriptor);
        this.missingParentAccumulator.update(1L);
    }

    @Override
    protected void parentHasIncorrectGeneration(@NonNull PlatformEvent child, @NonNull EventDescriptorWrapper parentDescriptor, @NonNull EventImpl candidateParent) {
        super.parentHasIncorrectGeneration(child, parentDescriptor, candidateParent);
        this.generationMismatchAccumulator.update(1L);
    }

    @Override
    protected void parentHasIncorrectBirthRound(@NonNull PlatformEvent child, @NonNull EventDescriptorWrapper parentDescriptor, @NonNull EventImpl candidateParent) {
        super.parentHasIncorrectBirthRound(child, parentDescriptor, candidateParent);
        this.birthRoundMismatchAccumulator.update(1L);
    }

    @Override
    protected void childTimeIsNotAfterSelfParentTime(@NonNull PlatformEvent child, @NonNull EventImpl candidateParent, @NonNull Instant parentTimeCreated, @NonNull Instant childTimeCreated) {
        super.childTimeIsNotAfterSelfParentTime(child, candidateParent, parentTimeCreated, childTimeCreated);
        this.timeCreatedMismatchAccumulator.update(1L);
    }
}

