/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.recovery.internal;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.utility.AutoCloseableNonThrowing;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.notification.NotificationEngine;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateReference;
import com.swirlds.platform.system.Platform;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Collections;
import java.util.Objects;
import org.hiero.base.crypto.Signature;
import org.hiero.consensus.crypto.PlatformSigner;
import org.hiero.consensus.model.node.KeysAndCerts;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.roster.RosterUtils;

public class RecoveryPlatform
implements Platform,
AutoCloseableNonThrowing {
    private final NodeId selfId;
    private final Roster roster;
    private final AddressBook addressBook;
    private final KeysAndCerts keysAndCerts;
    private final SignedStateReference immutableState = new SignedStateReference();
    private final NotificationEngine notificationEngine;
    private final PlatformContext context;

    public RecoveryPlatform(@NonNull Configuration configuration, @NonNull SignedState initialState, @NonNull NodeId selfId, boolean loadSigningKeys) {
        Objects.requireNonNull(configuration, "configuration must not be null");
        Objects.requireNonNull(initialState, "initialState must not be null");
        this.selfId = Objects.requireNonNull(selfId, "selfId must not be null");
        this.roster = initialState.getRoster();
        this.addressBook = RosterUtils.buildAddressBook((Roster)this.roster);
        this.keysAndCerts = loadSigningKeys ? CryptoStatic.initNodeSecurity(this.addressBook, configuration, Collections.singleton(selfId)).get(selfId) : null;
        this.notificationEngine = NotificationEngine.buildEngine((ThreadManager)AdHocThreadManager.getStaticThreadManager());
        this.context = PlatformContext.create((Configuration)configuration);
        this.setLatestState(initialState);
    }

    public synchronized void setLatestState(SignedState signedState) {
        this.immutableState.set(signedState, "RecoveryPlatform.setLatestState");
    }

    @Override
    public Signature sign(byte[] data) {
        if (this.keysAndCerts == null) {
            throw new UnsupportedOperationException("RecoveryPlatform was not loaded with signing keys, this operation is not supported");
        }
        return new PlatformSigner(this.keysAndCerts).sign(data);
    }

    @Override
    @NonNull
    public PlatformContext getContext() {
        return this.context;
    }

    @Override
    @NonNull
    public NotificationEngine getNotificationEngine() {
        return this.notificationEngine;
    }

    @Override
    @NonNull
    public Roster getRoster() {
        return this.roster;
    }

    @Override
    @NonNull
    public NodeId getSelfId() {
        return this.selfId;
    }

    @Override
    @NonNull
    public <T extends State> AutoCloseableWrapper<T> getLatestImmutableState(@NonNull String reason) {
        ReservedSignedState reservedSignedState = this.immutableState.getAndReserve(reason);
        return new AutoCloseableWrapper((Object)(reservedSignedState.isNull() ? null : reservedSignedState.get().getState()), reservedSignedState::close);
    }

    @Override
    public boolean createTransaction(@NonNull byte[] transaction) {
        return false;
    }

    public void close() {
        this.immutableState.clear();
        this.notificationEngine.shutdown();
    }

    @Override
    public void start() {
    }

    @Override
    public void destroy() {
        this.close();
    }
}

