/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.swirlds.common.FastCopyable;
import com.swirlds.demo.platform.PayloadCfgSimple;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class RandomDelayCfg
implements SelfSerializable,
FastCopyable {
    private static final long CLASS_ID = 4482050423130761048L;
    static Random random = new Random();
    private int[] possibilities;
    private int[] delayType;
    private int[] shortDelayRange;
    private int[] longDelayRange;
    private boolean immutable;
    private static int DEFAULT_MAX_ARRAY_SIZE = 0x100000;

    public int[] getPossibilities() {
        return this.possibilities;
    }

    public void setPossibilities(int[] possibilities) {
        this.possibilities = possibilities;
    }

    public int[] getDelayType() {
        return this.delayType;
    }

    public void setDelayType(int[] delayType) {
        this.delayType = delayType;
    }

    public int[] getShortDelayRange() {
        return this.shortDelayRange;
    }

    public void setShortDelayRange(int[] shortDelayRange) {
        this.shortDelayRange = shortDelayRange;
    }

    public int[] getLongDelayRange() {
        return this.longDelayRange;
    }

    public void setLongDelayRange(int[] longDelayRange) {
        this.longDelayRange = longDelayRange;
    }

    public int getRandomDelay() {
        int delay = 0;
        int randomNumber = random.nextInt(100);
        if (randomNumber < 0 || randomNumber > 100) {
            delay = 0;
        } else {
            try {
                int sum = 0;
                int delayTypeSelected = 0;
                int low = 0;
                int high = 0;
                for (int i = 0; i < this.possibilities.length; ++i) {
                    if (randomNumber >= sum && randomNumber < sum + this.possibilities[i]) {
                        delayTypeSelected = this.delayType[i];
                        break;
                    }
                    sum += this.possibilities[i];
                }
                if (delayTypeSelected == 1) {
                    low = this.shortDelayRange[0];
                    high = this.shortDelayRange[1];
                    delay = ThreadLocalRandom.current().nextInt(low, high + 1);
                } else if (delayTypeSelected == 2) {
                    low = this.longDelayRange[0];
                    high = this.longDelayRange[1];
                    delay = ThreadLocalRandom.current().nextInt(low, high + 1);
                } else {
                    delay = 0;
                }
            }
            catch (ArrayIndexOutOfBoundsException e) {
                e.printStackTrace();
            }
        }
        return delay;
    }

    public PayloadCfgSimple copy() {
        this.throwIfImmutable();
        return null;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeIntArray(this.possibilities);
        out.writeIntArray(this.delayType);
        out.writeIntArray(this.shortDelayRange);
        out.writeIntArray(this.longDelayRange);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.possibilities = in.readIntArray(DEFAULT_MAX_ARRAY_SIZE);
        this.delayType = in.readIntArray(DEFAULT_MAX_ARRAY_SIZE);
        this.shortDelayRange = in.readIntArray(DEFAULT_MAX_ARRAY_SIZE);
        this.longDelayRange = in.readIntArray(DEFAULT_MAX_ARRAY_SIZE);
    }

    public long getClassId() {
        return 4482050423130761048L;
    }

    public int getVersion() {
        return 2;
    }

    public int getMinimumSupportedVersion() {
        return 2;
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    private static class ClassVersion {
        private static final int ORIGINAL = 1;
        private static final int MIGRATE_TO_SERIALIZABLE = 2;

        private ClassVersion() {
        }
    }
}

