/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.state;

import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.config.FileSystemManagerConfig;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.MerkleDbTableConfig;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.platform.config.AddressBookConfig;
import com.swirlds.platform.config.BasicConfig;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.platform.state.service.schemas.V0540RosterBaseSchema;
import com.swirlds.platform.test.fixtures.state.TestMerkleStateRoot;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.MerkleStateRoot;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.disk.OnDiskKeySerializer;
import com.swirlds.state.merkle.disk.OnDiskValueSerializer;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.merkle.singleton.StringLeaf;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.crypto.DigestType;
import org.mockito.BDDMockito;
import org.mockito.Mockito;

public class TestingAppStateInitializer {
    public static final Configuration CONFIGURATION = ConfigurationBuilder.create().withConfigDataType(AddressBookConfig.class).withConfigDataType(BasicConfig.class).withConfigDataType(MerkleDbConfig.class).withConfigDataType(VirtualMapConfig.class).withConfigDataType(TemporaryFileConfig.class).withConfigDataType(StateCommonConfig.class).withConfigDataType(FileSystemManagerConfig.class).build();
    public static final TestingAppStateInitializer DEFAULT = new TestingAppStateInitializer(CONFIGURATION);
    private final Configuration configuration;

    public TestingAppStateInitializer(@NonNull Configuration configuration) {
        this.configuration = Objects.requireNonNull(configuration);
    }

    public static void registerMerkleStateRootClassIds() {
        try {
            ConstructableRegistry registry = ConstructableRegistry.getInstance();
            registry.registerConstructable(new ClassConstructorPair(TestMerkleStateRoot.class, TestMerkleStateRoot::new));
            registry.registerConstructable(new ClassConstructorPair(SingletonNode.class, SingletonNode::new));
            registry.registerConstructable(new ClassConstructorPair(StringLeaf.class, StringLeaf::new));
            registry.registerConstructable(new ClassConstructorPair(VirtualMap.class, () -> new VirtualMap(CONFIGURATION)));
            registry.registerConstructable(new ClassConstructorPair(MerkleDbDataSourceBuilder.class, () -> new MerkleDbDataSourceBuilder(CONFIGURATION)));
            registry.registerConstructable(new ClassConstructorPair(VirtualNodeCache.class, () -> new VirtualNodeCache((VirtualMapConfig)CONFIGURATION.getConfigData(VirtualMapConfig.class))));
            TestingAppStateInitializer.registerConstructablesForSchema(registry, (Schema)new V0540PlatformStateSchema(), "PlatformStateService");
            TestingAppStateInitializer.registerConstructablesForSchema(registry, (Schema)new V0540RosterBaseSchema(), "RosterService");
        }
        catch (ConstructableRegistryException e) {
            throw new IllegalStateException(e);
        }
    }

    private static void registerConstructablesForSchema(@NonNull ConstructableRegistry registry, @NonNull Schema schema, @NonNull String name) {
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateKey)).forEach(def -> StateUtils.registerWithSystem((StateMetadata)new StateMetadata(name, schema, def), (ConstructableRegistry)registry));
    }

    public List<StateChanges.Builder> initStates(@NonNull MerkleNodeState state) {
        ArrayList<StateChanges.Builder> list = new ArrayList<StateChanges.Builder>();
        list.addAll(this.initPlatformState(state));
        list.addAll(this.initRosterState(state));
        return list;
    }

    public List<StateChanges.Builder> initPlatformState(@NonNull MerkleNodeState state) {
        V0540PlatformStateSchema schema = new V0540PlatformStateSchema(config -> SemanticVersion.newBuilder().minor(1).build());
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateKey)).forEach(def -> {
            StateMetadata md = new StateMetadata("PlatformStateService", (Schema)schema, def);
            if (!def.singleton()) {
                throw new IllegalStateException("PlatformStateService only expected to use singleton states");
            }
            state.putServiceStateIfAbsent(md, () -> new SingletonNode(md.serviceName(), md.stateDefinition().stateKey(), md.singletonClassId(), md.stateDefinition().valueCodec(), null));
        });
        MigrationContext mockMigrationContext = (MigrationContext)Mockito.mock(MigrationContext.class);
        WritableStates writableStates = state.getWritableStates("PlatformStateService");
        BDDMockito.given((Object)mockMigrationContext.newStates()).willReturn((Object)writableStates);
        schema.migrate(mockMigrationContext);
        ((CommittableWritableStates)writableStates).commit();
        return Collections.emptyList();
    }

    public List<StateChanges.Builder> initRosterState(@NonNull MerkleNodeState state) {
        if (!(state instanceof MerkleStateRoot)) {
            throw new IllegalArgumentException("Can only be used with MerkleStateRoot instances");
        }
        V0540RosterBaseSchema schema = new V0540RosterBaseSchema();
        schema.statesToCreate().stream().sorted(Comparator.comparing(StateDefinition::stateKey)).forEach(def -> {
            StateMetadata md = new StateMetadata("RosterService", (Schema)schema, def);
            if (def.singleton()) {
                state.putServiceStateIfAbsent(md, () -> new SingletonNode(md.serviceName(), md.stateDefinition().stateKey(), md.singletonClassId(), md.stateDefinition().valueCodec(), null));
            } else if (def.onDisk()) {
                state.putServiceStateIfAbsent(md, () -> {
                    OnDiskKeySerializer keySerializer = new OnDiskKeySerializer(md.onDiskKeySerializerClassId(), md.onDiskKeyClassId(), md.stateDefinition().keyCodec());
                    OnDiskValueSerializer valueSerializer = new OnDiskValueSerializer(md.onDiskValueSerializerClassId(), md.onDiskValueClassId(), md.stateDefinition().valueCodec());
                    MerkleDbTableConfig tableConfig = new MerkleDbTableConfig(1, DigestType.SHA_384, def.maxKeysHint(), 16L);
                    String label = StateMetadata.computeLabel((String)"RosterService", (String)def.stateKey());
                    MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(tableConfig, this.configuration);
                    VirtualMap virtualMap = new VirtualMap(label, (KeySerializer)keySerializer, (ValueSerializer)valueSerializer, (VirtualDataSourceBuilder)dsBuilder, this.configuration);
                    return virtualMap;
                });
            } else {
                throw new IllegalStateException("RosterService only expected to use singleton and onDisk virtual map states");
            }
        });
        MigrationContext mockMigrationContext = (MigrationContext)Mockito.mock(MigrationContext.class);
        WritableStates writableStates = state.getWritableStates("RosterService");
        BDDMockito.given((Object)mockMigrationContext.newStates()).willReturn((Object)writableStates);
        schema.migrate(mockMigrationContext);
        ((CommittableWritableStates)writableStates).commit();
        return Collections.emptyList();
    }
}

