/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats.signing;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.demo.stats.signing.algorithms.ECSecP256K1Algorithm;
import com.swirlds.demo.stats.signing.algorithms.SigningAlgorithm;
import com.swirlds.demo.stats.signing.algorithms.X25519SigningAlgorithm;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.TransactionSignature;

final class TransactionCodec {
    public static final byte APPLICATION_TRANSACTION_MARKER = 1;
    public static final byte NO_ALGORITHM_PRESENT = -1;
    private static final int PREAMBLE_SIZE = 10;
    private static final int TX_PREAMBLE_ID_OFFSET = 0;
    private static final int TX_PREAMBLE_SIGNED_OFFSET = 8;
    private static final int TX_PREAMBLE_SIG_ALG_ID_OFFSET = 9;
    private static final int TX_PREAMBLE_PK_LEN_OFFSET = 10;
    private static final Map<Byte, SigningAlgorithm> activeAlgorithms = new HashMap<Byte, SigningAlgorithm>();
    private static final ECSecP256K1Algorithm EC_SEC_P_256_K_1_ALGORITHM = new ECSecP256K1Algorithm();
    private static final X25519SigningAlgorithm X_25519_SIGNING_ALGORITHM = new X25519SigningAlgorithm();

    TransactionCodec() {
    }

    public static int bufferSize(SigningAlgorithm algorithm, int dataLength) {
        return TransactionCodec.overheadSize(algorithm) + Math.abs(dataLength);
    }

    public static int overheadSize(SigningAlgorithm algorithm) {
        int size = 10;
        if (algorithm != null && algorithm.isAvailable()) {
            size += algorithm.getPublicKeyLength();
            size += algorithm.getSignatureLength();
        }
        return size += 12;
    }

    public static byte[] encode(SigningAlgorithm algorithm, long transactionId, byte[] signature, byte[] data) {
        ByteBuffer buffer = ByteBuffer.allocate(1 + TransactionCodec.bufferSize(algorithm, data != null ? data.length : 0));
        boolean signed = algorithm != null && algorithm.isAvailable() && signature != null && signature.length > 0;
        buffer.put((byte)1).putLong(transactionId).put(signed ? (byte)1 : 0).put(signed ? (byte)algorithm.getId() : (byte)-1).putInt(signed ? algorithm.getPublicKeyLength() : 0);
        if (signed) {
            buffer.put(algorithm.getPublicKey());
        }
        buffer.putInt(signed ? signature.length : 0);
        if (signed) {
            buffer.put(signature);
        }
        buffer.putInt(data != null ? data.length : 0);
        if (data != null) {
            buffer.put(data);
        }
        return buffer.array();
    }

    public static boolean txIsSigned(Bytes tx) {
        if (tx == null) {
            throw new IllegalArgumentException("Invalid Transaction: Null Reference");
        }
        if (tx.length() <= 8L) {
            throw new IllegalArgumentException("Invalid Transaction: Truncated Preamble");
        }
        return tx.getByte(8L) == 1;
    }

    public static long txId(Bytes tx) {
        if (tx == null) {
            throw new IllegalArgumentException("Invalid Transaction: Null Reference");
        }
        if (tx.length() <= 10L) {
            throw new IllegalArgumentException("Invalid Transaction: Truncated Preamble");
        }
        return tx.getLong(0L);
    }

    public static TransactionSignature extractSignature(Bytes tx) {
        boolean signed;
        if (tx == null) {
            throw new IllegalArgumentException("Invalid Transaction: Null Reference");
        }
        if (tx.length() <= 10L) {
            throw new IllegalArgumentException("Invalid Transaction: Truncated Preamble");
        }
        boolean bl = signed = tx.getByte(8L) == 1;
        if (!signed) {
            throw new IllegalStateException("Invalid Signature: Transaction Is Unsigned");
        }
        byte[] txBytes = tx.toByteArray();
        ByteBuffer wrapper = ByteBuffer.wrap(txBytes).position(9);
        byte algorithmId = wrapper.get();
        SigningAlgorithm algorithm = activeAlgorithms.get(algorithmId);
        SignatureType signatureType = algorithm != null ? algorithm.getSignatureType() : SignatureType.ED25519;
        return signatureType == SignatureType.ECDSA_SECP256K1 ? TransactionCodec.readEcdsaSignature(wrapper, algorithm, signatureType) : TransactionCodec.readStandardSignature(wrapper, txBytes, signatureType);
    }

    private static TransactionSignature readStandardSignature(ByteBuffer wrapper, byte[] tx, SignatureType signatureType) {
        int pkLen = wrapper.getInt();
        int pkOffset = wrapper.position();
        wrapper.position(pkOffset + pkLen);
        int sigLen = wrapper.getInt();
        int sigOffset = wrapper.position();
        wrapper.position(sigOffset + sigLen);
        int dataLen = wrapper.getInt();
        int dataOffset = wrapper.position();
        return new TransactionSignature(Bytes.wrap((byte[])tx, (int)dataOffset, (int)dataLen), Bytes.wrap((byte[])tx, (int)pkOffset, (int)pkLen), Bytes.wrap((byte[])tx, (int)sigOffset, (int)sigLen), signatureType);
    }

    private static TransactionSignature readEcdsaSignature(ByteBuffer wrapper, SigningAlgorithm algorithm, SignatureType signatureType) {
        int pkLen = wrapper.getInt();
        byte[] pk = new byte[pkLen];
        wrapper.get(pk);
        int sigLen = wrapper.getInt();
        byte[] sig = new byte[sigLen];
        wrapper.get(sig);
        int dataLen = wrapper.getInt();
        byte[] data = new byte[dataLen];
        wrapper.get(data);
        byte[] dataHash = algorithm.hash(data, 0, data.length);
        ByteBuffer sigPayload = ByteBuffer.allocate(pkLen + sigLen + dataHash.length);
        sigPayload.put(pk).put(sig).put(dataHash);
        return new TransactionSignature(Bytes.wrap((byte[])dataHash), Bytes.wrap((byte[])pk), Bytes.wrap((byte[])sig), signatureType);
    }

    static {
        activeAlgorithms.put(EC_SEC_P_256_K_1_ALGORITHM.getId(), EC_SEC_P_256_K_1_ALGORITHM);
        activeAlgorithms.put(X_25519_SIGNING_ALGORITHM.getId(), X_25519_SIGNING_ALGORITHM);
        X_25519_SIGNING_ALGORITHM.tryAcquirePrimitives();
        EC_SEC_P_256_K_1_ALGORITHM.tryAcquirePrimitives();
    }
}

