/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.threading;

import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.threading.pool.CachedPoolParallelExecutor;
import com.swirlds.common.threading.pool.ParallelExecutionException;
import com.swirlds.common.threading.pool.ParallelExecutor;
import java.util.concurrent.Callable;

public class ReplaceSyncPhaseParallelExecutor
implements ParallelExecutor {
    private static final int NUMBER_OF_PHASES = 3;
    private final ParallelExecutor executor;
    private volatile int phase;
    private final int phaseToReplace;
    private final int taskNumToReplace;
    private Callable<Void> replacementTask;

    public ReplaceSyncPhaseParallelExecutor(ThreadManager threadManager, int phaseToReplace, int taskNumToReplace, Callable<Void> replacementTask) {
        this.phaseToReplace = phaseToReplace;
        this.taskNumToReplace = taskNumToReplace;
        this.replacementTask = replacementTask;
        this.executor = new CachedPoolParallelExecutor(threadManager, "sync-phase-thread");
        this.phase = 1;
    }

    private void incPhase() {
        this.phase = this.phase % 3 + 1;
    }

    public int getPhase() {
        return this.phase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T doParallel(Callable<T> task1, Callable<Void> task2) throws ParallelExecutionException {
        try {
            if (this.phase == this.phaseToReplace) {
                if (this.taskNumToReplace == 1) {
                    this.executor.doParallel(this.replacementTask, task2);
                    T t = null;
                    return t;
                }
                Object object = this.executor.doParallel(task1, this.replacementTask);
                return (T)object;
            }
            Object object = this.executor.doParallel(task1, task2);
            return (T)object;
        }
        finally {
            this.incPhase();
        }
    }

    public boolean isImmutable() {
        return this.executor.isImmutable();
    }

    public void start() {
        this.executor.start();
    }
}

