/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.cache;

import com.swirlds.logging.legacy.LogMarker;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterators;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.concurrent.futures.StandardFuture;

final class ConcurrentArray<T> {
    private static final Logger logger = LogManager.getLogger(ConcurrentArray.class);
    private static final int DEFAULT_ELEMENT_ARRAY_LENGTH = 1024;
    private SubArray<T> head;
    private SubArray<T> tail;
    private final AtomicInteger elementCount = new AtomicInteger(0);
    private final AtomicBoolean immutable = new AtomicBoolean(false);
    private final int subarrayCapacity;

    ConcurrentArray() {
        this(1024);
    }

    ConcurrentArray(int capacity) {
        if (capacity <= 0) {
            throw new IllegalArgumentException("The capacity must be > 0");
        }
        this.subarrayCapacity = capacity;
        this.head = new SubArray(capacity);
        this.tail = this.head;
    }

    ConcurrentArray(Stream<T> from) {
        this();
        from.forEach(this::addImpl);
        SubArray<T> t = this.head;
        int size = 0;
        while (t != this.tail) {
            size += this.subarrayCapacity;
            t = t.next;
        }
        this.elementCount.addAndGet(size + this.tail.size.get());
        this.seal();
    }

    void merge(ConcurrentArray<T> other) {
        Objects.requireNonNull(other);
        if (!this.isImmutable() || !other.isImmutable()) {
            throw new IllegalArgumentException("Both arrays *must* be immutable");
        }
        if (other == this) {
            throw new IllegalArgumentException("Can not merge with itself");
        }
        if (this.elementCount.get() == 0) {
            this.head = other.head;
            this.tail = other.tail;
        } else if (other.elementCount.get() > 0) {
            this.tail.next = other.head;
            this.tail = other.tail;
        }
        this.elementCount.addAndGet(other.size());
    }

    ConcurrentArray<T> seal() {
        this.immutable.set(true);
        return this;
    }

    boolean isImmutable() {
        return this.immutable.get();
    }

    public int size() {
        return this.elementCount.get();
    }

    T get(int index) {
        int size = this.size();
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException("index " + index + " is out of bounds (0, " + size + "]");
        }
        int count = 0;
        SubArray<T> cur = this.head;
        while (cur != null) {
            int arrSize = cur.size.get();
            if (index >= count + arrSize) {
                count += arrSize;
            } else {
                return cur.get(index - count);
            }
            cur = cur.next;
        }
        throw new NoSuchElementException("Not able to find an element by that index");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(T element) {
        Objects.requireNonNull(element);
        if (this.immutable.get()) {
            throw new IllegalStateException("You can not call add on a immutable ConcurrentArray");
        }
        boolean success = this.tail.add(element);
        if (!success) {
            ConcurrentArray concurrentArray = this;
            synchronized (concurrentArray) {
                this.addImpl(element);
            }
        }
        this.elementCount.incrementAndGet();
    }

    private void addImpl(T element) {
        boolean success = this.tail.add(element);
        if (!success) {
            SubArray<T> newArray = new SubArray<T>(this.subarrayCapacity);
            success = newArray.add(element);
            assert (success);
            this.tail.next = newArray;
            this.tail = this.tail.next;
        }
    }

    Stream<T> stream() {
        if (!this.immutable.get()) {
            throw new IllegalStateException("You can not call stream() on a mutable ConcurrentArray");
        }
        int numberOfElements = this.elementCount.get();
        if (numberOfElements == 0) {
            return Stream.empty();
        }
        return StreamSupport.stream(new ConcurrentArraySpliterator<T>(numberOfElements, this.head), false);
    }

    public StandardFuture<Void> parallelTraverse(Executor executor, Consumer<T> action) {
        int size;
        if (!this.isImmutable()) {
            throw new IllegalArgumentException("You can not call parallelTraverse on a mutable ConcurrentArray");
        }
        StandardFuture result = new StandardFuture();
        AtomicBoolean exceptionThrown = new AtomicBoolean(false);
        AtomicInteger count = new AtomicInteger(1);
        int numberOfElements = this.elementCount.get();
        SubArray<T> cur = this.head;
        for (int nextIndex = 0; cur != null && nextIndex < numberOfElements; nextIndex += size) {
            count.incrementAndGet();
            Object[] array = cur.array;
            size = cur.size.get();
            executor.execute(() -> {
                block4: {
                    try {
                        for (int i = 0; i < size; ++i) {
                            action.accept(array[i]);
                        }
                        if (count.decrementAndGet() == 0) {
                            result.complete(null);
                        }
                    }
                    catch (Exception e) {
                        logger.error(LogMarker.EXCEPTION.getMarker(), "Exception in parallelTraverse", (Throwable)e);
                        if (!exceptionThrown.compareAndSet(false, true)) break block4;
                        result.cancelWithError((Throwable)e);
                    }
                }
            });
            cur = cur.next;
        }
        if (count.decrementAndGet() == 0) {
            result.complete(null);
        }
        return result;
    }

    private static class SubArray<T> {
        private final T[] array;
        private final AtomicInteger size = new AtomicInteger(0);
        private SubArray<T> next;

        public SubArray(int capacity) {
            this.array = new Object[capacity];
        }

        T get(int index) {
            return this.array[index];
        }

        boolean add(T element) {
            int index = this.size.getAndIncrement();
            if (index >= this.array.length) {
                this.size.decrementAndGet();
                return false;
            }
            this.array[index] = element;
            return true;
        }
    }

    private static class ConcurrentArraySpliterator<T>
    extends Spliterators.AbstractSpliterator<T> {
        private SubArray<T> arr;
        private int arrIndex = 0;

        ConcurrentArraySpliterator(int size, SubArray<T> head) {
            super(size, 5440);
            this.arr = head;
            this.skipEmpty();
        }

        @Override
        public boolean tryAdvance(Consumer<? super T> action) {
            if (this.arr == null) {
                return false;
            }
            action.accept(this.arr.array[this.arrIndex++]);
            if (this.arrIndex == this.arr.size.get()) {
                this.arr = this.arr.next;
                this.skipEmpty();
            }
            return true;
        }

        private void skipEmpty() {
            while (this.arr != null && this.arr.size.get() == 0) {
                this.arr = this.arr.next;
            }
            this.arrIndex = 0;
        }
    }
}

