/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.EventConsensusData;
import com.hedera.hapi.platform.event.EventCore;
import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.base.utility.ToStringBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import org.hiero.base.crypto.AbstractSerializableHashable;
import org.hiero.base.crypto.RunningHash;
import org.hiero.base.crypto.RunningHashable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.stream.StreamAligned;
import org.hiero.consensus.model.stream.Timestamped;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class CesEvent
extends AbstractSerializableHashable
implements RunningHashable,
StreamAligned,
Timestamped,
ConsensusEvent {
    public static final long UNDEFINED = -1L;
    public static final long CLASS_ID = -2139022923795222086L;
    private static final int CES_EVENT_VERSION_PBJ_EVENT = 2;
    private static final int CONSENSUS_DATA_CLASS_VERSION = 2;
    private PlatformEvent platformEvent;
    private final RunningHash runningHash = new RunningHash();
    private long roundReceived = -1L;
    private boolean lastInRoundReceived = false;

    public CesEvent() {
    }

    public CesEvent(@NonNull PlatformEvent platformEvent, long roundReceived, boolean lastInRoundReceived) {
        Objects.requireNonNull(platformEvent);
        this.platformEvent = platformEvent;
        this.roundReceived = roundReceived;
        this.lastInRoundReceived = lastInRoundReceived;
    }

    public void serialize(@NonNull SerializableDataOutputStream out) throws IOException {
        Objects.requireNonNull(out);
        Objects.requireNonNull(this.platformEvent);
        out.writePbjRecord((Object)this.platformEvent.getGossipEvent(), GossipEvent.PROTOBUF);
        out.writeInt(2);
        out.writeLong(-1L);
        out.writeLong(-1L);
        out.writeBoolean(false);
        out.writeBoolean(this.lastInRoundReceived);
        out.writeInstant(this.platformEvent.getConsensusTimestamp());
        out.writeLong(this.roundReceived);
        out.writeLong(this.platformEvent.getConsensusOrder());
    }

    /*
     * Unable to fully structure code
     */
    public void deserialize(@NonNull SerializableDataInputStream in, int version) throws IOException {
        switch (version) {
            case 2: {
                ** break;
            }
            default: {
                throw new IOException("Unsupported version " + version);
            }
lbl-1000:
            // 1 sources

            {
                this.platformEvent = new PlatformEvent((GossipEvent)in.readPbjRecord(GossipEvent.PROTOBUF));
            }
        }
        in.readInt();
        in.readLong();
        in.readLong();
        in.readBoolean();
        this.lastInRoundReceived = in.readBoolean();
        consensusTimestamp = in.readInstant();
        this.roundReceived = in.readLong();
        consensusOrder = in.readLong();
        eventConsensusData = EventConsensusData.newBuilder().consensusTimestamp(HapiUtils.asTimestamp((Instant)consensusTimestamp)).consensusOrder(consensusOrder).build();
        this.platformEvent.setConsensusData(eventConsensusData);
    }

    public RunningHash getRunningHash() {
        return this.runningHash;
    }

    public PlatformEvent getPlatformEvent() {
        return this.platformEvent;
    }

    @Override
    @NonNull
    public Iterator<ConsensusTransaction> consensusTransactionIterator() {
        return this.platformEvent.consensusTransactionIterator();
    }

    @Override
    @NonNull
    public Iterator<EventDescriptorWrapper> allParentsIterator() {
        return this.platformEvent.allParentsIterator();
    }

    @Override
    public long getConsensusOrder() {
        return this.platformEvent.getConsensusOrder();
    }

    @Override
    public Instant getConsensusTimestamp() {
        return this.platformEvent.getConsensusTimestamp();
    }

    @Override
    public Iterator<Transaction> transactionIterator() {
        return this.platformEvent.transactionIterator();
    }

    @Override
    public Instant getTimeCreated() {
        return this.platformEvent.getTimeCreated();
    }

    @Override
    @NonNull
    public NodeId getCreatorId() {
        return this.platformEvent.getCreatorId();
    }

    @Override
    @Deprecated(forRemoval=true)
    @NonNull
    public SemanticVersion getSoftwareVersion() {
        return this.platformEvent.getSoftwareVersion();
    }

    @Override
    public long getBirthRound() {
        return this.platformEvent.getBirthRound();
    }

    @Override
    @NonNull
    public EventCore getEventCore() {
        return this.getPlatformEvent().getEventCore();
    }

    @Override
    @NonNull
    public Bytes getSignature() {
        return this.platformEvent.getSignature();
    }

    public long getRoundReceived() {
        return this.roundReceived;
    }

    public boolean isLastInRoundReceived() {
        return this.lastInRoundReceived;
    }

    public long getClassId() {
        return -2139022923795222086L;
    }

    public int getVersion() {
        return 2;
    }

    @Override
    public Instant getTimestamp() {
        return this.platformEvent.getConsensusTimestamp();
    }

    public int hashCode() {
        return Objects.hash(this.platformEvent, this.roundReceived, this.lastInRoundReceived);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        CesEvent that = (CesEvent)other;
        return Objects.equals(this.platformEvent, that.platformEvent) && this.roundReceived == that.roundReceived && this.lastInRoundReceived == that.lastInRoundReceived;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("platformEvent", (Object)this.platformEvent).append("roundReceived", (Object)this.roundReceived).append("lastInRoundReceived", (Object)this.lastInRoundReceived).toString();
    }
}

