/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures.files;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.swirlds.virtualmap.serialize.BaseSerializer;

public class ExampleVariableSizeDataSerializer
implements BaseSerializer<long[]> {
    public int getSerializedSize() {
        return -1;
    }

    public int getTypicalSerializedSize() {
        return 96;
    }

    public int getSerializedSize(long[] data) {
        return 8 + 8 * data.length;
    }

    public long getCurrentDataVersion() {
        return 1L;
    }

    public void serialize(long[] data, WritableSequentialData out) {
        int dataSizeBytes = 8 + 8 * data.length;
        out.writeLong((long)dataSizeBytes);
        for (long d : data) {
            out.writeLong(d);
        }
    }

    public long[] deserialize(ReadableSequentialData in) {
        int dataSize = (int)in.readLong();
        int repeats = (dataSize - 8) / 8;
        long[] dataItem = new long[repeats];
        for (int i = 0; i < dataItem.length; ++i) {
            dataItem[i] = in.readLong();
        }
        return dataItem;
    }
}

