/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.swirlds.common.utility.IntReference;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.Utilities;
import com.swirlds.platform.consensus.CandidateWitness;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.node.NodeId;

public class RoundElections {
    private static final Logger logger = LogManager.getLogger(RoundElections.class);
    private long round = 1L;
    private final IntReference numUnknownFame = new IntReference(0);
    private final List<CandidateWitness> elections = new ArrayList<CandidateWitness>();
    private long minGeneration = -1L;
    private long minNGen = 0L;
    private long minBirthRound = -1L;

    public long getRound() {
        return this.round;
    }

    public void setRound(long round) {
        if (this.round != 1L) {
            throw new IllegalStateException("We should not set the election round on an instance that has not been reset");
        }
        this.round = round;
    }

    public void addWitness(@NonNull EventImpl witness) {
        if (logger.isDebugEnabled(LogMarker.CONSENSUS_VOTING.getMarker())) {
            logger.debug(LogMarker.CONSENSUS_VOTING.getMarker(), "Adding witness for election {}", (Object)witness.getBaseEvent().getDescriptor());
        }
        this.numUnknownFame.increment();
        this.elections.add(new CandidateWitness(witness, this.numUnknownFame, this.elections.size()));
    }

    public int numElections() {
        return this.elections.size();
    }

    @NonNull
    public Iterator<CandidateWitness> undecidedWitnesses() {
        return this.elections.stream().filter(CandidateWitness::isNotDecided).iterator();
    }

    public boolean isDecided() {
        return this.numUnknownFame.equalsInt(0) && !this.elections.isEmpty();
    }

    public long getMinGeneration() {
        if (this.minGeneration == -1L) {
            throw new IllegalStateException("Cannot provide the minimum generation until all judges are found");
        }
        return this.minGeneration;
    }

    public long getMinNGen() {
        if (this.minNGen == 0L) {
            throw new IllegalStateException("Cannot provide the minimum non-deterministic generation until all judges are found");
        }
        return this.minNGen;
    }

    private long getMinBirthRound() {
        if (this.minBirthRound == -1L) {
            throw new IllegalStateException("Cannot provide the minimum birth round until all judges are found");
        }
        return this.minBirthRound;
    }

    @NonNull
    public MinimumJudgeInfo createMinimumJudgeInfo() {
        return new MinimumJudgeInfo(this.round, this.getMinBirthRound());
    }

    @NonNull
    public List<EventImpl> findAllJudges() {
        if (!this.isDecided()) {
            throw new IllegalStateException("Cannot find all judges if the round has not been decided yet");
        }
        HashMap<NodeId, EventImpl> uniqueFamous = new HashMap<NodeId, EventImpl>();
        for (CandidateWitness election : this.elections) {
            if (!election.isFamous()) continue;
            uniqueFamous.merge(election.getWitness().getCreatorId(), election.getWitness(), RoundElections::uniqueFamous);
        }
        ArrayList<EventImpl> allJudges = new ArrayList<EventImpl>(uniqueFamous.values());
        if (allJudges.isEmpty()) {
            throw new IllegalStateException("No judges found in round " + this.round);
        }
        allJudges.sort(Comparator.comparingLong(e -> e.getCreatorId().id()));
        this.minNGen = Long.MAX_VALUE;
        this.minGeneration = Long.MAX_VALUE;
        this.minBirthRound = Long.MAX_VALUE;
        for (EventImpl judge : allJudges) {
            this.minNGen = Math.min(this.minNGen, judge.getNGen());
            this.minGeneration = Math.min(this.minGeneration, judge.getGeneration());
            this.minBirthRound = Math.min(this.minBirthRound, judge.getBirthRound());
            judge.setJudgeTrue();
        }
        return allJudges;
    }

    @NonNull
    private static EventImpl uniqueFamous(@NonNull EventImpl e1, @Nullable EventImpl e2) {
        if (e2 == null) {
            return e1;
        }
        if (Utilities.arrayCompare(e1.getBaseHash().getBytes(), e2.getBaseHash().getBytes()) < 0) {
            return e1;
        }
        return e2;
    }

    public void startNextElection() {
        ++this.round;
        this.numUnknownFame.set(0);
        this.elections.clear();
        this.minNGen = 0L;
        this.minGeneration = -1L;
        this.minBirthRound = -1L;
    }

    public void reset() {
        this.startNextElection();
        this.round = 1L;
    }
}

