/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stats.signing.algorithms;

import java.util.Objects;

public final class ExtendedSignature {
    private final byte[] signature;
    private final byte[] r;
    private final byte[] s;
    private final boolean ellipticalCurve;

    public ExtendedSignature(byte[] signature) {
        this(signature, null, null);
    }

    public ExtendedSignature(byte[] signature, byte[] r, byte[] s) {
        Objects.requireNonNull(signature, "signature must not be null");
        this.signature = signature;
        this.r = r;
        this.s = s;
        this.ellipticalCurve = r != null && r.length > 0 && s != null && s.length > 0;
    }

    public byte[] getSignature() {
        return this.signature;
    }

    public byte[] getR() {
        return this.r;
    }

    public byte[] getS() {
        return this.s;
    }

    public boolean isEllipticalCurve() {
        return this.ellipticalCurve;
    }
}

