/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.hello;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.ParseException;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.demo.hello.HelloSwirldDemoState;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;
import org.hiero.consensus.roster.RosterUtils;

public class HelloSwirldDemoConsensusStateEventHandler
implements ConsensusStateEventHandler<HelloSwirldDemoState> {
    private static final Logger logger = LogManager.getLogger(HelloSwirldDemoConsensusStateEventHandler.class);

    public void onHandleConsensusRound(@NonNull Round round, @NonNull HelloSwirldDemoState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        state.throwIfImmutable();
        round.forEachEventTransaction((event, transaction) -> {
            if (this.areTransactionBytesSystemOnes((Transaction)transaction)) {
                this.consumeSystemTransaction((Transaction)transaction, (Event)event, stateSignatureTransactionCallback);
            }
            this.handleTransaction((Transaction)transaction, state);
        });
    }

    private void handleTransaction(Transaction transaction, HelloSwirldDemoState state) {
        state.getStrings().add(new String(transaction.getApplicationTransaction().toByteArray(), StandardCharsets.UTF_8));
    }

    public void onPreHandle(@NonNull Event event, @NonNull HelloSwirldDemoState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        event.forEachTransaction(t -> {
            if (this.areTransactionBytesSystemOnes((Transaction)t)) {
                this.consumeSystemTransaction((Transaction)t, event, stateSignatureTransactionCallback);
            }
        });
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull HelloSwirldDemoState state) {
        return true;
    }

    public void onStateInitialized(@NonNull HelloSwirldDemoState state, @NonNull Platform platform, @NonNull InitTrigger trigger, @Nullable SemanticVersion previousVersion) {
    }

    public void onUpdateWeight(@NonNull HelloSwirldDemoState state, @NonNull AddressBook configAddressBook, @NonNull PlatformContext context) {
    }

    public void onNewRecoveredState(@NonNull HelloSwirldDemoState recoveredState) {
    }

    private void consumeSystemTransaction(Transaction transaction, Event event, Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            StateSignatureTransaction stateSignatureTransaction = (StateSignatureTransaction)StateSignatureTransaction.PROTOBUF.parse(transaction.getApplicationTransaction());
            stateSignatureTransactionCallback.accept((ScopedSystemTransaction<StateSignatureTransaction>)new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), (Object)stateSignatureTransaction));
        }
        catch (ParseException e) {
            logger.error("Failed to parse StateSignatureTransaction", (Throwable)e);
        }
    }

    private boolean areTransactionBytesSystemOnes(Transaction transaction) {
        String exampleName = RosterUtils.formatNodeName((long)Long.MAX_VALUE);
        return transaction.getApplicationTransaction().length() > (long)exampleName.length();
    }
}

