/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.TreeView;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.VirtualStateAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import java.util.Objects;

public abstract class VirtualTreeViewBase<K extends VirtualKey, V extends VirtualValue>
implements TreeView<Long> {
    protected final VirtualRootNode<K, V> root;
    protected final VirtualStateAccessor reconnectState;
    protected final VirtualStateAccessor originalState;

    protected VirtualTreeViewBase(VirtualRootNode<K, V> root, VirtualStateAccessor originalState, VirtualStateAccessor reconnectState) {
        this.root = Objects.requireNonNull(root);
        this.originalState = Objects.requireNonNull(originalState);
        this.reconnectState = Objects.requireNonNull(reconnectState);
    }

    public MerkleNode getMerkleRoot(Long node) {
        if (node == null || node == 0L) {
            return this.root;
        }
        throw new UnsupportedOperationException("Nested virtual maps not supported " + node);
    }

    public boolean isInternal(Long node, boolean isOriginal) {
        if (node == null) {
            return false;
        }
        VirtualStateAccessor state = isOriginal ? this.originalState : this.reconnectState;
        this.checkValidNode(node, state);
        return node == 0L || node > 0L && node < state.getFirstLeafPath();
    }

    public int getNumberOfChildren(Long originalNode) {
        this.checkValidNode(originalNode, this.originalState);
        if (originalNode >= this.originalState.getFirstLeafPath()) {
            return 0;
        }
        if (originalNode == 0L) {
            long lastLeafPath = this.originalState.getLastLeafPath();
            if (lastLeafPath > 1L) {
                return 2;
            }
            if (lastLeafPath == 1L) {
                return 1;
            }
            return 0;
        }
        return 2;
    }

    public long getClassId(Long originalNode) {
        this.checkValidNode(originalNode, this.originalState);
        if (originalNode >= this.originalState.getLastLeafPath()) {
            return 5302557153892697290L;
        }
        if (originalNode > 0L) {
            return -5826388714229745985L;
        }
        return 5367589755328273141L;
    }

    public Long getChild(Long originalParent, int childIndex) {
        this.checkValidInternal(originalParent, this.originalState);
        assert (childIndex >= 0 && childIndex < 2) : "childIndex was not 1 or 2";
        long childPath = childIndex == 0 ? Path.getLeftChildPath(originalParent) : Path.getRightChildPath(originalParent);
        return childPath > this.originalState.getLastLeafPath() ? null : Long.valueOf(childPath);
    }

    protected void checkValidNode(Long node, VirtualStateAccessor state) {
        if (node != 0L && (node <= 0L || node > state.getLastLeafPath())) {
            throw new MerkleSynchronizationException("node path out of bounds. path=" + node + ", lastLeafPath=" + state.getLastLeafPath());
        }
    }

    protected void checkValidInternal(Long node, VirtualStateAccessor state) {
        if (node != 0L && (node <= 0L || node >= state.getFirstLeafPath())) {
            throw new MerkleSynchronizationException("internal path out of bounds. path=" + node);
        }
    }

    protected void checkValidLeaf(Long node, VirtualStateAccessor state) {
        if (node < state.getFirstLeafPath() || node > state.getLastLeafPath()) {
            throw new MerkleSynchronizationException("leaf path out of bounds. path=" + node);
        }
    }
}

