/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.crypto;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.util.Objects;
import org.hiero.base.crypto.CryptographyException;
import org.hiero.base.crypto.Hash;
import org.hiero.base.crypto.Signature;
import org.hiero.base.crypto.SignatureType;
import org.hiero.base.crypto.Signer;
import org.hiero.consensus.crypto.CryptoConstants;
import org.hiero.consensus.exceptions.PlatformConstructionException;
import org.hiero.consensus.model.node.KeysAndCerts;

public class PlatformSigner
implements Signer {
    private final java.security.Signature signature;

    public PlatformSigner(@NonNull KeysAndCerts keysAndCerts) {
        try {
            Objects.requireNonNull(keysAndCerts, "keysAndCerts must not be null");
            java.security.Signature s = java.security.Signature.getInstance("SHA384withRSA", CryptoConstants.SIG_PROVIDER);
            s.initSign(keysAndCerts.sigKeyPair().getPrivate());
            this.signature = s;
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | NoSuchProviderException e) {
            throw new PlatformConstructionException(e);
        }
    }

    @NonNull
    public Signature sign(@NonNull byte[] data) {
        try {
            this.signature.update(data);
            return new Signature(SignatureType.RSA, this.signature.sign());
        }
        catch (SignatureException e) {
            throw new CryptographyException("Unexpected exception occurred while signing!", (Throwable)e, LogMarker.EXCEPTION);
        }
    }

    @NonNull
    private Signature signBytes(@NonNull Bytes data) {
        try {
            data.updateSignature(this.signature);
            return new Signature(SignatureType.RSA, this.signature.sign());
        }
        catch (SignatureException e) {
            throw new CryptographyException("Unexpected exception occurred while signing!", (Throwable)e, LogMarker.EXCEPTION);
        }
    }

    @NonNull
    public Signature sign(@NonNull Hash hash) {
        Objects.requireNonNull(hash, "hash must not be null");
        return this.signBytes(hash.getBytes());
    }

    @NonNull
    public Bytes signImmutable(@NonNull Hash hash) {
        try {
            hash.getBytes().updateSignature(this.signature);
            return Bytes.wrap((byte[])this.signature.sign());
        }
        catch (SignatureException e) {
            throw new CryptographyException((Throwable)e);
        }
    }
}

