/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.map.account;

import com.hedera.pbj.runtime.io.ReadableSequentialData;
import com.hedera.pbj.runtime.io.WritableSequentialData;
import com.swirlds.virtualmap.VirtualValue;
import java.io.IOException;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public class AccountVirtualMapValue
implements VirtualValue {
    private static final long CLASS_ID = -2987475432607502347L;
    private long balance;
    private long sendThreshold;
    private long receiveThreshold;
    private boolean requireSignature;
    private long uid;

    public AccountVirtualMapValue() {
        this(0L, 0L, 0L, false, 0L);
    }

    public AccountVirtualMapValue(long balance, long sendThreshold, long receiveThreshold, boolean requireSignature, long uid) {
        this.balance = balance;
        this.sendThreshold = sendThreshold;
        this.receiveThreshold = receiveThreshold;
        this.requireSignature = requireSignature;
        this.uid = uid;
    }

    public AccountVirtualMapValue(AccountVirtualMapValue accountVirtualMapValue) {
        this.balance = accountVirtualMapValue.balance;
        this.sendThreshold = accountVirtualMapValue.sendThreshold;
        this.receiveThreshold = accountVirtualMapValue.receiveThreshold;
        this.requireSignature = accountVirtualMapValue.requireSignature;
        this.uid = accountVirtualMapValue.uid;
    }

    public int getVersion() {
        return 1;
    }

    public long getClassId() {
        return -2987475432607502347L;
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.balance);
        out.writeLong(this.sendThreshold);
        out.writeLong(this.receiveThreshold);
        out.write((int)this.getRequireSignatureAsByte());
        out.writeLong(this.uid);
    }

    void serialize(WritableSequentialData out) {
        out.writeLong(this.balance);
        out.writeLong(this.sendThreshold);
        out.writeLong(this.receiveThreshold);
        out.writeByte(this.getRequireSignatureAsByte());
        out.writeLong(this.uid);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.balance = in.readLong();
        this.sendThreshold = in.readLong();
        this.receiveThreshold = in.readLong();
        this.requireSignature = in.readByte() == 1;
        this.uid = in.readLong();
    }

    void deserialize(ReadableSequentialData in) {
        this.balance = in.readLong();
        this.sendThreshold = in.readLong();
        this.receiveThreshold = in.readLong();
        this.requireSignature = in.readByte() == 1;
        this.uid = in.readLong();
    }

    public VirtualValue copy() {
        return new AccountVirtualMapValue(this);
    }

    public VirtualValue asReadOnly() {
        return new AccountVirtualMapValue(this);
    }

    public String toString() {
        return "AccountVirtualMapValue{balance=" + this.balance + ", sendThreshold=" + this.sendThreshold + ", receiveThreshold=" + this.receiveThreshold + ", requireSignature=" + this.requireSignature + ", uid=" + this.uid + "}";
    }

    private byte getRequireSignatureAsByte() {
        return (byte)(this.requireSignature ? 1 : 0);
    }

    public long getBalance() {
        return this.balance;
    }

    public long getSendThreshold() {
        return this.sendThreshold;
    }

    public long getReceiveThreshold() {
        return this.receiveThreshold;
    }

    public boolean isRequireSignature() {
        return this.requireSignature;
    }

    public long getUid() {
        return this.uid;
    }

    public static int getSizeInBytes() {
        return 33;
    }

    private static final class ClassVersion {
        public static final int ORIGINAL = 1;

        private ClassVersion() {
        }
    }
}

