/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.consensus.ConsensusConfig;
import com.swirlds.platform.consensus.RoundCalculationUtils;
import com.swirlds.platform.consensus.RoundElections;
import com.swirlds.platform.consensus.SequentialRingBuffer;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.LongStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.roster.RosterUtils;

public class ConsensusRounds {
    private static final Logger logger = LogManager.getLogger(ConsensusRounds.class);
    private final ConsensusConfig config;
    private final SequentialRingBuffer<MinimumJudgeInfo> minimumJudgeStorage;
    private final Map<Long, RosterEntry> rosterEntryMap;
    private long maxRoundCreated = -1L;
    private final RoundElections roundElections = new RoundElections();
    private long ancientThreshold = -1L;
    private long consensusRelevantNGen = 0L;

    public ConsensusRounds(@NonNull ConsensusConfig config, @NonNull Roster roster) {
        this.config = Objects.requireNonNull(config);
        this.minimumJudgeStorage = new SequentialRingBuffer(1L, config.roundsExpired() * 2);
        this.rosterEntryMap = RosterUtils.toMap((Roster)Objects.requireNonNull(roster));
        this.reset();
    }

    public void reset() {
        this.minimumJudgeStorage.reset(1L);
        this.maxRoundCreated = -1L;
        this.roundElections.reset();
        this.updateAncientThreshold();
        this.consensusRelevantNGen = 0L;
    }

    public long getFameDecidedBelow() {
        return this.roundElections.getRound();
    }

    public void newWitness(@NonNull EventImpl witness) {
        this.maxRoundCreated = Math.max(witness.getRoundCreated(), this.maxRoundCreated);
        if (!this.isElectionRound(witness.getRoundCreated())) {
            return;
        }
        if (this.maxRoundCreated >= witness.getRoundCreated() + 2L || !this.rosterEntryMap.containsKey(witness.getCreatorId().id())) {
            witness.setFamous(false);
            witness.setFameDecided(true);
            return;
        }
        this.roundElections.addWitness(witness);
    }

    public void recalculating() {
        this.maxRoundCreated = this.getLastRoundDecided();
    }

    public boolean isOlderThanDecidedRoundGeneration(@NonNull EventImpl event) {
        return this.consensusRelevantNGen > event.getNGen();
    }

    public void setConsensusRelevantNGen(long consensusRelevantNGen) {
        this.consensusRelevantNGen = consensusRelevantNGen;
    }

    private boolean isAnyRoundDecided() {
        return this.roundElections.getRound() > 1L;
    }

    public void currentElectionDecided() {
        this.minimumJudgeStorage.add(this.roundElections.getRound(), this.roundElections.createMinimumJudgeInfo());
        this.consensusRelevantNGen = this.roundElections.getMinNGen();
        this.roundElections.startNextElection();
        this.minimumJudgeStorage.removeOlderThan(this.getFameDecidedBelow() - (long)this.config.roundsExpired());
        this.updateAncientThreshold();
    }

    public boolean isLastDecidedJudge(@NonNull EventImpl event) {
        return event.isJudge() && event.getRoundCreated() == this.getLastRoundDecided();
    }

    private long getLastRoundDecided() {
        return this.roundElections.getRound() - 1L;
    }

    public long getElectionRoundNumber() {
        return this.roundElections.getRound();
    }

    @NonNull
    public RoundElections getElectionRound() {
        return this.roundElections;
    }

    private boolean isElectionRound(long round) {
        return this.getElectionRoundNumber() == round;
    }

    public void loadFromMinimumJudge(@NonNull List<MinimumJudgeInfo> minimumJudgeInfos) {
        this.minimumJudgeStorage.reset(minimumJudgeInfos.getFirst().round());
        for (MinimumJudgeInfo minimumJudgeInfo : minimumJudgeInfos) {
            this.minimumJudgeStorage.add(minimumJudgeInfo.round(), minimumJudgeInfo);
        }
        this.roundElections.setRound(this.minimumJudgeStorage.getLatest().round() + 1L);
        this.updateAncientThreshold();
    }

    @NonNull
    public List<MinimumJudgeInfo> getMinimumJudgeInfoList() {
        long oldestNonAncientRound = RoundCalculationUtils.getOldestNonAncientRound(this.config.roundsNonAncient(), this.getLastRoundDecided());
        return LongStream.range(oldestNonAncientRound, this.getFameDecidedBelow()).mapToObj(this::getMinimumJudgeIndicator).filter(Objects::nonNull).toList();
    }

    private MinimumJudgeInfo getMinimumJudgeIndicator(long round) {
        MinimumJudgeInfo minimumJudgeInfo = this.minimumJudgeStorage.get(round);
        if (minimumJudgeInfo == null) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Missing round {}. Fame decided below {}, oldest non-ancient round {}", (Object)round, (Object)this.getFameDecidedBelow(), (Object)RoundCalculationUtils.getOldestNonAncientRound(this.config.roundsNonAncient(), this.getLastRoundDecided()));
            return null;
        }
        return minimumJudgeInfo;
    }

    public long getMaxRound() {
        return this.maxRoundCreated;
    }

    public long getExpiredThreshold() {
        MinimumJudgeInfo info = this.minimumJudgeStorage.get(this.minimumJudgeStorage.minIndex());
        return info == null ? -1L : info.minimumJudgeAncientThreshold();
    }

    private void updateAncientThreshold() {
        if (!this.isAnyRoundDecided()) {
            this.ancientThreshold = -1L;
            return;
        }
        long nonAncientRound = RoundCalculationUtils.getOldestNonAncientRound(this.config.roundsNonAncient(), this.getLastRoundDecided());
        MinimumJudgeInfo info = this.minimumJudgeStorage.get(nonAncientRound);
        this.ancientThreshold = info.minimumJudgeAncientThreshold();
    }

    public long getAncientThreshold() {
        return this.ancientThreshold;
    }
}

