/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import com.swirlds.common.io.utility.FileUtils;
import com.swirlds.platform.cli.JrsTestReaderCommand;
import com.swirlds.platform.cli.utils.JtrUtils;
import com.swirlds.platform.testreader.JrsReportData;
import com.swirlds.platform.testreader.JrsTestIdentifier;
import com.swirlds.platform.testreader.JrsTestMetadata;
import com.swirlds.platform.testreader.JrsTestReportGenerator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import picocli.CommandLine;

@CommandLine.Command(name="report", mixinStandardHelpOptions=true, description={"Scrape test data from gcp buckets and generate an HTML report. Equivalent to running 'scrape' followed by 'render'."})
@SubcommandOf(value=JrsTestReaderCommand.class)
public class JrsTestReaderReportCommand
extends AbstractCommand {
    private String bucketPrefix = "gs://swirlds-circleci-jrs-results";
    private String bucketPrefixReplacement = "http://35.247.76.217:8095";
    private List<String> targets;
    private List<Path> outputPaths;
    private int days = 7;
    private Path metadataFile;
    private int threads = 48;

    @CommandLine.Option(names={"-b", "--bucket"}, description={"The gs bucket to scrape data from. Defaults to 'gs://swirlds-circleci-jrs-results'."})
    private void setBucketPrefix(@NonNull String bucketPrefix) {
        this.bucketPrefix = bucketPrefix;
    }

    @CommandLine.Option(names={"-r", "--bucket-replacement"}, description={"The replacement for bucket prefix in order to convert bucket URLs to web links. Defaultsto http://35.247.76.217:8095"})
    private void setBucketPrefixReplacement(@NonNull String bucketPrefix) {
        this.bucketPrefixReplacement = bucketPrefix;
    }

    @CommandLine.Option(names={"-t", "--targets"}, description={"The targets to generate a report for. Branch names or release numbers are valid inputs."})
    private void setTargets(@NonNull List<String> targets) {
        this.targets = new ArrayList<String>();
        this.targets.addAll(targets);
    }

    @CommandLine.Option(names={"-d", "--days"}, description={"Specify the number of days in the past to begin scraping from. Defaults to 7."})
    private void setDays(int days) {
        this.days = days;
    }

    @CommandLine.Option(names={"-o", "--output"}, description={"Specify the paths to the output html files. If not specified, then output path will beautogenerated based on the test directory, and written into the current working directory."})
    private void setOutputPaths(@NonNull List<Path> outputPaths) {
        this.outputPaths = new ArrayList<Path>();
        outputPaths.forEach(outputPath -> this.outputPaths.add(FileUtils.getAbsolutePath((Path)outputPath)));
    }

    @CommandLine.Option(names={"-m", "--metadata"}, description={"Specify the path to the test metadata csv file."})
    private void setMetadataFile(@NonNull Path metadataFile) {
        this.metadataFile = FileUtils.getAbsolutePath((Path)metadataFile);
    }

    @CommandLine.Option(names={"--threads"}, description={"Specify the number of threads to use. Defaults to 48."})
    private void setThreads(int threads) {
        this.threads = threads;
    }

    private JrsTestReaderReportCommand() {
    }

    @NonNull
    private static String interpretTargetDirectory(@NonNull String inputString) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!inputString.contains("/")) {
            stringBuilder.append("swirlds-automation/");
        }
        if (inputString.matches("\\d+")) {
            stringBuilder.append("release/0.");
        }
        stringBuilder.append(inputString);
        return stringBuilder.toString();
    }

    private void generateIndividualReport(@NonNull String testDirectory, @NonNull Path outputPath, @NonNull Map<JrsTestIdentifier, JrsTestMetadata> metadata) {
        if (Files.exists(outputPath, new LinkOption[0])) {
            try {
                Files.delete(outputPath);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        JrsReportData data = JtrUtils.scrapeTestData(this.bucketPrefix, testDirectory, this.days, this.threads);
        JrsTestReportGenerator.generateReport(data, metadata, Instant.now(), this.bucketPrefix, this.bucketPrefixReplacement, outputPath);
    }

    @NonNull
    private static Path autoGenerateOutputDirectoryName(@NonNull String target) {
        String targetWithoutPath = target.substring(target.lastIndexOf("/") + 1);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEEELLLLd").withZone(ZoneId.systemDefault());
        String todayString = formatter.format(Instant.now());
        return FileUtils.getAbsolutePath((Path)Path.of("jtr-" + targetWithoutPath + "-" + todayString + ".html", new String[0]));
    }

    public Integer call() {
        if (this.targets == null) {
            this.targets = List.of("main");
        }
        Map<JrsTestIdentifier, JrsTestMetadata> metadata = JtrUtils.getTestMetadata(this.metadataFile);
        for (int i = 0; i < this.targets.size(); ++i) {
            String target = this.targets.get(i);
            String targetDirectory = JrsTestReaderReportCommand.interpretTargetDirectory(target);
            System.out.println("Generating report for `" + targetDirectory + "`");
            Path outputPath = this.outputPaths != null && this.outputPaths.size() > i ? this.outputPaths.get(i) : JrsTestReaderReportCommand.autoGenerateOutputDirectoryName(target);
            System.out.println("Writing output file to: " + String.valueOf(outputPath));
            this.generateIndividualReport(targetDirectory, outputPath, metadata);
        }
        return 0;
    }
}

