/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.platform;

import com.swirlds.demo.platform.PAYLOAD_TYPE;
import com.swirlds.demo.platform.PayloadProperty;
import com.swirlds.logging.legacy.LogMarker;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PayloadDistribution {
    private static final long VERSION = 1L;
    private static final Logger logger = LogManager.getLogger(PayloadDistribution.class);
    private static final Marker MARKER = MarkerManager.getMarker((String)"DEMO_INFO");
    private static final Marker ERROR = MarkerManager.getMarker((String)"EXCEPTION");
    private PAYLOAD_TYPE[] typeDistribution;
    private int[] sizeDistribution;
    private float[] ratioDistribution;

    public PayloadProperty getPayloadProperty(float randomNumber) {
        if (this.ratioDistribution.length != this.sizeDistribution.length || this.ratioDistribution.length != this.typeDistribution.length) {
            System.out.println("ERROR Payload distribution array is not same size " + this.ratioDistribution.length + this.sizeDistribution.length + this.typeDistribution.length);
            logger.error(LogMarker.EXCEPTION.getMarker(), " Payload distribution array is not same size {} {} {} ", (Object)this.ratioDistribution.length, (Object)this.sizeDistribution.length, (Object)this.typeDistribution.length);
            while (true) {
                // Infinite loop
            }
        }
        PayloadProperty property = new PayloadProperty();
        float sum = 0.0f;
        if (randomNumber < 0.0f || randomNumber > 100.0f) {
            return property;
        }
        try {
            for (int i = 0; i < this.ratioDistribution.length; ++i) {
                if (randomNumber >= sum && randomNumber < sum + this.ratioDistribution[i]) {
                    property.setSize(this.sizeDistribution[i]);
                    property.setType(this.typeDistribution[i]);
                    return property;
                }
                sum += this.ratioDistribution[i];
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "", (Throwable)e);
        }
        return property;
    }

    public PAYLOAD_TYPE[] getTypeDistribution() {
        return this.typeDistribution;
    }

    public void setTypeDistribution(PAYLOAD_TYPE[] typeDistribution) {
        this.typeDistribution = typeDistribution;
    }

    public int[] getSizeDistribution() {
        return this.sizeDistribution;
    }

    public void setSizeDistribution(int[] sizeDistribution) {
        this.sizeDistribution = sizeDistribution;
    }

    public float[] getRatioDistribution() {
        return this.ratioDistribution;
    }

    public void setRatioDistribution(float[] ratioDistribution) {
        this.ratioDistribution = ratioDistribution;
    }

    public void display() {
        logger.info(MARKER, "Size distribution  = " + Arrays.toString(this.sizeDistribution));
        logger.info(MARKER, "Type distribution  = " + Arrays.toString((Object[])this.typeDistribution));
        logger.info(MARKER, "Ratio distribution = " + Arrays.toString(this.ratioDistribution));
    }
}

