/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.stress;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.demo.stress.StressTestingToolConfig;
import com.swirlds.demo.stress.StressTestingToolState;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.system.InitTrigger;
import com.swirlds.platform.system.Platform;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Duration;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.utility.ByteUtils;
import org.hiero.consensus.model.event.ConsensusEvent;
import org.hiero.consensus.model.event.Event;
import org.hiero.consensus.model.hashgraph.Round;
import org.hiero.consensus.model.roster.AddressBook;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.ScopedSystemTransaction;
import org.hiero.consensus.model.transaction.Transaction;

public class StressTestingToolConsensusStateEventHandler
implements ConsensusStateEventHandler<StressTestingToolState> {
    private static final Logger logger = LogManager.getLogger(StressTestingToolConsensusStateEventHandler.class);
    private StressTestingToolConfig config;

    public void onStateInitialized(@NonNull StressTestingToolState state, @NonNull Platform platform, @NonNull InitTrigger trigger, @Nullable SemanticVersion previousVersion) {
        this.config = (StressTestingToolConfig)platform.getContext().getConfiguration().getConfigData(StressTestingToolConfig.class);
    }

    public void onPreHandle(@NonNull Event event, @NonNull StressTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        event.forEachTransaction(transaction -> {
            if (this.areTransactionBytesSystemOnes((Transaction)transaction)) {
                this.consumeSystemTransaction((Transaction)transaction, event, stateSignatureTransactionCallback);
            }
        });
        this.busyWait(this.config.preHandleTime());
    }

    private void busyWait(@NonNull Duration duration) {
        if (!duration.isZero() && !duration.isNegative()) {
            long start = System.nanoTime();
            long nanos = duration.toNanos();
            while (System.nanoTime() - start < nanos) {
            }
        }
    }

    public void onHandleConsensusRound(@NonNull Round round, @NonNull StressTestingToolState state, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        state.throwIfImmutable();
        for (ConsensusEvent event : round) {
            event.consensusTransactionIterator().forEachRemaining(transaction -> {
                if (this.areTransactionBytesSystemOnes((Transaction)transaction)) {
                    this.consumeSystemTransaction((Transaction)transaction, (Event)event, stateSignatureTransactionCallback);
                } else {
                    this.handleTransaction((ConsensusTransaction)transaction, state);
                }
            });
        }
    }

    private void handleTransaction(@NonNull ConsensusTransaction trans, StressTestingToolState state) {
        state.incrementRunningSum(ByteUtils.byteArrayToLong((byte[])trans.getApplicationTransaction().toByteArray(), (int)0));
        this.busyWait(this.config.handleTime());
    }

    public boolean onSealConsensusRound(@NonNull Round round, @NonNull StressTestingToolState state) {
        return true;
    }

    public void onUpdateWeight(@NonNull StressTestingToolState state, @NonNull AddressBook configAddressBook, @NonNull PlatformContext context) {
    }

    public void onNewRecoveredState(@NonNull StressTestingToolState recoveredState) {
    }

    private boolean areTransactionBytesSystemOnes(@NonNull Transaction transaction) {
        Bytes transactionBytes = transaction.getApplicationTransaction();
        if (transactionBytes.length() == 0L) {
            return false;
        }
        return transactionBytes.getByte(0L) != 1;
    }

    private void consumeSystemTransaction(@NonNull Transaction transaction, @NonNull Event event, @NonNull Consumer<ScopedSystemTransaction<StateSignatureTransaction>> stateSignatureTransactionCallback) {
        try {
            StateSignatureTransaction stateSignatureTransaction = (StateSignatureTransaction)StateSignatureTransaction.PROTOBUF.parse(transaction.getApplicationTransaction());
            stateSignatureTransactionCallback.accept((ScopedSystemTransaction<StateSignatureTransaction>)new ScopedSystemTransaction(event.getCreatorId(), event.getBirthRound(), (Object)stateSignatureTransaction));
        }
        catch (ParseException e) {
            logger.error("Failed to parse StateSignatureTransaction", (Throwable)e);
        }
    }
}

