/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.platform.state.codec;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.platform.state.MinimumJudgeInfo;
import com.hedera.hapi.platform.state.schema.ConsensusSnapshotSchema;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ConsensusSnapshotJsonCodec
implements JsonCodec<ConsensusSnapshot> {
    @NonNull
    public ConsensusSnapshot parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            long temp_round = 0L;
            List<Bytes> temp_judge_hashes = Collections.emptyList();
            List temp_minimum_judge_info_list = Collections.emptyList();
            long temp_next_consensus_number = 0L;
            Timestamp temp_consensus_timestamp = null;
            List temp_judge_ids = Collections.emptyList();
            block18: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "round": {
                        temp_round = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "judgeHashes": {
                        temp_judge_hashes = kvPair.value().arr().value().stream().map(v -> Bytes.fromBase64((String)v.STRING().getText())).toList();
                        continue block18;
                    }
                    case "minimumJudgeInfoList": {
                        temp_minimum_judge_info_list = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), MinimumJudgeInfo.JSON, (int)(maxDepth - 1));
                        continue block18;
                    }
                    case "nextConsensusNumber": {
                        temp_next_consensus_number = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block18;
                    }
                    case "consensusTimestamp": {
                        temp_consensus_timestamp = (Timestamp)Timestamp.JSON.parse((JSONParser.ObjContext)kvPair.value().getChild(JSONParser.ObjContext.class, 0), false, maxDepth - 1);
                        continue block18;
                    }
                    case "judgeIds": {
                        temp_judge_ids = JsonTools.parseObjArray((JSONParser.ArrContext)kvPair.value().arr(), JudgeId.JSON, (int)(maxDepth - 1));
                        continue block18;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new ConsensusSnapshot(temp_round, temp_judge_hashes, temp_minimum_judge_info_list, temp_next_consensus_number, temp_consensus_timestamp, temp_judge_ids);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull ConsensusSnapshot data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.round() != 0L) {
            fieldLines.add(JsonTools.field((String)"round", (long)data.round()));
        }
        if (!data.judgeHashes().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)"judgeHashes", (FieldDefinition)ConsensusSnapshotSchema.JUDGE_HASHES, data.judgeHashes()));
        }
        if (!data.minimumJudgeInfoList().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"minimumJudgeInfoList", MinimumJudgeInfo.JSON, data.minimumJudgeInfoList()));
        }
        if (data.nextConsensusNumber() != 0L) {
            fieldLines.add(JsonTools.field((String)"nextConsensusNumber", (long)data.nextConsensusNumber()));
        }
        if (data.consensusTimestamp() != null) {
            fieldLines.add(JsonTools.field((String)childIndent, (String)"consensusTimestamp", Timestamp.JSON, (Object)data.consensusTimestamp()));
        }
        if (!data.judgeIds().isEmpty()) {
            fieldLines.add(JsonTools.arrayField((String)childIndent, (String)"judgeIds", JudgeId.JSON, data.judgeIds()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

