/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.test.fixtures.merkle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.config.FileSystemManagerConfig;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.test.fixtures.merkle.TestMerkleCryptoFactory;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.merkledb.MerkleDb;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.MerkleDbTableConfig;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.merkledb.test.fixtures.MerkleDbTestUtils;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.state.merkle.disk.OnDiskKeySerializer;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.state.merkle.disk.OnDiskValueSerializer;
import com.swirlds.state.merkle.memory.InMemoryKey;
import com.swirlds.state.merkle.memory.InMemoryValue;
import com.swirlds.state.merkle.queue.QueueNode;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.test.fixtures.StateTestBase;
import com.swirlds.state.test.fixtures.TestArgumentUtils;
import com.swirlds.state.test.fixtures.merkle.TestLongCodec;
import com.swirlds.state.test.fixtures.merkle.TestStringCodec;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.constructable.ConstructableUtils;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.stream.Stream;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.base.crypto.DigestType;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.provider.Arguments;

public class MerkleTestBase
extends StateTestBase {
    protected final Configuration CONFIGURATION = ConfigurationBuilder.create().withConfigDataType(VirtualMapConfig.class).withConfigDataType(MerkleDbConfig.class).withConfigDataType(TemporaryFileConfig.class).withConfigDataType(StateCommonConfig.class).withConfigDataType(FileSystemManagerConfig.class).build();
    public static final Codec<String> STRING_CODEC = TestStringCodec.SINGLETON;
    public static final Codec<Long> LONG_CODEC = TestLongCodec.SINGLETON;
    private static final String ON_DISK_KEY_CLASS_ID_SUFFIX = "OnDiskKey";
    private static final String ON_DISK_VALUE_CLASS_ID_SUFFIX = "OnDiskValue";
    private static final String ON_DISK_KEY_SERIALIZER_CLASS_ID_SUFFIX = "OnDiskKeySerializer";
    private static final String ON_DISK_VALUE_SERIALIZER_CLASS_ID_SUFFIX = "OnDiskValueSerializer";
    private static final String IN_MEMORY_VALUE_CLASS_ID_SUFFIX = "InMemoryValue";
    private static final String SINGLETON_CLASS_ID_SUFFIX = "SingletonLeaf";
    private static final String QUEUE_NODE_CLASS_ID_SUFFIX = "QueueNode";
    protected static final MerkleCryptography CRYPTO = TestMerkleCryptoFactory.getInstance();
    public static final long A_LONG_KEY = 0L;
    public static final long B_LONG_KEY = 1L;
    public static final long C_LONG_KEY = 2L;
    public static final long D_LONG_KEY = 3L;
    public static final long E_LONG_KEY = 4L;
    public static final long F_LONG_KEY = 5L;
    public static final long G_LONG_KEY = 6L;
    protected ConstructableRegistry registry;
    @TempDir
    private Path virtualDbPath;
    protected String fruitLabel;
    protected MerkleMap<InMemoryKey<String>, InMemoryValue<String, String>> fruitMerkleMap;
    protected String fruitVirtualLabel;
    protected VirtualMap<OnDiskKey<String>, OnDiskValue<String>> fruitVirtualMap;
    protected String animalLabel;
    protected MerkleMap<InMemoryKey<String>, InMemoryValue<String, String>> animalMerkleMap;
    protected String spaceLabel;
    protected MerkleMap<InMemoryKey<Long>, InMemoryValue<Long, Long>> spaceMerkleMap;
    protected String steamLabel;
    protected QueueNode<String> steamQueue;
    protected String countryLabel;
    protected SingletonNode<String> countrySingleton;

    protected void setupFruitMerkleMap() {
        this.fruitLabel = StateMetadata.computeLabel((String)"First-Service", (String)"FRUIT");
        this.fruitMerkleMap = this.createMerkleMap(this.fruitLabel);
    }

    protected void setupFruitVirtualMap() {
        this.fruitVirtualLabel = StateMetadata.computeLabel((String)"First-Service", (String)"FRUIT");
        this.fruitVirtualMap = this.createVirtualMap(this.fruitVirtualLabel, MerkleTestBase.onDiskKeySerializerClassId("FRUIT"), MerkleTestBase.onDiskKeyClassId("FRUIT"), STRING_CODEC, MerkleTestBase.onDiskValueSerializerClassId("FRUIT"), MerkleTestBase.onDiskValueClassId("FRUIT"), STRING_CODEC);
    }

    protected static long onDiskKeyClassId(String stateKey) {
        return MerkleTestBase.onDiskKeyClassId("First-Service", stateKey);
    }

    protected static long onDiskKeyClassId(String serviceName, String stateKey) {
        return StateMetadata.computeClassId((String)serviceName, (String)stateKey, (SemanticVersion)TEST_VERSION, (String)ON_DISK_KEY_CLASS_ID_SUFFIX);
    }

    protected static long onDiskKeySerializerClassId(String stateKey) {
        return MerkleTestBase.onDiskKeySerializerClassId("First-Service", stateKey);
    }

    protected static long onDiskKeySerializerClassId(String serviceName, String stateKey) {
        return StateMetadata.computeClassId((String)serviceName, (String)stateKey, (SemanticVersion)TEST_VERSION, (String)ON_DISK_KEY_SERIALIZER_CLASS_ID_SUFFIX);
    }

    protected static long onDiskValueClassId(String stateKey) {
        return MerkleTestBase.onDiskValueClassId("First-Service", stateKey);
    }

    protected static long onDiskValueClassId(String serviceName, String stateKey) {
        return StateMetadata.computeClassId((String)serviceName, (String)stateKey, (SemanticVersion)TEST_VERSION, (String)ON_DISK_VALUE_CLASS_ID_SUFFIX);
    }

    protected static long onDiskValueSerializerClassId(String stateKey) {
        return MerkleTestBase.onDiskValueSerializerClassId("First-Service", stateKey);
    }

    protected static long onDiskValueSerializerClassId(String serviceName, String stateKey) {
        return StateMetadata.computeClassId((String)serviceName, (String)stateKey, (SemanticVersion)TEST_VERSION, (String)ON_DISK_VALUE_SERIALIZER_CLASS_ID_SUFFIX);
    }

    protected static long queueNodeClassId(String stateKey) {
        return StateMetadata.computeClassId((String)"First-Service", (String)stateKey, (SemanticVersion)TEST_VERSION, (String)QUEUE_NODE_CLASS_ID_SUFFIX);
    }

    protected static long inMemoryValueClassId(String stateKey) {
        return StateMetadata.computeClassId((String)"First-Service", (String)stateKey, (SemanticVersion)TEST_VERSION, (String)IN_MEMORY_VALUE_CLASS_ID_SUFFIX);
    }

    protected static long singletonClassId(String stateKey) {
        return StateMetadata.computeClassId((String)"First-Service", (String)stateKey, (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX);
    }

    protected void setupAnimalMerkleMap() {
        this.animalLabel = StateMetadata.computeLabel((String)"First-Service", (String)"ANIMAL");
        this.animalMerkleMap = this.createMerkleMap(this.animalLabel);
    }

    protected void setupSpaceMerkleMap() {
        this.spaceLabel = StateMetadata.computeLabel((String)"Second-Service", (String)"SPACE");
        this.spaceMerkleMap = this.createMerkleMap(this.spaceLabel);
    }

    protected void setupSingletonCountry() {
        this.countryLabel = StateMetadata.computeLabel((String)"First-Service", (String)"COUNTRY");
        this.countrySingleton = new SingletonNode("First-Service", "COUNTRY", StateMetadata.computeClassId((String)"First-Service", (String)"COUNTRY", (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX), STRING_CODEC, (Object)"Australia");
    }

    protected void setupSteamQueue() {
        this.steamLabel = StateMetadata.computeLabel((String)"First-Service", (String)"STEAM");
        this.steamQueue = new QueueNode("First-Service", "STEAM", StateMetadata.computeClassId((String)"First-Service", (String)"STEAM", (SemanticVersion)TEST_VERSION, (String)QUEUE_NODE_CLASS_ID_SUFFIX), StateMetadata.computeClassId((String)"First-Service", (String)"STEAM", (SemanticVersion)TEST_VERSION, (String)SINGLETON_CLASS_ID_SUFFIX), STRING_CODEC);
    }

    protected void setupConstructableRegistry() {
        try {
            this.registry = ConstructableRegistry.getInstance();
            this.registry.reset();
            this.registry.registerConstructables("com.swirlds.merklemap");
            this.registry.registerConstructables("com.swirlds.merkledb");
            this.registry.registerConstructables("com.swirlds.fcqueue");
            this.registry.registerConstructables("com.swirlds.virtualmap");
            this.registry.registerConstructables("com.swirlds.common.merkle");
            this.registry.registerConstructables("com.swirlds.common");
            this.registry.registerConstructables("org.hiero");
            this.registry.registerConstructables("com.swirlds.merkle");
            this.registry.registerConstructables("com.swirlds.merkle.tree");
            ConstructableRegistry.getInstance().registerConstructable(new ClassConstructorPair(MerkleDbDataSourceBuilder.class, () -> new MerkleDbDataSourceBuilder(this.CONFIGURATION)));
            ConstructableUtils.registerVirtualMapConstructables((Configuration)this.CONFIGURATION);
        }
        catch (ConstructableRegistryException ex) {
            throw new AssertionError((Object)ex);
        }
    }

    protected <K extends Comparable<K>, V> MerkleMap<InMemoryKey<K>, InMemoryValue<K, V>> createMerkleMap(String label) {
        MerkleMap map = new MerkleMap();
        map.setLabel(label);
        return map;
    }

    protected VirtualMap<OnDiskKey<String>, OnDiskValue<String>> createVirtualMap(String label, long keySerializerClassId, long keyClassId, Codec<String> keyCodec, long valueSerializerClassId, long valueClassId, Codec<String> valueCodec) {
        OnDiskKeySerializer keySerializer = new OnDiskKeySerializer(keySerializerClassId, keyClassId, keyCodec);
        OnDiskValueSerializer valueSerializer = new OnDiskValueSerializer(valueSerializerClassId, valueClassId, valueCodec);
        MerkleDbTableConfig merkleDbTableConfig = new MerkleDbTableConfig(1, DigestType.SHA_384, 100L, 0L);
        MerkleDbDataSourceBuilder builder = new MerkleDbDataSourceBuilder(this.virtualDbPath, merkleDbTableConfig, this.CONFIGURATION);
        return new VirtualMap(label, (KeySerializer)keySerializer, (ValueSerializer)valueSerializer, (VirtualDataSourceBuilder)builder, this.CONFIGURATION);
    }

    protected void add(MerkleMap<InMemoryKey<String>, InMemoryValue<String, String>> map, long inMemoryValueClassId, Codec<String> keyCodec, Codec<String> valueCodec, String key, String value) {
        InMemoryKey k = new InMemoryKey((Object)key);
        map.put((Object)k, (MerkleNode)new InMemoryValue(inMemoryValueClassId, keyCodec, valueCodec, k, (Object)value));
    }

    protected void add(VirtualMap<OnDiskKey<String>, OnDiskValue<String>> map, long onDiskKeyClassId, Codec<String> keyCodec, long onDiskValueClassId, Codec<String> valueCodec, String key, String value) {
        OnDiskKey k = new OnDiskKey(onDiskKeyClassId, keyCodec, (Object)key);
        map.put((VirtualKey)k, (VirtualValue)new OnDiskValue(onDiskValueClassId, valueCodec, (Object)value));
    }

    protected byte[] writeTree(@NonNull MerkleNode tree, @NonNull Path tempDir) throws IOException {
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
        try (MerkleDataOutputStream out = new MerkleDataOutputStream((OutputStream)byteOutputStream);){
            out.writeMerkleTree(tempDir, tree);
        }
        return byteOutputStream.toByteArray();
    }

    protected <T extends MerkleNode> T parseTree(@NonNull byte[] state, @NonNull Path tempDir) throws IOException {
        MerkleDb.resetDefaultInstancePath();
        ByteArrayInputStream byteInputStream = new ByteArrayInputStream(state);
        try (MerkleDataInputStream in = new MerkleDataInputStream((InputStream)byteInputStream);){
            MerkleNode merkleNode = in.readMerkleTree(tempDir, 100);
            return (T)merkleNode;
        }
    }

    public static Stream<Arguments> illegalServiceNames() {
        return TestArgumentUtils.illegalIdentifiers();
    }

    public static Stream<Arguments> legalServiceNames() {
        return TestArgumentUtils.legalIdentifiers();
    }

    @AfterEach
    void cleanUp() {
        MerkleDb.resetDefaultInstancePath();
        if (this.fruitVirtualMap != null && this.fruitVirtualMap.getReservationCount() > -1) {
            this.fruitVirtualMap.release();
        }
        MerkleDbTestUtils.assertAllDatabasesClosed();
    }
}

