/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.common.test.fixtures.map;

import com.swirlds.common.FastCopyable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.junit.jupiter.api.Assertions;

public class MapPair<M extends Map<K, V> & FastCopyable, K, V> {
    private final M fc;
    private final Map<K, V> control;

    public MapPair(M fc, Map<K, V> control) {
        this.fc = fc;
        this.control = control;
    }

    public MapPair<M, K, V> copy() {
        return new MapPair<Map, K, V>((Map)((FastCopyable)this.fc).copy(), new HashMap<K, V>(this.control));
    }

    public void put(K key, V value) {
        this.fc.put(key, value);
        this.control.put(key, value);
    }

    public void remove(K key) {
        this.fc.remove(key);
        this.control.remove(key);
    }

    public M getFc() {
        return this.fc;
    }

    public Map<K, V> getControl() {
        return this.control;
    }

    public void assertValuesEqual() {
        HashSet set = new HashSet(this.fc.values());
        Assertions.assertEquals((int)this.control.size(), (int)set.size());
        this.control.values().forEach(v -> Assertions.assertTrue((boolean)set.contains(v)));
    }

    public void assertKeySetEquals() {
        HashSet set = new HashSet(this.fc.keySet());
        Assertions.assertEquals((int)this.control.size(), (int)set.size());
        this.control.keySet().forEach(v -> Assertions.assertTrue((boolean)set.contains(v)));
    }

    public void assertEntrySetEquals() {
        HashMap map = new HashMap();
        this.fc.entrySet().forEach(e -> map.put(e.getKey(), e.getValue()));
        Assertions.assertEquals((int)this.control.size(), (int)map.size());
        this.control.forEach((k, v) -> {
            Assertions.assertTrue((boolean)map.containsKey(k));
            Assertions.assertEquals((Object)v, map.get(k));
        });
    }

    public void assertContainsValueConsistent() {
        this.control.values().forEach(v -> Assertions.assertTrue((boolean)this.fc.containsValue(v)));
    }
}

