/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.formatting.StringFormattingUtils;
import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.synchronization.LearningSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.logging.legacy.payload.ReconnectDataUsagePayload;
import com.swirlds.platform.crypto.CryptoStatic;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.reconnect.ReconnectException;
import com.swirlds.platform.reconnect.ReconnectUtils;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import com.swirlds.platform.state.signed.SigSet;
import com.swirlds.platform.state.signed.SignedState;
import com.swirlds.platform.state.signed.SignedStateInvalidException;
import com.swirlds.platform.state.signed.SignedStateValidationData;
import com.swirlds.platform.state.signed.SignedStateValidator;
import com.swirlds.platform.state.snapshot.SignedStateFileReader;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.time.Duration;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReconnectLearner {
    private static final Logger logger = LogManager.getLogger(ReconnectLearner.class);
    private final Connection connection;
    private final Roster roster;
    private final MerkleNodeState currentState;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics statistics;
    private final SignedStateValidationData stateValidationData;
    private final PlatformStateFacade platformStateFacade;
    private SigSet sigSet;
    private final PlatformContext platformContext;
    private int originalSocketTimeout;
    private final ThreadManager threadManager;

    public ReconnectLearner(@NonNull PlatformContext platformContext, @NonNull ThreadManager threadManager, @NonNull Connection connection, @NonNull Roster roster, @NonNull MerkleNodeState currentState, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics statistics, @NonNull PlatformStateFacade platformStateFacade) {
        this.platformStateFacade = platformStateFacade;
        currentState.throwIfImmutable("Can not perform reconnect with immutable state");
        currentState.throwIfDestroyed("Can not perform reconnect with destroyed state");
        this.platformContext = Objects.requireNonNull(platformContext);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.connection = Objects.requireNonNull(connection);
        this.roster = Objects.requireNonNull(roster);
        this.currentState = Objects.requireNonNull(currentState);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.statistics = Objects.requireNonNull(statistics);
        this.stateValidationData = new SignedStateValidationData(currentState, roster, platformStateFacade);
    }

    private void increaseSocketTimeout() throws ReconnectException {
        try {
            this.originalSocketTimeout = this.connection.getTimeout();
            this.connection.setTimeout(this.reconnectSocketTimeout.toMillis());
        }
        catch (SocketException e) {
            throw new ReconnectException(e);
        }
    }

    private void resetSocketTimeout() throws ReconnectException {
        if (!this.connection.connected()) {
            logger.debug(LogMarker.RECONNECT.getMarker(), "{} connection to {} is no longer connected. Returning.", (Object)this.connection.getSelfId(), (Object)this.connection.getOtherId());
            return;
        }
        try {
            this.connection.setTimeout(this.originalSocketTimeout);
        }
        catch (SocketException e) {
            throw new ReconnectException(e);
        }
    }

    @NonNull
    public ReservedSignedState execute(@NonNull SignedStateValidator validator) throws ReconnectException {
        this.increaseSocketTimeout();
        ReservedSignedState reservedSignedState = null;
        try {
            this.receiveSignatures();
            reservedSignedState = this.reconnect();
            validator.validate(reservedSignedState.get(), this.roster, this.stateValidationData);
            ReconnectUtils.endReconnectHandshake(this.connection);
            ReservedSignedState reservedSignedState2 = reservedSignedState;
            return reservedSignedState2;
        }
        catch (SignedStateInvalidException | IOException e) {
            if (reservedSignedState != null) {
                reservedSignedState.close();
            }
            throw new ReconnectException(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ReconnectException("interrupted while attempting to reconnect", e);
        }
        finally {
            this.resetSocketTimeout();
        }
    }

    @NonNull
    private ReservedSignedState reconnect() throws InterruptedException {
        this.statistics.incrementReceiverStartTimes();
        MerkleDataInputStream in = new MerkleDataInputStream((InputStream)((Object)this.connection.getDis()));
        MerkleDataOutputStream out = new MerkleDataOutputStream((OutputStream)((Object)this.connection.getDos()));
        this.connection.getDis().getSyncByteCounter().resetCount();
        this.connection.getDos().getSyncByteCounter().resetCount();
        ReconnectConfig reconnectConfig = (ReconnectConfig)this.platformContext.getConfiguration().getConfigData(ReconnectConfig.class);
        LearningSynchronizer synchronizer = new LearningSynchronizer(this.threadManager, in, out, this.currentState.getRoot(), this.connection::disconnect, this.platformContext.getMerkleCryptography(), reconnectConfig, this.platformContext.getMetrics());
        synchronizer.synchronize();
        MerkleNodeState state = (MerkleNodeState)synchronizer.getRoot();
        SignedState newSignedState = new SignedState(this.platformContext.getConfiguration(), CryptoStatic::verifySignature, state, "ReconnectLearner.reconnect()", false, false, false, this.platformStateFacade);
        newSignedState.init(this.platformContext);
        SignedStateFileReader.registerServiceStates(newSignedState);
        newSignedState.setSigSet(this.sigSet);
        double mbReceived = this.connection.getDis().getSyncByteCounter().getMebiBytes();
        logger.info(LogMarker.RECONNECT.getMarker(), () -> new ReconnectDataUsagePayload("Reconnect data usage report", mbReceived).toString());
        this.statistics.incrementReceiverEndTimes();
        return newSignedState.reserve("ReconnectLearner.reconnect()");
    }

    private void receiveSignatures() throws IOException {
        logger.info(LogMarker.RECONNECT.getMarker(), "Receiving signed state signatures");
        this.sigSet = (SigSet)this.connection.getDis().readSerializable();
        StringBuilder sb = new StringBuilder();
        sb.append("Received signatures from nodes ");
        StringFormattingUtils.formattedList((StringBuilder)sb, this.sigSet.iterator());
        logger.info(LogMarker.RECONNECT.getMarker(), (CharSequence)sb);
    }
}

