/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.hello;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.platform.event.StateSignatureTransaction;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.common.Console;
import com.swirlds.common.notification.Listener;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.demo.hello.HelloSwirldDemoConsensusStateEventHandler;
import com.swirlds.demo.hello.HelloSwirldDemoState;
import com.swirlds.platform.Browser;
import com.swirlds.platform.SwirldsPlatform;
import com.swirlds.platform.gui.SwirldsGui;
import com.swirlds.platform.listeners.PlatformStatusChangeListener;
import com.swirlds.platform.listeners.PlatformStatusChangeNotification;
import com.swirlds.platform.state.ConsensusStateEventHandler;
import com.swirlds.platform.state.MerkleNodeState;
import com.swirlds.platform.system.Platform;
import com.swirlds.platform.system.SwirldMain;
import com.swirlds.platform.test.fixtures.state.TestingAppStateInitializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.charset.StandardCharsets;
import org.hiero.base.constructable.ClassConstructorPair;
import org.hiero.base.constructable.ConstructableRegistry;
import org.hiero.base.constructable.ConstructableRegistryException;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.roster.RosterUtils;

public class HelloSwirldDemoMain
implements SwirldMain<HelloSwirldDemoState> {
    public SwirldsPlatform platform;
    public NodeId selfId;
    public Console console;
    public final int sleepPeriod = 100;
    private static final SemanticVersion semanticVersion;

    public static void main(String[] args) {
        Browser.parseCommandLineArgsAndLaunch((String[])args);
    }

    public void init(Platform platform, NodeId id) {
        platform.getNotificationEngine().register(PlatformStatusChangeListener.class, (Listener)((PlatformStatusChangeListener)this::platformStatusChange));
        this.platform = (SwirldsPlatform)platform;
        this.selfId = id;
        int winNum = (int)this.selfId.id();
        this.console = SwirldsGui.createConsole((Platform)platform, (int)winNum, (boolean)true);
    }

    public void run() {
        String lastReceived = "";
        while (true) {
            String received;
            try (AutoCloseableWrapper wrapper = this.platform.getLatestImmutableState("HelloSwirldDemoMain.run()");){
                HelloSwirldDemoState state = (HelloSwirldDemoState)((Object)wrapper.get());
                received = state.getReceived();
            }
            if (!lastReceived.equals(received)) {
                lastReceived = received;
                this.console.out.println("Received: " + received);
            }
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
            }
        }
    }

    @NonNull
    public HelloSwirldDemoState newStateRoot() {
        HelloSwirldDemoState state = new HelloSwirldDemoState();
        TestingAppStateInitializer.DEFAULT.initStates((MerkleNodeState)state);
        return state;
    }

    @NonNull
    public ConsensusStateEventHandler<HelloSwirldDemoState> newConsensusStateEvenHandler() {
        return new HelloSwirldDemoConsensusStateEventHandler();
    }

    private void platformStatusChange(PlatformStatusChangeNotification notification) {
        PlatformStatus newStatus = notification.getNewStatus();
        if (PlatformStatus.ACTIVE.equals((Object)newStatus)) {
            String myName = RosterUtils.formatNodeName((long)this.platform.getSelfId().id());
            this.console.out.println("Hello Swirld from " + myName);
            byte[] transaction = myName.getBytes(StandardCharsets.UTF_8);
            this.platform.createTransaction(transaction);
        }
    }

    public SemanticVersion getSemanticVersion() {
        return semanticVersion;
    }

    public Bytes encodeSystemTransaction(@NonNull StateSignatureTransaction transaction) {
        return StateSignatureTransaction.PROTOBUF.toBytes((Object)transaction);
    }

    static {
        try {
            ConstructableRegistry constructableRegistry = ConstructableRegistry.getInstance();
            constructableRegistry.registerConstructable(new ClassConstructorPair(HelloSwirldDemoState.class, () -> {
                HelloSwirldDemoState helloSwirldDemoState = new HelloSwirldDemoState();
                return helloSwirldDemoState;
            }));
            TestingAppStateInitializer.registerMerkleStateRootClassIds();
        }
        catch (ConstructableRegistryException e) {
            throw new RuntimeException(e);
        }
        semanticVersion = SemanticVersion.newBuilder().major(1).build();
    }
}

