/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb;

import com.swirlds.merkledb.MerkleDbDataSource;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import java.util.ArrayList;
import org.hiero.base.crypto.Hash;

public class DataSourceValidator<K extends VirtualKey, V extends VirtualValue> {
    private static final String WHITESPACE = " ".repeat(20);
    private final KeySerializer<K> keySerializer;
    private final ValueSerializer<V> valueSerializer;
    private final MerkleDbDataSource dataSource;
    private int progressPercentage = 0;

    public DataSourceValidator(KeySerializer<K> keySerializer, ValueSerializer<V> valueSerializer, MerkleDbDataSource dataSource) {
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.dataSource = dataSource;
    }

    public boolean validate() {
        try {
            long path;
            long firstLeafPath = this.dataSource.getFirstLeafPath();
            long lastLeafPath = this.dataSource.getLastLeafPath();
            int leafCount = Math.toIntExact(lastLeafPath - firstLeafPath + 1L);
            System.out.printf("Validating %,d internal node hashes...%n", firstLeafPath);
            this.progressPercentage = 0;
            for (path = 0L; path < firstLeafPath; ++path) {
                Hash hash = this.dataSource.loadHash(path);
                DataSourceValidator.assertTrue(hash != null, "internal record's hash for path [" + path + "] was null");
                this.printProgress(path, firstLeafPath);
            }
            System.out.println("All internal node hashes are valid :-)" + WHITESPACE);
            System.out.printf("Validating %,d leaf hashes...%n", firstLeafPath);
            this.progressPercentage = 0;
            for (path = firstLeafPath; path <= lastLeafPath; ++path) {
                Hash leafHash = this.dataSource.loadHash(path);
                DataSourceValidator.assertTrue(leafHash == null, "leaf record's hash for path [" + path + "] was not null");
                this.printProgress(path - firstLeafPath, leafCount);
            }
            System.out.println("All leaf hashes are null :-)" + WHITESPACE);
            System.out.printf("Validating %,d leaf record by path...%n", firstLeafPath);
            ArrayList<VirtualKey> keys = new ArrayList<VirtualKey>(leafCount);
            this.progressPercentage = 0;
            for (long path2 = firstLeafPath; path2 <= lastLeafPath; ++path2) {
                VirtualLeafBytes leafBytes = this.dataSource.loadLeafRecord(path2);
                DataSourceValidator.assertTrue(leafBytes != null, "leaf record for path [" + path2 + "] was null");
                DataSourceValidator.assertTrue(leafBytes.path() == path2, "leaf record for path [" + path2 + "] had a bad path [" + leafBytes.path() + "]");
                VirtualLeafRecord leaf = leafBytes.toRecord(this.keySerializer, this.valueSerializer);
                DataSourceValidator.assertTrue(leaf.getKey() != null, "leaf record's key for path [" + path2 + "] was null");
                keys.add(leaf.getKey());
                this.printProgress(path2 - firstLeafPath, leafCount);
            }
            System.out.println("All leaf record by path are valid :-)" + WHITESPACE);
            System.out.printf("Validating %,d leaf record by key...%n", leafCount);
            this.progressPercentage = 0;
            for (int i = 0; i < keys.size(); ++i) {
                VirtualLeafBytes leafBytes = this.dataSource.loadLeafRecord(this.keySerializer.toBytes((Object)((VirtualKey)keys.get(i))), ((VirtualKey)keys.get(i)).hashCode());
                DataSourceValidator.assertTrue(leafBytes != null, "leaf record for key [" + String.valueOf(keys.get(i)) + "] was null");
                VirtualLeafRecord leaf = leafBytes.toRecord(this.keySerializer, this.valueSerializer);
                DataSourceValidator.assertTrue(leaf.getKey() != null, "leaf record's key for key [" + String.valueOf(keys.get(i)) + "] was null");
                DataSourceValidator.assertTrue(leaf.getKey().equals(keys.get(i)), "leaf record's key for key [" + String.valueOf(keys.get(i)) + "] did not match, it was [" + String.valueOf(leaf.getKey()) + "]");
                this.printProgress(i, keys.size());
            }
            System.out.println("All leaf record by key are valid :-)" + WHITESPACE);
            System.out.println("YAY all data is good!");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
            return false;
        }
        return true;
    }

    private static void assertTrue(boolean testResult, String message) {
        if (!testResult) {
            throw new IllegalStateException(message);
        }
    }

    private void printProgress(long position, long total) {
        assert (position >= 0L) : "position [" + position + "] is < 0";
        assert (total > 0L) : "total [" + total + "] is <= 0";
        int newProgressPercentage = (int)((double)position / (double)total * 20.0);
        assert (newProgressPercentage >= 0) : "newProgressPercentage [" + newProgressPercentage + "] is < 0";
        assert (newProgressPercentage <= 20) : "newProgressPercentage [" + newProgressPercentage + "] is > 20, position=" + position + ", total=" + total;
        if (newProgressPercentage > this.progressPercentage) {
            this.progressPercentage = newProgressPercentage;
            System.out.printf("[%s] %d%%, %,d of %,d\r", "#".repeat(newProgressPercentage) + " ".repeat(20 - newProgressPercentage), this.progressPercentage * 5, position, total);
        }
    }
}

