/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.merkle;

import com.swirlds.common.io.ExternalSelfSerializable;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.exceptions.IllegalChildIndexException;
import com.swirlds.common.merkle.impl.PartialBinaryMerkleInternal;
import com.swirlds.common.merkle.route.MerkleRoute;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.CustomReconnectRoot;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.common.merkle.synchronization.views.TeacherTreeView;
import com.swirlds.common.merkle.utility.DebugIterationEndpoint;
import com.swirlds.common.threading.framework.config.ThreadConfiguration;
import com.swirlds.common.threading.manager.AdHocThreadManager;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.constructable.constructors.VirtualRootNodeConstructor;
import com.swirlds.virtualmap.datasource.VirtualDataSource;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.datasource.VirtualHashRecord;
import com.swirlds.virtualmap.datasource.VirtualLeafBytes;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.Path;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.VirtualStateAccessor;
import com.swirlds.virtualmap.internal.cache.VirtualNodeCache;
import com.swirlds.virtualmap.internal.hash.VirtualHashListener;
import com.swirlds.virtualmap.internal.hash.VirtualHasher;
import com.swirlds.virtualmap.internal.merkle.RecordAccessorImpl;
import com.swirlds.virtualmap.internal.merkle.VirtualInternalNode;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import com.swirlds.virtualmap.internal.merkle.VirtualMapStatistics;
import com.swirlds.virtualmap.internal.merkle.VirtualNode;
import com.swirlds.virtualmap.internal.pipeline.VirtualPipeline;
import com.swirlds.virtualmap.internal.pipeline.VirtualRoot;
import com.swirlds.virtualmap.internal.reconnect.ConcurrentBlockingIterator;
import com.swirlds.virtualmap.internal.reconnect.LearnerPullVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.LearnerPushVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashLeafFlusher;
import com.swirlds.virtualmap.internal.reconnect.ReconnectHashListener;
import com.swirlds.virtualmap.internal.reconnect.ReconnectNodeRemover;
import com.swirlds.virtualmap.internal.reconnect.ReconnectState;
import com.swirlds.virtualmap.internal.reconnect.TeacherPullVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.TeacherPushVirtualTreeView;
import com.swirlds.virtualmap.internal.reconnect.TopToBottomTraversalOrder;
import com.swirlds.virtualmap.internal.reconnect.TwoPhasePessimisticTraversalOrder;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.channels.ClosedByInterruptException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableClass;
import org.hiero.base.crypto.DigestType;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

@DebugIterationEndpoint
@ConstructableClass(value=-7031935327178054387L, constructorType=VirtualRootNodeConstructor.class)
public final class VirtualRootNode<K extends VirtualKey, V extends VirtualValue>
extends PartialBinaryMerkleInternal
implements CustomReconnectRoot<Long, Long>,
ExternalSelfSerializable,
VirtualRoot<K, V>,
MerkleInternal {
    private static final String NO_NULL_KEYS_ALLOWED_MESSAGE = "Null keys are not allowed";
    public static final long CLASS_ID = 5367589755328273141L;
    private static final Logger logger = LogManager.getLogger(VirtualRootNode.class);
    private static final int MAX_RECONNECT_HASHING_BUFFER_SIZE = 10000000;
    private static final int MAX_REHASHING_BUFFER_SIZE = 10000000;
    private static final int MAX_RECONNECT_HASHING_BUFFER_TIMEOUT = 60;
    private static final int MAX_FULL_REHASHING_TIMEOUT = 3600;
    @NonNull
    private final VirtualMapConfig virtualMapConfig;
    private long maxSizeReachedTriggeringWarning = 0L;
    private KeySerializer<K> keySerializer;
    private ValueSerializer<V> valueSerializer;
    private VirtualDataSourceBuilder dataSourceBuilder;
    private VirtualDataSource dataSource;
    private VirtualNodeCache<K, V> cache;
    private VirtualStateAccessor state;
    private RecordAccessor<K, V> records;
    private final VirtualHasher<K, V> hasher;
    private VirtualPipeline<K, V> pipeline;
    private final AtomicReference<Hash> hash = new AtomicReference();
    private final AtomicBoolean shouldBeFlushed = new AtomicBoolean(false);
    private final AtomicLong flushThreshold = new AtomicLong();
    private final CountDownLatch flushLatch = new CountDownLatch(1);
    private final AtomicBoolean flushed = new AtomicBoolean(false);
    private final AtomicBoolean merged = new AtomicBoolean(false);
    private final AtomicBoolean detached = new AtomicBoolean(false);
    private ConcurrentBlockingIterator<VirtualLeafRecord<K, V>> reconnectIterator = null;
    private CompletableFuture<Hash> reconnectHashingFuture;
    private AtomicBoolean reconnectHashingStarted;
    private VirtualStateAccessor reconnectState;
    private RecordAccessor<K, V> reconnectRecords;
    private VirtualStateAccessor fullyReconnectedState;
    private VirtualRootNode<K, V> originalMap;
    private ReconnectHashLeafFlusher<K, V> reconnectFlusher;
    private ReconnectNodeRemover<K, V> nodeRemover;
    private final long fastCopyVersion;
    private VirtualMapStatistics statistics;
    private final AtomicReference<Thread> currentModifyingThreadRef = new AtomicReference<Object>(null);

    public VirtualRootNode(@NonNull VirtualMapConfig virtualMapConfig) {
        Objects.requireNonNull(virtualMapConfig);
        this.fastCopyVersion = 0L;
        this.hasher = new VirtualHasher();
        this.virtualMapConfig = virtualMapConfig;
        this.flushThreshold.set(virtualMapConfig.copyFlushThreshold());
    }

    public VirtualRootNode(@NonNull KeySerializer<K> keySerializer, @NonNull ValueSerializer<V> valueSerializer, @NonNull VirtualDataSourceBuilder dataSourceBuilder, @NonNull VirtualMapConfig virtualMapConfig) {
        this.fastCopyVersion = 0L;
        this.hasher = new VirtualHasher();
        this.virtualMapConfig = Objects.requireNonNull(virtualMapConfig);
        this.flushThreshold.set(virtualMapConfig.copyFlushThreshold());
        this.keySerializer = Objects.requireNonNull(keySerializer);
        this.valueSerializer = Objects.requireNonNull(valueSerializer);
        this.dataSourceBuilder = Objects.requireNonNull(dataSourceBuilder);
    }

    private VirtualRootNode(VirtualRootNode<K, V> source) {
        super(source);
        this.fastCopyVersion = source.fastCopyVersion + 1L;
        this.keySerializer = source.keySerializer;
        this.valueSerializer = source.valueSerializer;
        this.dataSourceBuilder = source.dataSourceBuilder;
        this.dataSource = source.dataSource;
        this.cache = source.cache.copy();
        this.hasher = source.hasher;
        this.reconnectHashingFuture = null;
        this.reconnectHashingStarted = null;
        this.reconnectIterator = null;
        this.reconnectRecords = null;
        this.fullyReconnectedState = null;
        this.maxSizeReachedTriggeringWarning = source.maxSizeReachedTriggeringWarning;
        this.pipeline = source.pipeline;
        this.flushThreshold.set(source.flushThreshold.get());
        this.statistics = source.statistics;
        this.virtualMapConfig = source.virtualMapConfig;
        if (this.pipeline.isTerminated()) {
            throw new IllegalStateException("A fast-copy was made of a VirtualRootNode with a terminated pipeline!");
        }
    }

    public void postInit(VirtualStateAccessor state) {
        if (this.originalMap != null) {
            this.fullyReconnectedState = state;
            return;
        }
        if (this.cache == null) {
            this.cache = new VirtualNodeCache(this.virtualMapConfig);
        }
        this.state = Objects.requireNonNull(state);
        this.updateShouldBeFlushed();
        Objects.requireNonNull(this.dataSourceBuilder);
        if (this.dataSource == null) {
            this.dataSource = this.dataSourceBuilder.build(state.getLabel(), true);
        }
        this.records = new RecordAccessorImpl<K, V>(this.state, this.cache, this.keySerializer, this.valueSerializer, this.dataSource);
        if (this.statistics == null) {
            this.statistics = new VirtualMapStatistics(state.getLabel());
        }
        this.statistics.setSize(this.size());
        if (this.pipeline == null) {
            this.pipeline = new VirtualPipeline(this.virtualMapConfig, state.getLabel());
        }
        this.pipeline.registerCopy(this);
    }

    public void fullLeafRehashIfNecessary() {
        Objects.requireNonNull(this.records, "Records must be initialized before rehashing");
        ConcurrentBlockingIterator rehashIterator = new ConcurrentBlockingIterator(10000000);
        CompletableFuture fullRehashFuture = new CompletableFuture();
        CompletableFuture leafFeedFuture = new CompletableFuture();
        long firstLeafPath = this.dataSource.getFirstLeafPath();
        long lastLeafPath = this.dataSource.getLastLeafPath();
        if (firstLeafPath < 0L || lastLeafPath < 0L) {
            logger.info(LogMarker.STARTUP.getMarker(), "Paths range is invalid, skipping full rehash in in the VirtualMap at {}. First path: {}, last path: {}", (Object)this.getRoute(), (Object)firstLeafPath, (Object)lastLeafPath);
            return;
        }
        try {
            Hash loadedHash = this.dataSource.loadHash(lastLeafPath);
            if (loadedHash != null) {
                logger.info(LogMarker.STARTUP.getMarker(), "Calculated hash found for the last leaf path: {} in the VirtualMap at {}, skipping full rehash", (Object)lastLeafPath, (Object)this.getRoute());
                return;
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Doing full rehash for the path range: {} - {}  in the VirtualMap at {}", (Object)firstLeafPath, (Object)lastLeafPath, (Object)this.getRoute());
        ReconnectHashLeafFlusher<K, V> flusher = new ReconnectHashLeafFlusher<K, V>(this.keySerializer, this.valueSerializer, this.dataSource, this.virtualMapConfig.reconnectFlushInterval(), this.statistics);
        ReconnectHashListener<K, V> hashListener = new ReconnectHashListener<K, V>(flusher);
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("virtualmap")).setThreadName("leafRehasher")).setRunnable(() -> fullRehashFuture.complete(this.hasher.hash(this.records::findHash, rehashIterator, firstLeafPath, lastLeafPath, hashListener, this.virtualMapConfig))).setExceptionHandler((thread, exception) -> {
            rehashIterator.close();
            String message = "VirtualMap@" + String.valueOf(this.getRoute()) + " failed to do full rehash";
            logger.error(LogMarker.EXCEPTION.getMarker(), message, exception);
            fullRehashFuture.completeExceptionally(new MerkleSynchronizationException(message, exception));
        })).build().start();
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("virtualmap")).setThreadName("leafFeeder")).setRunnable(() -> {
            long onePercent = (lastLeafPath - firstLeafPath) / 100L + 1L;
            try {
                for (long i = firstLeafPath; i <= lastLeafPath; ++i) {
                    try {
                        VirtualLeafBytes leafBytes = this.dataSource.loadLeafRecord(i);
                        assert (leafBytes != null) : "Leaf record should not be null";
                        VirtualLeafRecord<K, V> leafRecord = leafBytes.toRecord(this.keySerializer, this.valueSerializer);
                        try {
                            rehashIterator.supply(leafRecord);
                        }
                        catch (MerkleSynchronizationException e) {
                            throw e;
                        }
                        catch (InterruptedException e) {
                            Thread.currentThread().interrupt();
                            throw new MerkleSynchronizationException("Interrupted while waiting to supply a new leaf to the hashing iterator buffer", (Throwable)e);
                        }
                        catch (Exception e) {
                            throw new MerkleSynchronizationException("Failed to handle a leaf during full rehashing", (Throwable)e);
                        }
                    }
                    catch (IOException e) {
                        throw new UncheckedIOException(e);
                    }
                    if (onePercent <= 10L || i % onePercent != 0L) continue;
                    logger.info(LogMarker.STARTUP.getMarker(), "Full rehash progress for the VirtualMap at {}: {}%", (Object)this.getRoute(), (Object)((i - firstLeafPath) / onePercent + 1L));
                }
            }
            finally {
                rehashIterator.close();
            }
            leafFeedFuture.complete(null);
        }).setExceptionHandler((thread, exception) -> {
            rehashIterator.close();
            String message = "VirtualMap@" + String.valueOf(this.getRoute()) + " failed to feed all leaves the hasher";
            logger.error(LogMarker.EXCEPTION.getMarker(), message, exception);
            leafFeedFuture.completeExceptionally(new MerkleSynchronizationException(message, exception));
        })).build().start();
        try {
            long start = System.currentTimeMillis();
            leafFeedFuture.get(3600L, TimeUnit.SECONDS);
            long secondsSpent = (System.currentTimeMillis() - start) / 1000L;
            logger.info(LogMarker.STARTUP.getMarker(), "It took {} seconds to feed all leaves to the hasher for the VirtualMap at {}", (Object)secondsSpent, (Object)this.getRoute());
            this.setHashPrivate((Hash)fullRehashFuture.get(3600L - secondsSpent, TimeUnit.SECONDS));
        }
        catch (ExecutionException e) {
            String message = "VirtualMap@" + String.valueOf(this.getRoute()) + " failed to get hash during full rehashing";
            throw new MerkleSynchronizationException(message, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String message = "VirtualMap@" + String.valueOf(this.getRoute()) + " interrupted while full rehashing";
            throw new MerkleSynchronizationException(message, (Throwable)e);
        }
        catch (TimeoutException e) {
            String message = "VirtualMap@" + String.valueOf(this.getRoute()) + "wasn't able to finish full rehashing in time";
            throw new MerkleSynchronizationException(message, (Throwable)e);
        }
    }

    public VirtualStateAccessor getState() {
        return this.state;
    }

    public VirtualDataSource getDataSource() {
        return this.dataSource;
    }

    KeySerializer<K> getKeySerializer() {
        return this.keySerializer;
    }

    ValueSerializer<V> getValueSerializer() {
        return this.valueSerializer;
    }

    public VirtualNodeCache<K, V> getCache() {
        return this.cache;
    }

    public RecordAccessor<K, V> getRecords() {
        return this.records;
    }

    public VirtualPipeline<K, V> getPipeline() {
        return this.pipeline;
    }

    @Override
    public boolean isRegisteredToPipeline(VirtualPipeline<K, V> pipeline) {
        return pipeline == this.pipeline;
    }

    public long getClassId() {
        return 5367589755328273141L;
    }

    public int getVersion() {
        return 3;
    }

    public <T extends MerkleNode> T getChild(int index) {
        VirtualNode node;
        if (this.isDestroyed() || this.dataSource == null || this.originalMap != null || this.state.getFirstLeafPath() == -1L || index > 1) {
            return null;
        }
        long path = (long)index + 1L;
        if (path < this.state.getFirstLeafPath()) {
            Hash hash = this.records.findHash(path);
            VirtualHashRecord virtualHashRecord = new VirtualHashRecord(path, (Hash)(hash != VirtualNodeCache.DELETED_HASH ? hash : null));
            node = new VirtualInternalNode(this, virtualHashRecord);
        } else if (path <= this.state.getLastLeafPath()) {
            VirtualLeafRecord<K, V> leafRecord = this.records.findLeafRecord(path, false);
            if (leafRecord == null) {
                throw new IllegalStateException("Invalid null record for child index " + index + " (path = " + path + "). First leaf path = " + this.state.getFirstLeafPath() + ", last leaf path = " + this.state.getLastLeafPath() + ".");
            }
            Hash hash = this.records.findHash(path);
            node = new VirtualLeafNode<K, V>(leafRecord, (Hash)(hash != VirtualNodeCache.DELETED_HASH ? hash : null));
        } else {
            return null;
        }
        MerkleRoute route = this.getRoute().extendRoute(index);
        node.setRoute(route);
        return (T)node;
    }

    public VirtualRootNode<K, V> copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        VirtualRootNode<K, V> copy = new VirtualRootNode<K, V>(this);
        this.setImmutable(true);
        if (this.isHashed()) {
            this.cache.seal();
        }
        return copy;
    }

    protected void destroyNode() {
        if (this.pipeline != null) {
            this.pipeline.destroyCopy(this);
        } else {
            logger.info(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Destroying virtual root node at route {}, but its pipeline is null. It may happen during failed reconnect", (Object)this.getRoute());
            this.closeDataSource();
        }
    }

    public int getNumberOfChildren() {
        return 2;
    }

    protected void setChildInternal(int index, MerkleNode child) {
        throw new UnsupportedOperationException("You cannot set the child of a VirtualRootNode directly with this API");
    }

    protected void allocateSpaceForChild(int index) {
    }

    protected void checkChildIndexIsValid(int index) {
        if (index < 0 || index > 1) {
            throw new IllegalChildIndexException(0, 1, index);
        }
    }

    public long size() {
        return this.state.size();
    }

    public boolean isEmpty() {
        long lastLeafPath = this.state.getLastLeafPath();
        return lastLeafPath == -1L;
    }

    public boolean containsKey(K key) {
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        long path = this.records.findKey(key);
        this.statistics.countReadEntities();
        return path != -1L;
    }

    public V get(K key) {
        Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
        VirtualLeafRecord<K, V> rec = this.records.findLeafRecord(key, false);
        VirtualValue value = rec == null ? null : (VirtualValue)rec.getValue();
        this.statistics.countReadEntities();
        return (V)(value == null ? null : value.asReadOnly());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        this.throwIfImmutable();
        assert (!this.isHashed()) : "Cannot modify already hashed node";
        assert (this.currentModifyingThreadRef.compareAndSet(null, Thread.currentThread()));
        try {
            Objects.requireNonNull(key, NO_NULL_KEYS_ALLOWED_MESSAGE);
            long path = this.records.findKey(key);
            if (path == -1L) {
                this.add(key, value);
                this.statistics.countAddedEntities();
                this.statistics.setSize(this.state.size());
                return;
            }
            VirtualLeafRecord<K, V> leaf = new VirtualLeafRecord<K, V>(path, key, value);
            this.cache.putLeaf(leaf);
            this.statistics.countUpdatedEntities();
        }
        finally {
            assert (this.currentModifyingThreadRef.compareAndSet(Thread.currentThread(), null));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V remove(K key) {
        this.throwIfImmutable();
        Objects.requireNonNull(key);
        assert (this.currentModifyingThreadRef.compareAndSet(null, Thread.currentThread()));
        try {
            V value;
            long lastLeafParent;
            VirtualLeafRecord<K, V> leafToDelete = this.records.findLeafRecord(key, true);
            if (leafToDelete == null) {
                V v = null;
                return v;
            }
            this.cache.deleteLeaf(leafToDelete);
            this.statistics.countRemovedEntities();
            long lastLeafPath = this.state.getLastLeafPath();
            long firstLeafPath = this.state.getFirstLeafPath();
            long leafToDeletePath = leafToDelete.getPath();
            if (leafToDeletePath != lastLeafPath) {
                VirtualLeafRecord<K, V> lastLeaf = this.records.findLeafRecord(lastLeafPath, true);
                assert (lastLeaf != null);
                this.cache.clearLeafPath(lastLeafPath);
                lastLeaf.setPath(leafToDeletePath);
                this.cache.putLeaf(lastLeaf);
            }
            if ((lastLeafParent = Path.getParentPath(lastLeafPath)) == 0L) {
                if (firstLeafPath == lastLeafPath) {
                    this.state.setFirstLeafPath(-1L);
                    this.state.setLastLeafPath(-1L);
                } else {
                    this.state.setLastLeafPath(1L);
                    VirtualLeafRecord<K, V> leaf = this.records.findLeafRecord(1L, true);
                    this.cache.putLeaf(leaf);
                }
            } else {
                long lastLeafSibling = Path.getSiblingPath(lastLeafPath);
                VirtualLeafRecord<K, V> sibling = this.records.findLeafRecord(lastLeafSibling, true);
                assert (sibling != null);
                this.cache.clearLeafPath(lastLeafSibling);
                this.cache.deleteHash(lastLeafParent);
                sibling.setPath(lastLeafParent);
                this.cache.putLeaf(sibling);
                this.state.setFirstLeafPath(lastLeafParent);
                this.state.setLastLeafPath(lastLeafSibling - 1L);
            }
            if (this.statistics != null) {
                this.statistics.setSize(this.state.size());
            }
            VirtualValue virtualValue = (value = leafToDelete.getValue()) == null ? null : value.asReadOnly();
            return (V)virtualValue;
        }
        finally {
            assert (this.currentModifyingThreadRef.compareAndSet(Thread.currentThread(), null));
        }
    }

    @Override
    public void onShutdown(boolean immediately) {
        if (immediately) {
            this.hasher.shutdown();
        }
        this.closeDataSource();
    }

    private void closeDataSource() {
        if (this.dataSource != null) {
            try {
                this.dataSource.close();
            }
            catch (Exception e) {
                logger.error(LogMarker.EXCEPTION.getMarker(), "Could not close the dataSource after all copies were destroyed", (Throwable)e);
            }
        }
    }

    @Override
    public void merge() {
        long start = System.currentTimeMillis();
        if (!this.isDestroyed() && !this.isDetached()) {
            throw new IllegalStateException("merge is legal only after this node is destroyed or detached");
        }
        if (!this.isImmutable()) {
            throw new IllegalStateException("merge is only allowed on immutable copies");
        }
        if (!this.isHashed()) {
            throw new IllegalStateException("copy must be hashed before it is merged");
        }
        if (this.merged.get()) {
            throw new IllegalStateException("this copy has already been merged");
        }
        if (this.flushed.get()) {
            throw new IllegalStateException("a flushed copy can not be merged");
        }
        this.cache.merge();
        this.merged.set(true);
        long end = System.currentTimeMillis();
        this.statistics.recordMerge(end - start);
        logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Merged in {} ms", (Object)(end - start));
    }

    @Override
    public boolean isMerged() {
        return this.merged.get();
    }

    public void enableFlush() {
        this.shouldBeFlushed.set(true);
    }

    public void setFlushThreshold(long value) {
        this.flushThreshold.set(value);
        this.updateShouldBeFlushed();
    }

    long getFlushThreshold() {
        return this.flushThreshold.get();
    }

    @Override
    public boolean shouldBeFlushed() {
        if (this.shouldBeFlushed.get()) {
            return true;
        }
        long threshold = this.flushThreshold.get();
        return threshold > 0L && this.estimatedSize() >= threshold;
    }

    @Override
    public boolean isFlushed() {
        return this.flushed.get();
    }

    private void updateShouldBeFlushed() {
        if (this.flushThreshold.get() <= 0L) {
            this.shouldBeFlushed.set(this.fastCopyVersion != 0L && this.fastCopyVersion % (long)this.virtualMapConfig.flushInterval() == 0L);
        }
    }

    @Override
    public void waitUntilFlushed() throws InterruptedException {
        if (!this.flushLatch.await(1L, TimeUnit.MINUTES)) {
            this.pipeline.logDebugInfo();
            this.flushLatch.await();
        }
    }

    @Override
    public void flush() {
        if (!this.isImmutable()) {
            throw new IllegalStateException("mutable copies can not be flushed");
        }
        if (this.flushed.get()) {
            throw new IllegalStateException("This map has already been flushed");
        }
        if (this.merged.get()) {
            throw new IllegalStateException("a merged copy can not be flushed");
        }
        long start = System.currentTimeMillis();
        this.flush(this.cache, this.state, this.dataSource);
        this.cache.release();
        long end = System.currentTimeMillis();
        this.flushed.set(true);
        this.flushLatch.countDown();
        this.statistics.recordFlush(end - start);
        logger.debug(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Flushed {} {} in {} ms", (Object)this.state.getLabel(), (Object)this.cache.getFastCopyVersion(), (Object)(end - start));
    }

    private void flush(VirtualNodeCache<K, V> cacheToFlush, VirtualStateAccessor stateToUse, VirtualDataSource ds) {
        try {
            Stream<VirtualLeafBytes> dirtyLeaves = cacheToFlush.dirtyLeavesForFlush(stateToUse.getFirstLeafPath(), stateToUse.getLastLeafPath()).map(r -> r.toBytes(this.keySerializer, this.valueSerializer));
            Stream<VirtualLeafBytes> deletedLeaves = cacheToFlush.deletedLeaves().map(r -> r.toBytes(this.keySerializer, this.valueSerializer));
            Stream<VirtualHashRecord> dirtyHashes = cacheToFlush.dirtyHashesForFlush(stateToUse.getLastLeafPath());
            ds.saveRecords(stateToUse.getFirstLeafPath(), stateToUse.getLastLeafPath(), dirtyHashes, dirtyLeaves, deletedLeaves);
        }
        catch (ClosedByInterruptException ex) {
            logger.info(LogMarker.TESTING_EXCEPTIONS_ACCEPTABLE_RECONNECT.getMarker(), "flush interrupted - this is probably not an error if this happens shortly after a reconnect");
            Thread.currentThread().interrupt();
        }
        catch (IOException ex) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Error while flushing VirtualMap", (Throwable)ex);
            throw new UncheckedIOException(ex);
        }
    }

    @Override
    public long estimatedSize() {
        long estimatedDirtyLeavesCount = this.cache.estimatedDirtyLeavesCount();
        long estimatedLeavesSize = estimatedDirtyLeavesCount * (long)(8 + DigestType.SHA_384.digestLength() + this.keySerializer.getTypicalSerializedSize() + this.valueSerializer.getTypicalSerializedSize());
        long estimatedInternalsCount = this.cache.estimatedHashesCount();
        long estimatedInternalsSize = estimatedInternalsCount * (long)(8 + DigestType.SHA_384.digestLength());
        return estimatedInternalsSize + estimatedLeavesSize;
    }

    public void serialize(SerializableDataOutputStream out, java.nio.file.Path outputDirectory) throws IOException {
        this.pipeline.pausePipelineAndRun("detach", () -> {
            this.snapshot(outputDirectory);
            return null;
        });
        out.writeNormalisedString(this.state.getLabel());
        out.writeSerializable((SelfSerializable)this.dataSourceBuilder, true);
        out.writeSerializable(this.keySerializer, true);
        out.writeSerializable(this.valueSerializer, true);
        out.writeLong(this.cache.getFastCopyVersion());
    }

    public void deserialize(SerializableDataInputStream in, java.nio.file.Path inputDirectory, int version) throws IOException {
        String label = in.readNormalisedString(1536);
        this.dataSourceBuilder = (VirtualDataSourceBuilder)in.readSerializable();
        this.dataSource = this.dataSourceBuilder.restore(label, inputDirectory);
        if (version < 2) {
            this.keySerializer = this.dataSource.getKeySerializer();
            if (this.keySerializer == null) {
                throw new IllegalStateException("No key serializer available");
            }
            this.valueSerializer = this.dataSource.getValueSerializer();
            if (this.valueSerializer == null) {
                throw new IllegalStateException("No value serializer available");
            }
        } else {
            this.keySerializer = (KeySerializer)in.readSerializable();
            this.valueSerializer = (ValueSerializer)in.readSerializable();
        }
        this.cache = version < 3 ? (VirtualNodeCache)in.readSerializable() : new VirtualNodeCache(this.virtualMapConfig, in.readLong());
    }

    public boolean isSelfHashing() {
        return true;
    }

    public Hash getHash() {
        if (this.hash.get() == null) {
            this.pipeline.hashCopy(this);
        }
        return this.hash.get();
    }

    public void setHash(Hash hash) {
        throw new UnsupportedOperationException("data type is self hashing");
    }

    private void setHashPrivate(@Nullable Hash value) {
        this.hash.set(value);
    }

    public void invalidateHash() {
        throw new UnsupportedOperationException("this node is self hashing");
    }

    @Override
    public boolean isHashed() {
        return this.hash.get() != null;
    }

    @Override
    public void computeHash() {
        if (this.hash.get() != null) {
            return;
        }
        long start = System.currentTimeMillis();
        this.cache.prepareForHashing();
        VirtualHashListener hashListener = new VirtualHashListener<K, V>(){

            @Override
            public void onNodeHashed(long path, Hash hash) {
                VirtualRootNode.this.cache.putHash(path, hash);
            }
        };
        Hash virtualHash = this.hasher.hash(this.records::findHash, this.cache.dirtyLeavesForHash(this.state.getFirstLeafPath(), this.state.getLastLeafPath()).iterator(), this.state.getFirstLeafPath(), this.state.getLastLeafPath(), hashListener, this.virtualMapConfig);
        if (virtualHash == null) {
            Hash rootHash = this.state.size() == 0L ? null : this.records.findHash(0L);
            virtualHash = rootHash != null ? rootHash : this.hasher.emptyRootHash();
        }
        this.cache.seal();
        this.setHashPrivate(virtualHash);
        long end = System.currentTimeMillis();
        this.statistics.recordHash(end - start);
    }

    @Override
    public RecordAccessor<K, V> detach() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("detach is illegal on already destroyed copies");
        }
        if (!this.isImmutable()) {
            throw new IllegalStateException("detach is only allowed on immutable copies");
        }
        if (!this.isHashed()) {
            throw new IllegalStateException("copy must be hashed before it is detached");
        }
        this.detached.set(true);
        VirtualDataSource dataSourceCopy = this.dataSourceBuilder.copy(this.dataSource, false, false);
        VirtualNodeCache<K, V> cacheSnapshot = this.cache.snapshot();
        return new RecordAccessorImpl<K, V>(this.state, cacheSnapshot, this.keySerializer, this.valueSerializer, dataSourceCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void snapshot(java.nio.file.Path destination) throws IOException {
        if (this.isDestroyed()) {
            throw new IllegalStateException("snapshot is illegal on already destroyed copies");
        }
        if (!this.isImmutable()) {
            throw new IllegalStateException("snapshot is only allowed on immutable copies");
        }
        if (!this.isHashed()) {
            throw new IllegalStateException("copy must be hashed before snapshot");
        }
        this.detached.set(true);
        try (VirtualDataSource dataSourceCopy = this.dataSourceBuilder.copy(this.dataSource, false, true);){
            VirtualNodeCache<K, V> cacheSnapshot = this.cache.snapshot();
            this.flush(cacheSnapshot, this.state, dataSourceCopy);
            this.dataSourceBuilder.snapshot(destination, dataSourceCopy);
        }
    }

    @Override
    public boolean isDetached() {
        return this.detached.get();
    }

    public TeacherTreeView<Long> buildTeacherView(ReconnectConfig reconnectConfig) {
        return switch (this.virtualMapConfig.reconnectMode()) {
            case "push" -> new TeacherPushVirtualTreeView<K, V>(AdHocThreadManager.getStaticThreadManager(), reconnectConfig, this, this.state, this.pipeline);
            case "pullTopToBottom" -> new TeacherPullVirtualTreeView<K, V>(AdHocThreadManager.getStaticThreadManager(), reconnectConfig, this, this.state, this.pipeline);
            case "pullTwoPhasePessimistic" -> new TeacherPullVirtualTreeView<K, V>(AdHocThreadManager.getStaticThreadManager(), reconnectConfig, this, this.state, this.pipeline);
            default -> throw new UnsupportedOperationException("Unknown reconnect mode: " + this.virtualMapConfig.reconnectMode());
        };
    }

    public void setupWithOriginalNode(MerkleNode originalNode) {
        assert (originalNode instanceof VirtualRootNode) : "The original node was not a VirtualRootNode!";
        this.originalMap = (VirtualRootNode)originalNode;
        this.dataSourceBuilder = this.originalMap.dataSourceBuilder;
        this.keySerializer = this.originalMap.keySerializer;
        this.valueSerializer = this.originalMap.valueSerializer;
        this.reconnectState = new ReconnectState(-1L, -1L);
        this.reconnectRecords = (RecordAccessor)this.originalMap.pipeline.pausePipelineAndRun("copy", () -> {
            this.originalMap.dataSource.stopAndDisableBackgroundCompaction();
            this.dataSource = this.dataSourceBuilder.copy(this.originalMap.dataSource, true, false);
            assert (this.originalMap.isHashed()) : "The system should have made sure this was hashed by this point!";
            VirtualNodeCache<K, V> snapshotCache = this.originalMap.cache.snapshot();
            this.flush(snapshotCache, this.originalMap.state, this.dataSource);
            return new RecordAccessorImpl<K, V>(this.reconnectState, snapshotCache, this.keySerializer, this.valueSerializer, this.dataSource);
        });
        this.reconnectIterator = new ConcurrentBlockingIterator(10000000);
        this.reconnectHashingFuture = new CompletableFuture();
        this.reconnectHashingStarted = new AtomicBoolean(false);
        this.dataSource.copyStatisticsFrom(this.originalMap.dataSource);
        this.statistics = this.originalMap.statistics;
    }

    public void setupWithNoData() {
    }

    public LearnerTreeView<Long> buildLearnerView(ReconnectConfig reconnectConfig, @NonNull ReconnectMapStats mapStats) {
        assert (this.originalMap != null);
        VirtualStateAccessor originalState = this.originalMap.getState();
        this.reconnectFlusher = new ReconnectHashLeafFlusher<K, V>(this.keySerializer, this.valueSerializer, this.reconnectRecords.getDataSource(), this.virtualMapConfig.reconnectFlushInterval(), this.statistics);
        this.nodeRemover = new ReconnectNodeRemover<K, V>(this.originalMap.getRecords(), originalState.getFirstLeafPath(), originalState.getLastLeafPath(), this.reconnectFlusher);
        return switch (this.virtualMapConfig.reconnectMode()) {
            case "push" -> new LearnerPushVirtualTreeView<K, V>(reconnectConfig, this, this.originalMap.records, originalState, this.reconnectState, this.nodeRemover, mapStats);
            case "pullTopToBottom" -> {
                TopToBottomTraversalOrder topToBottom = new TopToBottomTraversalOrder();
                yield new LearnerPullVirtualTreeView<K, V>(reconnectConfig, this, this.originalMap.records, originalState, this.reconnectState, this.nodeRemover, topToBottom, mapStats);
            }
            case "pullTwoPhasePessimistic" -> {
                TwoPhasePessimisticTraversalOrder twoPhasePessimistic = new TwoPhasePessimisticTraversalOrder();
                yield new LearnerPullVirtualTreeView<K, V>(reconnectConfig, this, this.originalMap.records, originalState, this.reconnectState, this.nodeRemover, twoPhasePessimistic, mapStats);
            }
            default -> throw new UnsupportedOperationException("Unknown reconnect mode: " + this.virtualMapConfig.reconnectMode());
        };
    }

    public void registerMetrics(Metrics metrics) {
        this.statistics.registerMetrics(metrics);
        this.pipeline.registerMetrics(metrics);
        this.dataSource.registerMetrics(metrics);
    }

    public void handleReconnectLeaf(VirtualLeafRecord<K, V> leafRecord) {
        try {
            this.reconnectIterator.supply(leafRecord);
        }
        catch (MerkleSynchronizationException e) {
            throw e;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new MerkleSynchronizationException("Interrupted while waiting to supply a new leaf to the hashing iterator buffer", (Throwable)e);
        }
        catch (Exception e) {
            throw new MerkleSynchronizationException("Failed to handle a leaf during reconnect on the learner", (Throwable)e);
        }
    }

    public void prepareReconnectHashing(long firstLeafPath, long lastLeafPath) {
        assert (this.reconnectFlusher != null) : "Cannot prepare reconnect hashing, since reconnect is not started";
        ReconnectHashListener<K, V> hashListener = new ReconnectHashListener<K, V>(this.reconnectFlusher);
        ((ThreadConfiguration)((ThreadConfiguration)((ThreadConfiguration)new ThreadConfiguration(AdHocThreadManager.getStaticThreadManager()).setComponent("virtualmap")).setThreadName("hasher")).setRunnable(() -> this.reconnectHashingFuture.complete(this.hasher.hash(this.reconnectRecords::findHash, this.reconnectIterator, firstLeafPath, lastLeafPath, hashListener, this.virtualMapConfig))).setExceptionHandler((thread, exception) -> {
            this.reconnectIterator.close();
            String message = "VirtualMap@" + String.valueOf(this.getRoute()) + " failed to hash during reconnect";
            logger.error(LogMarker.EXCEPTION.getMarker(), message, exception);
            this.reconnectHashingFuture.completeExceptionally(new MerkleSynchronizationException(message, exception));
        })).build().start();
        this.reconnectHashingStarted.set(true);
    }

    public void endLearnerReconnect() {
        try {
            logger.info(LogMarker.RECONNECT.getMarker(), "call reconnectIterator.close()");
            this.reconnectIterator.close();
            if (this.reconnectHashingStarted.get()) {
                logger.info(LogMarker.RECONNECT.getMarker(), "call setHashPrivate()");
                this.setHashPrivate(this.reconnectHashingFuture.get());
            } else {
                logger.warn(LogMarker.RECONNECT.getMarker(), "virtual map hashing thread was never started");
            }
            this.nodeRemover = null;
            this.originalMap = null;
            logger.info(LogMarker.RECONNECT.getMarker(), "call postInit()");
            this.postInit(this.fullyReconnectedState);
        }
        catch (ExecutionException e) {
            String message = "VirtualMap@" + String.valueOf(this.getRoute()) + " failed to get hash during learner reconnect";
            throw new MerkleSynchronizationException(message, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String message = "VirtualMap@" + String.valueOf(this.getRoute()) + " interrupted while ending learner reconnect";
            throw new MerkleSynchronizationException(message, (Throwable)e);
        }
        logger.info(LogMarker.RECONNECT.getMarker(), "endLearnerReconnect() complete");
    }

    public void warm(K key) {
        this.records.findLeafRecord(key, false);
    }

    private void add(K key, V value) {
        long leafPath;
        long lastLeafPath;
        long maximumAllowedSize;
        this.throwIfImmutable();
        assert (!this.isHashed()) : "Cannot modify already hashed node";
        long currentSize = this.size();
        if (currentSize >= (maximumAllowedSize = this.virtualMapConfig.maximumVirtualMapSize())) {
            throw new IllegalStateException("Virtual Map has no more space");
        }
        long remainingCapacity = maximumAllowedSize - currentSize;
        if (currentSize > this.maxSizeReachedTriggeringWarning && remainingCapacity <= this.virtualMapConfig.virtualMapWarningThreshold() && remainingCapacity % this.virtualMapConfig.virtualMapWarningInterval() == 0L) {
            this.maxSizeReachedTriggeringWarning = currentSize;
            logger.warn(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Virtual Map only has room for {} additional entries", (Object)remainingCapacity);
        }
        if (remainingCapacity == 1L) {
            logger.warn(LogMarker.VIRTUAL_MERKLE_STATS.getMarker(), "Virtual Map is now full!");
        }
        if ((lastLeafPath = this.state.getLastLeafPath()) == -1L) {
            leafPath = Path.getLeftChildPath(0L);
            this.state.setLastLeafPath(leafPath);
            this.state.setFirstLeafPath(leafPath);
        } else if (Path.isLeft(lastLeafPath)) {
            leafPath = Path.getRightChildPath(0L);
            this.state.setLastLeafPath(leafPath);
        } else {
            long firstLeafPath = this.state.getFirstLeafPath();
            long nextFirstLeafPath = Path.isFarRight(firstLeafPath) ? Path.getPathForRankAndIndex((byte)(Path.getRank(firstLeafPath) + 1), 0L) : Path.getPathForRankAndIndex(Path.getRank(firstLeafPath), Path.getIndexInRank(firstLeafPath) + 1L);
            VirtualLeafRecord<K, V> oldLeaf = this.records.findLeafRecord(firstLeafPath, true);
            Objects.requireNonNull(oldLeaf);
            this.cache.clearLeafPath(firstLeafPath);
            oldLeaf.setPath(Path.getLeftChildPath(firstLeafPath));
            this.cache.putLeaf(oldLeaf);
            leafPath = Path.getRightChildPath(firstLeafPath);
            this.state.setLastLeafPath(leafPath);
            this.state.setFirstLeafPath(nextFirstLeafPath);
        }
        this.statistics.setSize(this.state.size());
        VirtualLeafRecord<K, V> newLeaf = new VirtualLeafRecord<K, V>(leafPath, key, value);
        this.cache.putLeaf(newLeaf);
    }

    @Override
    public long getFastCopyVersion() {
        return this.fastCopyVersion;
    }

    public static class ClassVersion {
        public static final int VERSION_1_ORIGINAL = 1;
        public static final int VERSION_2_KEYVALUE_SERIALIZERS = 2;
        public static final int VERSION_3_NO_NODE_CACHE = 3;
        public static final int CURRENT_VERSION = 3;
    }
}

