/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.reconnect;

import com.swirlds.base.time.Time;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.metrics.extensions.CountPerSecond;
import com.swirlds.common.threading.manager.ThreadManager;
import com.swirlds.common.utility.throttle.RateLimitedLogger;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.platform.metrics.ReconnectMetrics;
import com.swirlds.platform.network.Connection;
import com.swirlds.platform.network.NetworkProtocolException;
import com.swirlds.platform.network.protocol.PeerProtocol;
import com.swirlds.platform.reconnect.ReconnectSyncHelper;
import com.swirlds.platform.reconnect.ReconnectTeacher;
import com.swirlds.platform.reconnect.ReconnectThrottle;
import com.swirlds.platform.state.service.PlatformStateFacade;
import com.swirlds.platform.state.signed.ReservedSignedState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.gossip.FallenBehindManager;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;

public class ReconnectPeerProtocol
implements PeerProtocol {
    private static final Logger logger = LogManager.getLogger(ReconnectPeerProtocol.class);
    private final NodeId peerId;
    private final ReconnectThrottle teacherThrottle;
    private final Supplier<ReservedSignedState> lastCompleteSignedState;
    private final Duration reconnectSocketTimeout;
    private final ReconnectMetrics reconnectMetrics;
    private final ReconnectSyncHelper reconnectHelperNetwork;
    private final PlatformStateFacade platformStateFacade;
    private final CountPerSecond reconnectRejectionMetrics;
    private InitiatedBy initiatedBy = InitiatedBy.NO_ONE;
    private final ThreadManager threadManager;
    private final FallenBehindManager fallenBehindManager;
    private final Supplier<PlatformStatus> platformStatusSupplier;
    private final Configuration configuration;
    private ReservedSignedState teacherState;
    private final RateLimitedLogger stateNullLogger;
    private final RateLimitedLogger stateIncompleteLogger;
    private final RateLimitedLogger fallenBehindLogger;
    private final RateLimitedLogger notActiveLogger;
    private final Time time;
    private final PlatformContext platformContext;

    public ReconnectPeerProtocol(@NonNull PlatformContext platformContext, @NonNull ThreadManager threadManager, @NonNull NodeId peerId, @NonNull ReconnectThrottle teacherThrottle, @NonNull Supplier<ReservedSignedState> lastCompleteSignedState, @NonNull Duration reconnectSocketTimeout, @NonNull ReconnectMetrics reconnectMetrics, @NonNull ReconnectSyncHelper reconnectHelperNetwork, @NonNull FallenBehindManager fallenBehindManager, @NonNull Supplier<PlatformStatus> platformStatusSupplier, @NonNull Time time, @NonNull PlatformStateFacade platformStateFacade) {
        this.platformContext = Objects.requireNonNull(platformContext);
        this.threadManager = Objects.requireNonNull(threadManager);
        this.peerId = Objects.requireNonNull(peerId);
        this.teacherThrottle = Objects.requireNonNull(teacherThrottle);
        this.lastCompleteSignedState = Objects.requireNonNull(lastCompleteSignedState);
        this.reconnectSocketTimeout = Objects.requireNonNull(reconnectSocketTimeout);
        this.reconnectMetrics = Objects.requireNonNull(reconnectMetrics);
        this.reconnectHelperNetwork = Objects.requireNonNull(reconnectHelperNetwork);
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        this.platformStatusSupplier = Objects.requireNonNull(platformStatusSupplier);
        this.configuration = Objects.requireNonNull(platformContext.getConfiguration());
        this.platformStateFacade = Objects.requireNonNull(platformStateFacade);
        Objects.requireNonNull(time);
        Duration minimumTimeBetweenReconnects = ((ReconnectConfig)this.configuration.getConfigData(ReconnectConfig.class)).minimumTimeBetweenReconnects();
        this.stateNullLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.stateIncompleteLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.fallenBehindLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.notActiveLogger = new RateLimitedLogger(logger, time, minimumTimeBetweenReconnects);
        this.time = Objects.requireNonNull(time);
        this.reconnectRejectionMetrics = new CountPerSecond(reconnectMetrics.getMetrics(), new CountPerSecond.Config("platform", String.format("reconnectRejections_per_sec_%02d", peerId.id())).withDescription(String.format("number of reconnections rejected per second from node %02d", peerId.id())).withUnit("rejectionsPerSec").withFormat("%,10.0f"));
    }

    @Override
    public boolean shouldInitiate() {
        if (!this.fallenBehindManager.shouldReconnectFrom(this.peerId)) {
            return false;
        }
        boolean acquiredPermit = this.reconnectHelperNetwork.acquireLearnerPermit();
        if (acquiredPermit) {
            this.initiatedBy = InitiatedBy.SELF;
        }
        return acquiredPermit;
    }

    @Override
    public void initiateFailed() {
        this.reconnectHelperNetwork.cancelLearnerPermit();
        this.initiatedBy = InitiatedBy.NO_ONE;
    }

    @Override
    public boolean shouldAccept() {
        if (this.fallenBehindManager.hasFallenBehind()) {
            this.fallenBehindLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} because this node has fallen behind", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (this.platformStatusSupplier.get() != PlatformStatus.ACTIVE) {
            this.notActiveLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} because this node isn't ACTIVE", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        this.teacherState = this.lastCompleteSignedState.get();
        if (this.teacherState == null || this.teacherState.isNull()) {
            this.stateNullLogger.info(LogMarker.RECONNECT.getMarker(), "Rejecting reconnect request from node {} due to lack of a fully signed state", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (!this.teacherState.get().isComplete()) {
            this.stateIncompleteLogger.error(LogMarker.EXCEPTION.getMarker(), "Rejecting reconnect request from node {} due to lack of a fully signed state. The signed state manager attempted to provide a state that was not fully signed, which should not be possible.", new Object[]{this.peerId});
            this.reconnectRejected();
            return false;
        }
        if (!this.reconnectHelperNetwork.blockLearnerPermit()) {
            this.reconnectRejected();
            return false;
        }
        boolean reconnectPermittedByThrottle = this.teacherThrottle.initiateReconnect(this.peerId);
        if (!reconnectPermittedByThrottle) {
            this.reconnectRejected();
            this.reconnectHelperNetwork.cancelLearnerPermit();
            return false;
        }
        this.initiatedBy = InitiatedBy.PEER;
        return true;
    }

    private void reconnectRejected() {
        if (this.teacherState != null) {
            this.teacherState.close();
            this.teacherState = null;
        }
        this.reconnectRejectionMetrics.count();
    }

    @Override
    public void acceptFailed() {
        this.teacherState.close();
        this.teacherState = null;
        this.teacherThrottle.reconnectAttemptFinished();
        this.reconnectHelperNetwork.cancelLearnerPermit();
    }

    @Override
    public boolean acceptOnSimultaneousInitiate() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void runProtocol(Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        try {
            switch (this.initiatedBy.ordinal()) {
                case 2: {
                    this.teacher(connection);
                    return;
                }
                case 1: {
                    this.learner(connection);
                    return;
                }
                default: {
                    throw new NetworkProtocolException("runProtocol() called but it is unclear who the teacher and who the learner is");
                }
            }
        }
        finally {
            this.initiatedBy = InitiatedBy.NO_ONE;
        }
    }

    private void learner(Connection connection) throws InterruptedException {
        this.reconnectHelperNetwork.provideLearnerConnection(connection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void teacher(Connection connection) {
        try (ReservedSignedState state = this.teacherState;){
            new ReconnectTeacher(this.platformContext, this.time, this.threadManager, connection, this.reconnectSocketTimeout, connection.getSelfId(), connection.getOtherId(), state.get().getRound(), this.reconnectMetrics, this.platformStateFacade).execute(state.get());
        }
        finally {
            this.teacherThrottle.reconnectAttemptFinished();
            this.teacherState = null;
            this.reconnectHelperNetwork.cancelLearnerPermit();
        }
    }

    private static enum InitiatedBy {
        NO_ONE,
        SELF,
        PEER;

    }
}

