/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.platform.event.codec;

import com.hedera.hapi.platform.event.EventDescriptor;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.JsonTools;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.UnknownFieldException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hedera.pbj.runtime.jsonparser.JSONParser;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;

public final class EventDescriptorJsonCodec
implements JsonCodec<EventDescriptor> {
    @NonNull
    public EventDescriptor parse(@Nullable JSONParser.ObjContext root, boolean strictMode, int maxDepth) throws ParseException {
        if (maxDepth < 0) {
            throw new ParseException("Reached maximum allowed depth of nested messages");
        }
        try {
            Bytes temp_hash = Bytes.EMPTY;
            long temp_creator_node_id = 0L;
            long temp_birth_round = 0L;
            long temp_generation = 0L;
            block14: for (JSONParser.PairContext kvPair : root.pair()) {
                switch (kvPair.STRING().getText()) {
                    case "hash": {
                        temp_hash = Bytes.fromBase64((String)kvPair.value().STRING().getText());
                        continue block14;
                    }
                    case "creatorNodeId": {
                        temp_creator_node_id = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "birthRound": {
                        temp_birth_round = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                    case "generation": {
                        temp_generation = JsonTools.parseLong((JSONParser.ValueContext)kvPair.value());
                        continue block14;
                    }
                }
                if (!strictMode) continue;
                throw new UnknownFieldException(kvPair.STRING().getText());
            }
            return new EventDescriptor(temp_hash, temp_creator_node_id, temp_birth_round, temp_generation);
        }
        catch (Exception ex) {
            throw new ParseException((Throwable)ex);
        }
    }

    public String toJSON(@NonNull EventDescriptor data, String indent, boolean inline) {
        StringBuilder sb = new StringBuilder();
        sb.append((String)(inline ? "{\n" : indent + "{\n"));
        String childIndent = indent + "  ";
        ArrayList<String> fieldLines = new ArrayList<String>();
        if (data.hash() != Bytes.EMPTY && data.hash() != null && data.hash().length() > 0L) {
            fieldLines.add(JsonTools.field((String)"hash", (Bytes)data.hash()));
        }
        if (data.creatorNodeId() != 0L) {
            fieldLines.add(JsonTools.field((String)"creatorNodeId", (long)data.creatorNodeId()));
        }
        if (data.birthRound() != 0L) {
            fieldLines.add(JsonTools.field((String)"birthRound", (long)data.birthRound()));
        }
        if (data.generation() != 0L) {
            fieldLines.add(JsonTools.field((String)"generation", (long)data.generation()));
        }
        if (!fieldLines.isEmpty()) {
            sb.append(childIndent);
            sb.append(String.join((CharSequence)(",\n" + childIndent), fieldLines));
            sb.append("\n");
        }
        sb.append(indent + "}");
        return sb.toString();
    }
}

