/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.test.fixtures.consensus.framework;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.common.context.PlatformContext;
import com.swirlds.platform.test.fixtures.consensus.framework.ConsensusTestNode;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusOutputValidator;
import com.swirlds.platform.test.fixtures.consensus.framework.validation.ConsensusRoundValidator;
import com.swirlds.platform.test.fixtures.event.generator.GraphGenerator;
import com.swirlds.platform.test.fixtures.gui.ListEventProvider;
import com.swirlds.platform.test.fixtures.gui.TestGuiSource;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.List;
import java.util.function.Consumer;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.roster.AddressBook;

public class ConsensusTestOrchestrator {
    private final PlatformContext platformContext;
    private final List<ConsensusTestNode> nodes;
    private long currentSequence = 0L;
    private final List<Long> weights;
    private final int totalEventNum;

    public ConsensusTestOrchestrator(PlatformContext platformContext, List<ConsensusTestNode> nodes, List<Long> weights, int totalEventNum) {
        this.platformContext = platformContext;
        this.nodes = nodes;
        this.weights = weights;
        this.totalEventNum = totalEventNum;
    }

    public void addReconnectNode(@NonNull PlatformContext platformContext) {
        ConsensusTestNode node = this.nodes.get(0).reconnect(platformContext);
        node.getEventEmitter().setCheckpoint(this.currentSequence);
        node.addEvents(this.currentSequence);
        this.nodes.add(node);
    }

    private void generateEvents(int numEvents) {
        this.currentSequence += (long)numEvents;
        this.nodes.forEach(node -> node.getEventEmitter().setCheckpoint(this.currentSequence));
        this.nodes.forEach(node -> node.addEvents(numEvents));
    }

    public void runGui() {
        ConsensusTestNode node = (ConsensusTestNode)this.nodes.stream().findAny().orElseThrow();
        AddressBook addressBook = node.getEventEmitter().getGraphGenerator().getAddressBook();
        new TestGuiSource(this.platformContext, addressBook, new ListEventProvider(node.getOutput().getAddedEvents())).runGui();
    }

    public ConsensusTestOrchestrator generateAllEvents() {
        return this.generateEvents(1.0);
    }

    public ConsensusTestOrchestrator generateEvents(double fractionOfTotal) {
        this.generateEvents(this.getEventFraction(fractionOfTotal));
        return this;
    }

    public int getEventFraction(double fractionOfTotal) {
        return (int)((double)this.totalEventNum * fractionOfTotal);
    }

    public void validateAndClear(ConsensusOutputValidator consensusOutputValidator) {
        this.validate(consensusOutputValidator);
        this.clearOutput();
    }

    public void validate(ConsensusOutputValidator consensusOutputValidator) {
        for (ConsensusTestNode node : this.nodes) {
            ConsensusRoundValidator.validate(node.getOutput().getConsensusRounds());
        }
        ConsensusTestNode node1 = this.nodes.getFirst();
        for (int i = 1; i < this.nodes.size(); ++i) {
            ConsensusTestNode otherNode = this.nodes.get(i);
            consensusOutputValidator.validate(node1.getOutput(), otherNode.getOutput());
            ConsensusRoundValidator.validate(node1.getOutput().getConsensusRounds(), otherNode.getOutput().getConsensusRounds());
        }
    }

    public void clearOutput() {
        this.nodes.forEach(n -> n.getOutput().clear());
    }

    public void restartAllNodes() {
        long lastRoundDecided = this.nodes.getFirst().getLatestRound();
        if (lastRoundDecided < 1L) {
            System.out.println("Cannot restart, no consensus reached yet");
            return;
        }
        System.out.println("Restarting at round " + lastRoundDecided);
        for (ConsensusTestNode node : this.nodes) {
            node.restart();
            node.getEventEmitter().setCheckpoint(this.currentSequence);
            node.addEvents(this.currentSequence);
        }
    }

    public void removeNode(NodeId nodeId) {
        this.nodes.forEach(node -> node.removeNode(nodeId));
    }

    public ConsensusTestOrchestrator configGenerators(Consumer<GraphGenerator> configurator) {
        for (ConsensusTestNode node : this.nodes) {
            configurator.accept(node.getEventEmitter().getGraphGenerator());
        }
        return this;
    }

    public void setNewEventWeight(int nodeIndex, double eventWeight) {
        for (ConsensusTestNode node : this.nodes) {
            node.getEventEmitter().getGraphGenerator().getSourceByIndex(nodeIndex).setNewEventWeight(eventWeight);
        }
    }

    public void setOtherParentAffinity(List<List<Double>> matrix) {
        for (ConsensusTestNode node : this.nodes) {
            node.getEventEmitter().getGraphGenerator().setOtherParentAffinity(matrix);
        }
    }

    public void forEachNode(@NonNull Consumer<ConsensusTestNode> consumer) {
        for (ConsensusTestNode node : this.nodes) {
            consumer.accept(node);
        }
    }

    public List<Long> getWeights() {
        return this.weights;
    }

    public List<ConsensusTestNode> getNodes() {
        return this.nodes;
    }

    public Roster getRoster() {
        return this.nodes.get(0).getEventEmitter().getGraphGenerator().getRoster();
    }
}

