/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.spi;

import com.swirlds.state.spi.ReadableSingletonStateBase;
import com.swirlds.state.spi.SingletonChangeListener;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class WritableSingletonStateBase<T>
extends ReadableSingletonStateBase<T>
implements WritableSingletonState<T> {
    private static final Object NULL_VALUE = new Object();
    private final Consumer<T> backingStoreMutator;
    private Object value;
    private final List<SingletonChangeListener<T>> listeners = new ArrayList<SingletonChangeListener<T>>();

    public WritableSingletonStateBase(@NonNull String stateKey, @NonNull Supplier<T> backingStoreAccessor, @NonNull Consumer<T> backingStoreMutator) {
        super(stateKey, backingStoreAccessor);
        this.backingStoreMutator = Objects.requireNonNull(backingStoreMutator);
    }

    public void registerListener(@NonNull SingletonChangeListener<T> listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    @Override
    public T get() {
        T currentValue = this.currentValue();
        if (currentValue != null) {
            return currentValue;
        }
        return super.get();
    }

    @Override
    public void put(T value) {
        this.value = value == null ? NULL_VALUE : value;
    }

    @Override
    public boolean isModified() {
        return this.value != null;
    }

    public void commit() {
        if (this.value != null) {
            Object currentValue = this.currentValue();
            this.backingStoreMutator.accept(currentValue);
            if (currentValue != null) {
                this.listeners.forEach(l -> l.singletonUpdateChange(currentValue));
            }
        }
        this.reset();
    }

    private T currentValue() {
        return (T)(this.value == NULL_VALUE ? null : this.value);
    }

    @Override
    public void reset() {
        this.value = null;
        super.reset();
    }
}

