/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.base.concurrent.atomic;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.IntBinaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.ToDoubleBiFunction;
import org.hiero.base.utility.ByteUtils;

public class AtomicIntPair {
    private static final int RESET_VALUE = 0;
    private final AtomicLong container;
    private final LongBinaryOperator operator = (current, supplied) -> {
        int left = leftAccumulator.applyAsInt(ByteUtils.extractLeftInt((long)current), ByteUtils.extractLeftInt((long)supplied));
        int right = rightAccumulator.applyAsInt(ByteUtils.extractRightInt((long)current), ByteUtils.extractRightInt((long)supplied));
        return ByteUtils.combineInts((int)left, (int)right);
    };

    public AtomicIntPair() {
        this(Integer::sum, Integer::sum);
    }

    public AtomicIntPair(IntBinaryOperator leftAccumulator, IntBinaryOperator rightAccumulator) {
        this.container = new AtomicLong(0L);
    }

    public void accumulate(int leftValue, int rightValue) {
        this.container.accumulateAndGet(ByteUtils.combineInts((int)leftValue, (int)rightValue), this.operator);
    }

    public int getLeft() {
        return ByteUtils.extractLeftInt((long)this.container.get());
    }

    public int getRight() {
        return ByteUtils.extractRightInt((long)this.container.get());
    }

    public double computeDouble(ToDoubleBiFunction<Integer, Integer> compute) {
        long twoInts = this.container.get();
        return compute.applyAsDouble(ByteUtils.extractLeftInt((long)twoInts), ByteUtils.extractRightInt((long)twoInts));
    }

    public double computeDoubleAndReset(ToDoubleBiFunction<Integer, Integer> compute) {
        return this.computeDoubleAndSet(compute, 0, 0);
    }

    public double computeDoubleAndSet(ToDoubleBiFunction<Integer, Integer> compute, int left, int right) {
        long twoInts = this.container.getAndSet(ByteUtils.combineInts((int)left, (int)right));
        return compute.applyAsDouble(ByteUtils.extractLeftInt((long)twoInts), ByteUtils.extractRightInt((long)twoInts));
    }

    public void set(int left, int right) {
        this.container.set(ByteUtils.combineInts((int)left, (int)right));
    }

    public <T> T compute(BiFunction<Integer, Integer, T> compute) {
        long twoInts = this.container.get();
        return compute.apply(ByteUtils.extractLeftInt((long)twoInts), ByteUtils.extractRightInt((long)twoInts));
    }

    public <T> T computeAndReset(BiFunction<Integer, Integer, T> compute) {
        long twoInts = this.container.getAndSet(0L);
        return compute.apply(ByteUtils.extractLeftInt((long)twoInts), ByteUtils.extractRightInt((long)twoInts));
    }

    public <T> T computeAndSet(BiFunction<Integer, Integer, T> compute, int left, int right) {
        long twoInts = this.container.getAndSet(ByteUtils.combineInts((int)left, (int)right));
        return compute.apply(ByteUtils.extractLeftInt((long)twoInts), ByteUtils.extractRightInt((long)twoInts));
    }

    public void reset() {
        this.container.getAndSet(0L);
    }
}

