/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.event;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.platform.event.EventDescriptor;
import com.hedera.hapi.platform.event.GossipEvent;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.hiero.base.crypto.AbstractHashable;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.transaction.TransactionWrapper;

public class EventMetadata
extends AbstractHashable {
    private static final boolean SET_GENERATIONS_TO_ZERO = true;
    private final NodeId creatorId;
    private EventDescriptorWrapper selfParent;
    private List<EventDescriptorWrapper> otherParents;
    private List<EventDescriptorWrapper> allParents;
    private final long generation;
    private final Instant timeCreated;
    private final List<TransactionWrapper> transactions;
    private EventDescriptorWrapper descriptor;
    private final long birthRound;

    public EventMetadata(@NonNull NodeId creatorId, @Nullable EventDescriptorWrapper selfParent, @NonNull List<EventDescriptorWrapper> otherParents, @NonNull Instant timeCreated, @NonNull List<Bytes> transactions, long birthRound) {
        Objects.requireNonNull(transactions, "The transactions must not be null");
        this.creatorId = Objects.requireNonNull(creatorId, "The creatorId must not be null");
        this.selfParent = selfParent;
        this.otherParents = List.copyOf(otherParents);
        this.allParents = selfParent == null ? this.otherParents : Stream.concat(Stream.of(selfParent), otherParents.stream()).toList();
        this.generation = 0L;
        this.timeCreated = Objects.requireNonNull(timeCreated, "The timeCreated must not be null");
        this.transactions = Objects.requireNonNull(transactions, "transactions must not be null").stream().map(TransactionWrapper::new).toList();
        this.birthRound = birthRound;
    }

    public EventMetadata(@NonNull GossipEvent gossipEvent) {
        Objects.requireNonNull(gossipEvent.eventCore(), "The eventCore must not be null");
        this.creatorId = NodeId.of(gossipEvent.eventCore().creatorNodeId());
        this.allParents = gossipEvent.parents().stream().map(EventDescriptorWrapper::new).toList();
        if (!this.allParents.isEmpty() && this.allParents.getFirst().creator().equals(this.creatorId)) {
            this.selfParent = this.allParents.getFirst();
            this.otherParents = this.allParents.subList(1, this.allParents.size());
        } else {
            this.selfParent = null;
            this.otherParents = this.allParents;
        }
        this.generation = 0L;
        this.overrideParentGenerationsToZero();
        this.timeCreated = HapiUtils.asInstant((Timestamp)Objects.requireNonNull(gossipEvent.eventCore().timeCreated(), "The timeCreated must not be null"));
        this.transactions = gossipEvent.transactions().stream().map(TransactionWrapper::new).toList();
        this.birthRound = gossipEvent.eventCore().birthRound();
    }

    private static long calculateGeneration(@NonNull List<EventDescriptorWrapper> allParents) {
        return 1L + Objects.requireNonNull(allParents).stream().mapToLong(d -> d.eventDescriptor().generation()).max().orElse(-1L);
    }

    public long getBirthRound() {
        return this.birthRound;
    }

    @NonNull
    public NodeId getCreatorId() {
        return this.creatorId;
    }

    @Nullable
    public EventDescriptorWrapper getSelfParent() {
        return this.selfParent;
    }

    @Nullable
    public Hash getSelfParentHash() {
        if (this.selfParent == null) {
            return null;
        }
        return this.selfParent.hash();
    }

    @NonNull
    public List<EventDescriptorWrapper> getOtherParents() {
        return this.otherParents;
    }

    public boolean hasOtherParents() {
        return this.otherParents != null && !this.otherParents.isEmpty();
    }

    @NonNull
    public List<EventDescriptorWrapper> getAllParents() {
        return this.allParents;
    }

    @NonNull
    public Instant getTimeCreated() {
        return this.timeCreated;
    }

    @NonNull
    public List<TransactionWrapper> getTransactions() {
        return this.transactions;
    }

    public long getGeneration() {
        return this.generation;
    }

    @NonNull
    public EventDescriptorWrapper getDescriptor() {
        if (this.descriptor == null) {
            if (this.getHash() == null) {
                throw new IllegalStateException("The hash of the event must be set before creating the descriptor");
            }
            this.descriptor = new EventDescriptorWrapper(new EventDescriptor(this.getHash().getBytes(), this.creatorId.id(), this.getBirthRound(), this.getGeneration()));
        }
        return this.descriptor;
    }

    public void overrideParentGenerationsToZero() {
        if (this.selfParent != null && this.selfParent.eventDescriptor().generation() > 0L) {
            this.selfParent = new EventDescriptorWrapper(new EventDescriptor(this.selfParent.eventDescriptor().hash(), this.selfParent.eventDescriptor().creatorNodeId(), this.selfParent.eventDescriptor().birthRound(), 0L));
        }
        this.otherParents = this.otherParents.stream().map(parent -> {
            if (parent.eventDescriptor().generation() > 0L) {
                return new EventDescriptorWrapper(new EventDescriptor(parent.eventDescriptor().hash(), parent.eventDescriptor().creatorNodeId(), parent.eventDescriptor().birthRound(), 0L));
            }
            return parent;
        }).toList();
        this.allParents = this.selfParent == null ? this.otherParents : Stream.concat(Stream.of(this.selfParent), this.otherParents.stream()).toList();
    }
}

