/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.virtualmap.internal.reconnect;

import com.swirlds.common.io.streams.MerkleDataInputStream;
import com.swirlds.common.io.streams.MerkleDataOutputStream;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.synchronization.LearningSynchronizer;
import com.swirlds.common.merkle.synchronization.config.ReconnectConfig;
import com.swirlds.common.merkle.synchronization.stats.ReconnectMapStats;
import com.swirlds.common.merkle.synchronization.streams.AsyncOutputStream;
import com.swirlds.common.merkle.synchronization.task.ExpectedLesson;
import com.swirlds.common.merkle.synchronization.task.ReconnectNodeCount;
import com.swirlds.common.merkle.synchronization.utility.MerkleSynchronizationException;
import com.swirlds.common.merkle.synchronization.views.LearnerTreeView;
import com.swirlds.common.threading.pool.StandardWorkGroup;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualValue;
import com.swirlds.virtualmap.datasource.VirtualLeafRecord;
import com.swirlds.virtualmap.internal.RecordAccessor;
import com.swirlds.virtualmap.internal.VirtualStateAccessor;
import com.swirlds.virtualmap.internal.merkle.VirtualRootNode;
import com.swirlds.virtualmap.internal.reconnect.LearnerPullVirtualTreeReceiveTask;
import com.swirlds.virtualmap.internal.reconnect.LearnerPullVirtualTreeSendTask;
import com.swirlds.virtualmap.internal.reconnect.NodeTraversalOrder;
import com.swirlds.virtualmap.internal.reconnect.PullVirtualTreeRequest;
import com.swirlds.virtualmap.internal.reconnect.ReconnectNodeRemover;
import com.swirlds.virtualmap.internal.reconnect.VirtualTreeViewBase;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.hiero.base.crypto.Cryptography;
import org.hiero.base.crypto.Hash;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class LearnerPullVirtualTreeView<K extends VirtualKey, V extends VirtualValue>
extends VirtualTreeViewBase<K, V>
implements LearnerTreeView<Long> {
    private final ReconnectConfig reconnectConfig;
    private final ReconnectNodeRemover<K, V> nodeRemover;
    private ReconnectNodeCount nodeCount;
    private final RecordAccessor<K, V> originalRecords;
    private final NodeTraversalOrder traversalOrder;
    private final ReconnectMapStats mapStats;
    private boolean firstNodeResponse = true;

    public LearnerPullVirtualTreeView(ReconnectConfig reconnectConfig, VirtualRootNode<K, V> root, RecordAccessor<K, V> originalRecords, VirtualStateAccessor originalState, VirtualStateAccessor reconnectState, ReconnectNodeRemover<K, V> nodeRemover, NodeTraversalOrder traversalOrder, @NonNull ReconnectMapStats mapStats) {
        super(root, originalState, reconnectState);
        this.reconnectConfig = reconnectConfig;
        this.originalRecords = Objects.requireNonNull(originalRecords);
        this.nodeRemover = nodeRemover;
        this.traversalOrder = traversalOrder;
        this.mapStats = mapStats;
    }

    public void startLearnerTasks(LearningSynchronizer learningSynchronizer, StandardWorkGroup workGroup, MerkleDataInputStream inputStream, MerkleDataOutputStream outputStream, Queue<MerkleNode> rootsToReceive, AtomicReference<Long> reconstructedRoot) {
        this.nodeCount = learningSynchronizer;
        AsyncOutputStream out = learningSynchronizer.buildOutputStream(workGroup, (SerializableDataOutputStream)outputStream);
        out.start();
        AtomicBoolean senderIsFinished = new AtomicBoolean();
        CountDownLatch rootResponseReceived = new CountDownLatch(1);
        AtomicLong expectedResponses = new AtomicLong(0L);
        LearnerPullVirtualTreeReceiveTask learnerReceiveTask = new LearnerPullVirtualTreeReceiveTask(workGroup, (SerializableDataInputStream)inputStream, this, senderIsFinished, expectedResponses, rootResponseReceived);
        learnerReceiveTask.exec();
        reconstructedRoot.set(0L);
        assert (this.traversalOrder != null);
        LearnerPullVirtualTreeSendTask learnerSendTask = new LearnerPullVirtualTreeSendTask(this.reconnectConfig, workGroup, (AsyncOutputStream<PullVirtualTreeRequest>)out, this, this.traversalOrder, senderIsFinished, rootResponseReceived, expectedResponses);
        learnerSendTask.exec();
    }

    public boolean isLeaf(long path) {
        assert (path <= this.reconnectState.getLastLeafPath());
        return path >= this.reconnectState.getFirstLeafPath();
    }

    public void readNode(SerializableDataInputStream in, long path, boolean isClean) throws IOException {
        if (path == 0L) {
            long firstLeafPath = in.readLong();
            long lastLeafPath = in.readLong();
            if (this.firstNodeResponse) {
                this.reconnectState.setFirstLeafPath(firstLeafPath);
                this.reconnectState.setLastLeafPath(lastLeafPath);
                this.root.prepareReconnectHashing(firstLeafPath, lastLeafPath);
                this.nodeRemover.setPathInformation(firstLeafPath, lastLeafPath);
                this.traversalOrder.start(firstLeafPath, lastLeafPath, this.nodeCount);
                this.firstNodeResponse = false;
                if (lastLeafPath <= 0L) {
                    return;
                }
            }
        }
        assert (!this.firstNodeResponse) : "Root node must be the first node received from the teacher";
        boolean isLeaf = this.isLeaf(path);
        this.traversalOrder.nodeReceived(path, isClean);
        if (isLeaf && !isClean) {
            VirtualLeafRecord leaf = (VirtualLeafRecord)in.readSerializable(false, VirtualLeafRecord::new);
            this.mapStats.incrementLeafData(1, 0);
            assert (path == leaf.getPath());
            this.nodeRemover.newLeafNode(path, leaf.getKey());
            this.root.handleReconnectLeaf(leaf);
        }
    }

    @NonNull
    public ReconnectMapStats getMapStats() {
        return this.mapStats;
    }

    public boolean isRootOfState() {
        return false;
    }

    public Long getOriginalRoot() {
        return 0L;
    }

    public Hash getNodeHash(Long originalChild) {
        if (originalChild > this.originalState.getLastLeafPath()) {
            return Cryptography.NULL_HASH;
        }
        Hash hash = this.originalRecords.findHash(originalChild);
        if (hash == null) {
            throw new MerkleSynchronizationException("Node found, but hash was null. path=" + originalChild);
        }
        return hash;
    }

    public void expectLessonFor(Long parent, int childIndex, Long original, boolean nodeAlreadyPresent) {
        throw new UnsupportedOperationException("LearnerPullVirtualTreeView.expectLessonFor()");
    }

    public ExpectedLesson<Long> getNextExpectedLesson() {
        throw new UnsupportedOperationException("LearnerPullVirtualTreeView.getNextExpectedLesson()");
    }

    public boolean hasNextExpectedLesson() {
        throw new UnsupportedOperationException("LearnerPullVirtualTreeView.hasNextExpectedLesson()");
    }

    public Long deserializeLeaf(SerializableDataInputStream in) throws IOException {
        throw new UnsupportedOperationException("LearnerPullVirtualTreeView.deserializeLeaf()");
    }

    public Long deserializeInternal(SerializableDataInputStream in) throws IOException {
        throw new UnsupportedOperationException("LearnerPullVirtualTreeView.deserializeInternal()");
    }

    public void initialize() {
    }

    public void close() {
        this.nodeRemover.allNodesReceived();
        this.root.endLearnerReconnect();
    }

    public void markForInitialization(Long node) {
    }

    public void releaseNode(Long node) {
    }

    public void setChild(Long parent, int childIndex, Long child) {
    }

    public Long convertMerkleRootToViewType(MerkleNode node) {
        throw new UnsupportedOperationException("Nested virtual maps not supported");
    }

    public void recordHashStats(@NonNull ReconnectMapStats mapStats, @NonNull Long parent, int childIndex, boolean nodeAlreadyPresent) {
        throw new UnsupportedOperationException("The Reconnect Pull Model records the hash stats elsewhere");
    }
}

