/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.logging;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.FileID;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TopicID;
import com.swirlds.fcqueue.FCQueue;
import com.swirlds.state.merkle.disk.OnDiskKey;
import com.swirlds.state.merkle.disk.OnDiskValue;
import com.swirlds.state.merkle.memory.InMemoryKey;
import com.swirlds.state.merkle.memory.InMemoryValue;
import com.swirlds.state.merkle.singleton.ValueLeaf;
import com.swirlds.virtualmap.VirtualKey;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.internal.merkle.VirtualLeafNode;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StateLogger {
    private static final Logger logger = LogManager.getLogger(StateLogger.class);
    private static final String TRANSACTION_HANDLING_THREAD_NAME = "<scheduler TransactionHandler>";

    public static <T> void logSingletonRead(@NonNull String label, @Nullable ValueLeaf<T> value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      READ singleton {} value {}", (Object)label, (Object)(value == null ? "null" : value.getValue()));
        }
    }

    public static void logSingletonWrite(@NonNull String label, @Nullable Object value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      WRITTEN singleton {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static void logQueueAdd(@NonNull String label, @Nullable Object value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      ADD to queue {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static void logQueueRemove(@NonNull String label, @Nullable Object value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      REMOVE from queue {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static void logQueuePeek(@NonNull String label, @Nullable Object value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      PEEK on queue {} value {}", (Object)label, (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <K> void logQueueIterate(@NonNull String label, @NonNull FCQueue<ValueLeaf<K>> queue) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            if (queue.isEmpty()) {
                logger.debug("      ITERATE queue {} size 0 values:EMPTY", (Object)label);
            } else {
                logger.debug("      ITERATE queue {} size {} values:\n{}", (Object)label, (Object)queue.size(), (Object)queue.stream().map(leaf -> leaf == null ? "null" : ((Object)leaf).toString()).collect(Collectors.joining(",\n")));
            }
        }
    }

    public static <K, V> void logMapPut(@NonNull String label, @NonNull K key, @Nullable V value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      PUT into map {} key {} value {}", (Object)label, (Object)StateLogger.formatKey(key), (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <K, V> void logMapRemove(@NonNull String label, @NonNull K key, @Nullable InMemoryValue<K, V> value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      REMOVE from map {} key {} removed value {}", (Object)label, (Object)StateLogger.formatKey(key), (Object)(value == null ? "null" : ((Object)value).toString()));
        }
    }

    public static <K, V> void logMapRemove(@NonNull String label, @NonNull K key, @Nullable OnDiskValue<V> value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      REMOVE from map {} key {} removed value {}", (Object)label, (Object)StateLogger.formatKey(key), (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static void logMapGetSize(@NonNull String label, long size) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      GET_SIZE on map {} size {}", (Object)label, (Object)size);
        }
    }

    public static <K, V> void logMapGet(@NonNull String label, @NonNull K key, @Nullable V value) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            logger.debug("      GET on map {} key {} value {}", (Object)label, (Object)StateLogger.formatKey(key), (Object)(value == null ? "null" : value.toString()));
        }
    }

    public static <K> void logMapIterate(@NonNull String label, @NonNull Set<InMemoryKey<K>> keySet) {
        if (logger.isDebugEnabled() && Thread.currentThread().getName().equals(TRANSACTION_HANDLING_THREAD_NAME)) {
            long size = keySet.size();
            if (size == 0L) {
                logger.debug("      ITERATE map {} size 0 keys:EMPTY", (Object)label);
            } else {
                logger.debug("      ITERATE map {} size {} keys:\n{}", (Object)label, (Object)size, (Object)keySet.stream().map(InMemoryKey::key).map(StateLogger::formatKey).collect(Collectors.joining(",\n")));
            }
        }
    }

    public static <K, V> void logMapIterate(@NonNull String label, @NonNull VirtualMap<OnDiskKey<K>, OnDiskValue<V>> virtualMap) {
        if (logger.isDebugEnabled()) {
            Spliterator spliterator = Spliterators.spliterator(virtualMap.treeIterator(), virtualMap.size(), 0);
            long size = virtualMap.size();
            if (size == 0L) {
                logger.debug("      ITERATE map {} size 0 keys:EMPTY", (Object)label);
            } else {
                logger.debug("      ITERATE map {} size {} keys:\n{}", (Object)label, (Object)size, (Object)StreamSupport.stream(spliterator, false).map(merkleNode -> {
                    VirtualLeafNode leaf;
                    VirtualKey k;
                    if (merkleNode instanceof VirtualLeafNode && (k = (leaf = (VirtualLeafNode)merkleNode).getKey()) instanceof OnDiskKey) {
                        OnDiskKey onDiskKey = (OnDiskKey)k;
                        return onDiskKey.getKey().toString();
                    }
                    return "Unknown_Type";
                }).collect(Collectors.joining(",\n")));
            }
        }
    }

    public static <K> String formatKey(@Nullable K key) {
        if (key == null) {
            return "null";
        }
        if (key instanceof AccountID) {
            AccountID accountID = (AccountID)key;
            return accountID.shardNum() + "." + accountID.realmNum() + "." + accountID.accountNum();
        }
        if (key instanceof FileID) {
            FileID fileID = (FileID)key;
            return fileID.shardNum() + "." + fileID.realmNum() + "." + fileID.fileNum();
        }
        if (key instanceof TokenID) {
            TokenID tokenID = (TokenID)key;
            return tokenID.shardNum() + "." + tokenID.realmNum() + "." + tokenID.tokenNum();
        }
        if (key instanceof TopicID) {
            TopicID topicID = (TopicID)key;
            return topicID.shardNum() + "." + topicID.realmNum() + "." + topicID.topicNum();
        }
        if (key instanceof ScheduleID) {
            ScheduleID scheduleID = (ScheduleID)key;
            return scheduleID.shardNum() + "." + scheduleID.realmNum() + "." + scheduleID.scheduleNum();
        }
        return key.toString();
    }
}

