/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.merkledb.test.fixtures;

import com.swirlds.merkledb.test.fixtures.ExampleByteArrayVirtualValue;
import com.swirlds.virtualmap.VirtualValue;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.Random;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;

public final class ExampleFixedSizeVirtualValue
extends ExampleByteArrayVirtualValue {
    public static final int RANDOM_BYTES = 32;
    public static final int SIZE_BYTES = 36;
    static final byte[] RANDOM_DATA = new byte[32];
    public static final int SERIALIZATION_VERSION = 287;
    private int id;
    private byte[] data;

    public ExampleFixedSizeVirtualValue() {
    }

    public ExampleFixedSizeVirtualValue(int id) {
        this.id = id;
        this.data = RANDOM_DATA;
    }

    public ExampleFixedSizeVirtualValue(int id, byte[] data) {
        this.id = id;
        this.data = new byte[data.length];
        System.arraycopy(data, 0, this.data, 0, data.length);
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    public void deserialize(SerializableDataInputStream inputStream, int dataVersion) throws IOException {
        assert (dataVersion == this.getVersion()) : "dataVersion=" + dataVersion + " != getVersion()=" + this.getVersion();
        this.id = inputStream.readInt();
        this.data = new byte[32];
        inputStream.read(this.data);
    }

    public void serialize(SerializableDataOutputStream outputStream) throws IOException {
        outputStream.writeInt(this.id);
        outputStream.write(this.data);
    }

    void serialize(ByteBuffer buffer) {
        buffer.putInt(this.id);
        buffer.put(this.data);
    }

    void deserialize(ByteBuffer buffer, int dataVersion) {
        assert (dataVersion == this.getVersion()) : "dataVersion=" + dataVersion + " != getVersion()=" + this.getVersion();
        this.id = buffer.getInt();
        this.data = new byte[32];
        buffer.get(this.data);
    }

    public VirtualValue copy() {
        return new ExampleFixedSizeVirtualValue(this.id, this.data);
    }

    public VirtualValue asReadOnly() {
        return this;
    }

    public long getClassId() {
        return 1438455686395469L;
    }

    public int getVersion() {
        return 287;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExampleFixedSizeVirtualValue that = (ExampleFixedSizeVirtualValue)o;
        return this.id == that.id && Arrays.equals(this.data, that.data);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.id);
        result = 31 * result + Arrays.hashCode(this.data);
        return result;
    }

    public String toString() {
        return "TestLeafData{id=" + this.id + ", data=" + Arrays.toString(this.data) + "}";
    }

    static {
        new Random(12234L).nextBytes(RANDOM_DATA);
    }
}

