/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle;

import com.swirlds.base.time.Time;
import com.swirlds.common.merkle.MerkleInternal;
import com.swirlds.common.merkle.MerkleNode;
import com.swirlds.common.merkle.crypto.MerkleCryptography;
import com.swirlds.common.merkle.impl.PartialNaryMerkleInternal;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotReader;
import com.swirlds.common.merkle.utility.MerkleTreeSnapshotWriter;
import com.swirlds.common.utility.Labeled;
import com.swirlds.common.utility.RuntimeObjectRecord;
import com.swirlds.common.utility.RuntimeObjectRegistry;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkle.map.MerkleMap;
import com.swirlds.metrics.api.Metrics;
import com.swirlds.state.State;
import com.swirlds.state.StateChangeListener;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.merkle.MerkleRootSnapshotMetrics;
import com.swirlds.state.merkle.disk.OnDiskReadableKVState;
import com.swirlds.state.merkle.disk.OnDiskWritableKVState;
import com.swirlds.state.merkle.memory.InMemoryReadableKVState;
import com.swirlds.state.merkle.memory.InMemoryWritableKVState;
import com.swirlds.state.merkle.queue.QueueNode;
import com.swirlds.state.merkle.queue.ReadableQueueStateImpl;
import com.swirlds.state.merkle.queue.WritableQueueStateImpl;
import com.swirlds.state.merkle.singleton.ReadableSingletonStateImpl;
import com.swirlds.state.merkle.singleton.SingletonNode;
import com.swirlds.state.merkle.singleton.WritableSingletonStateImpl;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.EmptyReadableStates;
import com.swirlds.state.spi.KVChangeListener;
import com.swirlds.state.spi.QueueChangeListener;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableQueueState;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableKVState;
import com.swirlds.state.spi.WritableKVStateBase;
import com.swirlds.state.spi.WritableQueueState;
import com.swirlds.state.spi.WritableQueueStateBase;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableSingletonStateBase;
import com.swirlds.state.spi.WritableStates;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.base.constructable.ConstructableIgnored;

@ConstructableIgnored
public abstract class MerkleStateRoot<T extends MerkleStateRoot<T>>
extends PartialNaryMerkleInternal
implements MerkleInternal,
State {
    private static final Logger logger = LogManager.getLogger(MerkleStateRoot.class);
    private static final long CLASS_ID = -8201042766723040485L;
    public static final int CURRENT_VERSION = 31;
    private static final Map<String, Integer> INDEX_LOOKUP = new ConcurrentHashMap<String, Integer>();
    private LongSupplier roundSupplier;
    private MerkleCryptography merkleCryptography;
    private Time time;
    private Metrics metrics;
    private MerkleRootSnapshotMetrics snapshotMetrics = new MerkleRootSnapshotMetrics();
    private final Map<String, Map<String, StateMetadata<?, ?>>> services = new HashMap();
    private final Map<String, ReadableStates> readableStatesMap = new ConcurrentHashMap<String, ReadableStates>();
    private final Map<String, MerkleWritableStates> writableStatesMap = new HashMap<String, MerkleWritableStates>();
    private final List<StateChangeListener> listeners = new ArrayList<StateChangeListener>();
    private final RuntimeObjectRecord registryRecord = RuntimeObjectRegistry.createRecord(((Object)((Object)this)).getClass());

    public Map<String, Map<String, StateMetadata<?, ?>>> getServices() {
        return this.services;
    }

    public MerkleStateRoot() {
    }

    public void init(Time time, Metrics metrics, MerkleCryptography merkleCryptography, LongSupplier roundSupplier) {
        this.time = time;
        this.metrics = metrics;
        this.merkleCryptography = merkleCryptography;
        this.roundSupplier = roundSupplier;
        this.snapshotMetrics = new MerkleRootSnapshotMetrics(metrics);
    }

    protected MerkleStateRoot(@NonNull MerkleStateRoot<T> from) {
        super(from);
        this.listeners.addAll(from.listeners);
        this.roundSupplier = from.roundSupplier;
        for (Map.Entry<String, Map<String, StateMetadata<?, ?>>> entry : from.services.entrySet()) {
            this.services.put(entry.getKey(), new HashMap(entry.getValue()));
        }
        int n = from.getNumberOfChildren();
        for (int childIndex = 0; childIndex < n; ++childIndex) {
            MerkleNode childToCopy = from.getChild(childIndex);
            if (childToCopy == null) continue;
            this.setChild(childIndex, childToCopy.copy());
        }
    }

    public long getClassId() {
        return -8201042766723040485L;
    }

    public int getVersion() {
        return 31;
    }

    public int getMinimumSupportedVersion() {
        return 31;
    }

    public void close() {
        logger.info("Closing MerkleStateRoot");
        for (Map<String, StateMetadata<?, ?>> svc : this.services.values()) {
            for (StateMetadata<?, ?> md : svc.values()) {
                MerkleNode node;
                int index = this.findNodeIndex(md.serviceName(), MerkleStateRoot.extractStateKey(md));
                if (index < 0 || !((node = this.getChild(index)) instanceof VirtualMap)) continue;
                VirtualMap virtualMap = (VirtualMap)node;
                try {
                    virtualMap.getDataSource().close();
                }
                catch (IOException e) {
                    logger.warn("Unable to close data source for virtual map {}", (Object)md.serviceName(), (Object)e);
                }
            }
        }
    }

    public void destroyNode() {
        this.registryRecord.release();
    }

    @NonNull
    public ReadableStates getReadableStates(@NonNull String serviceName) {
        return this.readableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<String, StateMetadata<?, ?>> stateMetadata = this.services.get(s);
            return stateMetadata == null ? EmptyReadableStates.INSTANCE : new MerkleReadableStates(this, stateMetadata);
        });
    }

    @NonNull
    public WritableStates getWritableStates(@NonNull String serviceName) {
        this.throwIfImmutable();
        return this.writableStatesMap.computeIfAbsent(serviceName, s -> {
            Map<String, StateMetadata<?, ?>> stateMetadata = this.services.getOrDefault(s, Map.of());
            return new MerkleWritableStates(serviceName, stateMetadata);
        });
    }

    public void registerCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.add(listener);
    }

    public void unregisterCommitListener(@NonNull StateChangeListener listener) {
        Objects.requireNonNull(listener);
        this.listeners.remove(listener);
    }

    @NonNull
    public T copy() {
        this.throwIfImmutable();
        this.throwIfDestroyed();
        this.setImmutable(true);
        return this.copyingConstructor();
    }

    protected abstract T copyingConstructor();

    public MerkleNode migrate(int version) {
        if (version < this.getMinimumSupportedVersion()) {
            throw new UnsupportedOperationException("State migration from version " + version + " is not supported. The minimum supported version is " + this.getMinimumSupportedVersion());
        }
        return this;
    }

    public <T extends MerkleNode> void putServiceStateIfAbsent(@NonNull StateMetadata<?, ?> md, @NonNull Supplier<T> nodeSupplier, @NonNull Consumer<T> nodeInitializer) {
        MerkleNode node;
        logger.info(LogMarker.STARTUP.getMarker(), "Putting states... ", (Object)md.serviceName());
        this.throwIfImmutable();
        Objects.requireNonNull(md);
        Objects.requireNonNull(nodeSupplier);
        Objects.requireNonNull(nodeInitializer);
        StateDefinition def = md.stateDefinition();
        String serviceName = md.serviceName();
        Map stateMetadata = this.services.computeIfAbsent(serviceName, k -> new HashMap());
        stateMetadata.put(def.stateKey(), md);
        this.readableStatesMap.put(serviceName, new MerkleReadableStates(this, stateMetadata));
        this.writableStatesMap.put(serviceName, new MerkleWritableStates(serviceName, stateMetadata));
        logger.info(LogMarker.STARTUP.getMarker(), "Put states! Service name: {} ", (Object)md.serviceName());
        int nodeIndex = this.findNodeIndex(serviceName, def.stateKey());
        if (nodeIndex == -1) {
            String label;
            node = Objects.requireNonNull((MerkleNode)nodeSupplier.get());
            if (node instanceof Labeled) {
                Labeled labeled = (Labeled)node;
                v0 = labeled.getLabel();
            } else {
                v0 = label = null;
            }
            if (label == null) {
                throw new IllegalArgumentException("`node` must be a Labeled and have a label");
            }
            if (def.onDisk() && !(node instanceof VirtualMap)) {
                throw new IllegalArgumentException("Mismatch: state definition claims on-disk, but the merkle node is not a VirtualMap");
            }
            if (label.isEmpty()) {
                throw new IllegalArgumentException("A label must be specified on the node");
            }
            if (!label.equals(StateMetadata.computeLabel((String)serviceName, (String)def.stateKey()))) {
                throw new IllegalArgumentException("A label must be computed based on the same service name and state key in the metadata!");
            }
            logger.info(LogMarker.STARTUP.getMarker(), "Setting child.. Service name: {} / Number of children: {} / node: {}", (Object)md.serviceName(), (Object)this.getNumberOfChildren(), (Object)node);
            this.setChild(this.getNumberOfChildren(), node);
        } else {
            logger.info(LogMarker.STARTUP.getMarker(), "Getting child.. Service name: {} / Number of children: {} / node: {}", (Object)md.serviceName(), (Object)this.getNumberOfChildren(), (Object)nodeIndex);
            node = this.getChild(nodeIndex);
        }
        nodeInitializer.accept(node);
    }

    public void unregisterService(@NonNull String serviceName) {
        this.readableStatesMap.remove(serviceName);
        this.writableStatesMap.remove(serviceName);
        this.services.remove(serviceName);
    }

    public void removeServiceState(@NonNull String serviceName, @NonNull String stateKey) {
        int index;
        MerkleWritableStates writableStates;
        this.throwIfImmutable();
        Objects.requireNonNull(serviceName);
        Objects.requireNonNull(stateKey);
        Map<String, StateMetadata<?, ?>> stateMetadata = this.services.get(serviceName);
        if (stateMetadata != null) {
            stateMetadata.remove(stateKey);
        }
        if ((writableStates = this.writableStatesMap.get(serviceName)) != null) {
            writableStates.remove(stateKey);
        }
        if ((index = this.findNodeIndex(serviceName, stateKey)) != -1) {
            this.setChild(index, null);
        }
    }

    public int findNodeIndex(@NonNull String serviceName, @NonNull String stateKey) {
        String label = StateMetadata.computeLabel((String)serviceName, (String)stateKey);
        Integer index = INDEX_LOOKUP.get(label);
        if (index != null && this.checkNodeIndex(index, label)) {
            return index;
        }
        int n = this.getNumberOfChildren();
        for (int i = 0; i < n; ++i) {
            if (!this.checkNodeIndex(i, label)) continue;
            INDEX_LOOKUP.put(label, i);
            return i;
        }
        INDEX_LOOKUP.remove(label);
        return -1;
    }

    private boolean checkNodeIndex(int index, @NonNull String label) {
        Labeled labeled;
        MerkleNode node = this.getChild(index);
        return node instanceof Labeled && Objects.equals(label, (labeled = (Labeled)node).getLabel());
    }

    @NonNull
    private static String extractStateKey(@NonNull StateMetadata<?, ?> md) {
        return md.stateDefinition().stateKey();
    }

    public void computeHash() {
        Objects.requireNonNull(this.merkleCryptography, "MerkleStateRoot has to be initialized before hashing. merkleCryptography is not set.");
        this.throwIfMutable("Hashing should only be done on immutable states");
        this.throwIfDestroyed("Hashing should not be done on destroyed states");
        if (this.getHash() != null) {
            return;
        }
        try {
            this.merkleCryptography.digestTreeAsync((MerkleNode)this).get();
        }
        catch (ExecutionException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Exception occurred during hashing", (Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Interrupted while hashing state. Expect buggy behavior.");
            Thread.currentThread().interrupt();
        }
    }

    public void createSnapshot(@NonNull Path targetPath) {
        Objects.requireNonNull(this.time);
        Objects.requireNonNull(this.snapshotMetrics);
        this.throwIfMutable();
        this.throwIfDestroyed();
        long startTime = this.time.currentTimeMillis();
        MerkleTreeSnapshotWriter.createSnapshot((MerkleNode)this, (Path)targetPath, (long)this.roundSupplier.getAsLong());
        this.snapshotMetrics.updateWriteStateToDiskTimeMetric(this.time.currentTimeMillis() - startTime);
    }

    public T loadSnapshot(@NonNull Path targetPath) throws IOException {
        return (T)((Object)((MerkleStateRoot)MerkleTreeSnapshotReader.readStateFileData((Path)targetPath).stateRoot()));
    }

    public final class MerkleReadableStates
    extends MerkleStates {
        MerkleReadableStates(@NonNull MerkleStateRoot this$0, Map<String, StateMetadata<?, ?>> stateMetadata) {
            super(stateMetadata);
        }

        @NonNull
        protected ReadableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull VirtualMap v) {
            return new OnDiskReadableKVState(MerkleStateRoot.extractStateKey(md), md.onDiskKeyClassId(), md.stateDefinition().keyCodec(), v);
        }

        @NonNull
        protected ReadableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull MerkleMap m) {
            return new InMemoryReadableKVState(MerkleStateRoot.extractStateKey(md), m);
        }

        @NonNull
        protected ReadableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md, @NonNull SingletonNode<?> s) {
            return new ReadableSingletonStateImpl(MerkleStateRoot.extractStateKey(md), s);
        }

        @Override
        @NonNull
        protected ReadableQueueState createReadableQueueState(@NonNull StateMetadata md, @NonNull QueueNode<?> q) {
            return new ReadableQueueStateImpl(MerkleStateRoot.extractStateKey(md), q);
        }
    }

    public final class MerkleWritableStates
    extends MerkleStates
    implements WritableStates,
    CommittableWritableStates {
        private final String serviceName;

        MerkleWritableStates(@NonNull String serviceName, Map<String, StateMetadata<?, ?>> stateMetadata) {
            super(stateMetadata);
            this.serviceName = Objects.requireNonNull(serviceName);
        }

        public void copyAndReleaseVirtualMap(@NonNull String stateKey) {
            StateMetadata md = (StateMetadata)this.stateMetadata.get(stateKey);
            VirtualMap virtualMap = (VirtualMap)this.findNode(md);
            VirtualMap mutableCopy = virtualMap.copy();
            if (MerkleStateRoot.this.metrics != null) {
                mutableCopy.registerMetrics(MerkleStateRoot.this.metrics);
            }
            MerkleStateRoot.this.setChild(MerkleStateRoot.this.findNodeIndex(this.serviceName, stateKey), (MerkleNode)mutableCopy);
            this.kvInstances.put(stateKey, this.createReadableKVState(md, mutableCopy));
        }

        @NonNull
        public <K, V> WritableKVState<K, V> get(@NonNull String stateKey) {
            return (WritableKVState)super.get(stateKey);
        }

        @NonNull
        public <S> WritableSingletonState<S> getSingleton(@NonNull String stateKey) {
            return (WritableSingletonState)super.getSingleton(stateKey);
        }

        @NonNull
        public <E> WritableQueueState<E> getQueue(@NonNull String stateKey) {
            return (WritableQueueState)super.getQueue(stateKey);
        }

        @NonNull
        protected WritableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull VirtualMap v) {
            OnDiskWritableKVState state = new OnDiskWritableKVState(MerkleStateRoot.extractStateKey(md), md.onDiskKeyClassId(), md.stateDefinition().keyCodec(), md.onDiskValueClassId(), md.stateDefinition().valueCodec(), v);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.MAP)) {
                    this.registerKVListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableKVState<?, ?> createReadableKVState(@NonNull StateMetadata md, @NonNull MerkleMap m) {
            InMemoryWritableKVState state = new InMemoryWritableKVState(MerkleStateRoot.extractStateKey(md), md.inMemoryValueClassId(), md.stateDefinition().keyCodec(), md.stateDefinition().valueCodec(), m);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.MAP)) {
                    this.registerKVListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableSingletonState<?> createReadableSingletonState(@NonNull StateMetadata md, @NonNull SingletonNode<?> s) {
            WritableSingletonStateImpl state = new WritableSingletonStateImpl(MerkleStateRoot.extractStateKey(md), s);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.SINGLETON)) {
                    this.registerSingletonListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        @NonNull
        protected WritableQueueState<?> createReadableQueueState(@NonNull StateMetadata md, @NonNull QueueNode<?> q) {
            WritableQueueStateImpl state = new WritableQueueStateImpl(MerkleStateRoot.extractStateKey(md), q);
            MerkleStateRoot.this.listeners.forEach(listener -> {
                if (listener.stateTypes().contains(StateChangeListener.StateType.QUEUE)) {
                    this.registerQueueListener(this.serviceName, state, (StateChangeListener)listener);
                }
            });
            return state;
        }

        public void commit() {
            for (ReadableKVState kv : this.kvInstances.values()) {
                ((WritableKVStateBase)kv).commit();
            }
            for (ReadableSingletonState s : this.singletonInstances.values()) {
                ((WritableSingletonStateBase)s).commit();
            }
            for (ReadableQueueState q : this.queueInstances.values()) {
                ((WritableQueueStateBase)q).commit();
            }
            MerkleStateRoot.this.readableStatesMap.remove(this.serviceName);
        }

        public void remove(String stateKey) {
            if (!Map.of().equals(this.stateMetadata)) {
                this.stateMetadata.remove(stateKey);
            }
            this.kvInstances.remove(stateKey);
            this.singletonInstances.remove(stateKey);
            this.queueInstances.remove(stateKey);
        }

        private <V> void registerSingletonListener(@NonNull String serviceName, @NonNull WritableSingletonStateBase<V> singletonState, @NonNull StateChangeListener listener) {
            int stateId = listener.stateIdFor(serviceName, singletonState.getStateKey());
            singletonState.registerListener(value -> listener.singletonUpdateChange(stateId, value));
        }

        private <V> void registerQueueListener(@NonNull String serviceName, @NonNull WritableQueueStateBase<V> queueState, final @NonNull StateChangeListener listener) {
            final int stateId = listener.stateIdFor(serviceName, queueState.getStateKey());
            queueState.registerListener(new QueueChangeListener<V>(this){

                public void queuePushChange(@NonNull V value) {
                    listener.queuePushChange(stateId, value);
                }

                public void queuePopChange() {
                    listener.queuePopChange(stateId);
                }
            });
        }

        private <K, V> void registerKVListener(@NonNull String serviceName, WritableKVStateBase<K, V> state, final StateChangeListener listener) {
            final int stateId = listener.stateIdFor(serviceName, state.getStateKey());
            state.registerListener(new KVChangeListener<K, V>(this){

                public void mapUpdateChange(@NonNull K key, @NonNull V value) {
                    listener.mapUpdateChange(stateId, key, value);
                }

                public void mapDeleteChange(@NonNull K key) {
                    listener.mapDeleteChange(stateId, key);
                }
            });
        }
    }

    private abstract class MerkleStates
    implements ReadableStates {
        protected final Map<String, StateMetadata<?, ?>> stateMetadata;
        protected final Map<String, ReadableKVState<?, ?>> kvInstances;
        protected final Map<String, ReadableSingletonState<?>> singletonInstances;
        protected final Map<String, ReadableQueueState<?>> queueInstances;
        private final Set<String> stateKeys;

        MerkleStates(Map<String, StateMetadata<?, ?>> stateMetadata) {
            this.stateMetadata = Objects.requireNonNull(stateMetadata);
            this.stateKeys = Collections.unmodifiableSet(stateMetadata.keySet());
            this.kvInstances = new HashMap();
            this.singletonInstances = new HashMap();
            this.queueInstances = new HashMap();
        }

        @NonNull
        public <K, V> ReadableKVState<K, V> get(@NonNull String stateKey) {
            ReadableKVState<?, ?> instance = this.kvInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown k/v state key '" + stateKey + ";");
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof VirtualMap) {
                VirtualMap v = (VirtualMap)node;
                ReadableKVState ret = this.createReadableKVState(md, v);
                this.kvInstances.put(stateKey, ret);
                return ret;
            }
            if (node instanceof MerkleMap) {
                MerkleMap m = (MerkleMap)node;
                ReadableKVState ret = this.createReadableKVState(md, m);
                this.kvInstances.put(stateKey, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for k/v state " + stateKey);
        }

        @NonNull
        public <S> ReadableSingletonState<S> getSingleton(@NonNull String stateKey) {
            ReadableSingletonState<?> instance = this.singletonInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || !md.stateDefinition().singleton()) {
                throw new IllegalArgumentException("Unknown singleton state key '" + stateKey + "'");
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof SingletonNode) {
                SingletonNode s = (SingletonNode)node;
                ReadableSingletonState ret = this.createReadableSingletonState(md, s);
                this.singletonInstances.put(stateKey, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for singleton state " + stateKey);
        }

        @NonNull
        public <E> ReadableQueueState<E> getQueue(@NonNull String stateKey) {
            ReadableQueueState<?> instance = this.queueInstances.get(stateKey);
            if (instance != null) {
                return instance;
            }
            StateMetadata<?, ?> md = this.stateMetadata.get(stateKey);
            if (md == null || !md.stateDefinition().queue()) {
                throw new IllegalArgumentException("Unknown queue state key '" + stateKey + "'");
            }
            MerkleNode node = this.findNode(md);
            if (node instanceof QueueNode) {
                QueueNode q = (QueueNode)node;
                ReadableQueueState ret = this.createReadableQueueState(md, q);
                this.queueInstances.put(stateKey, ret);
                return ret;
            }
            throw new IllegalStateException("Unexpected type for queue state " + stateKey);
        }

        public boolean contains(@NonNull String stateKey) {
            return this.stateMetadata.containsKey(stateKey);
        }

        @NonNull
        public Set<String> stateKeys() {
            return this.stateKeys;
        }

        @NonNull
        protected abstract ReadableKVState createReadableKVState(@NonNull StateMetadata var1, @NonNull VirtualMap var2);

        @NonNull
        protected abstract ReadableKVState createReadableKVState(@NonNull StateMetadata var1, @NonNull MerkleMap var2);

        @NonNull
        protected abstract ReadableSingletonState createReadableSingletonState(@NonNull StateMetadata var1, @NonNull SingletonNode<?> var2);

        @NonNull
        protected abstract ReadableQueueState createReadableQueueState(@NonNull StateMetadata var1, @NonNull QueueNode<?> var2);

        @NonNull
        MerkleNode findNode(@NonNull StateMetadata<?, ?> md) {
            int index = MerkleStateRoot.this.findNodeIndex(md.serviceName(), MerkleStateRoot.extractStateKey(md));
            if (index == -1) {
                throw new IllegalStateException("State '" + MerkleStateRoot.extractStateKey(md) + "' for service '" + md.serviceName() + "' is missing from the merkle tree!");
            }
            return MerkleStateRoot.this.getChild(index);
        }
    }
}

