/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.model.node;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Objects;
import org.hiero.base.io.SelfSerializable;
import org.hiero.base.io.streams.SerializableDataInputStream;
import org.hiero.base.io.streams.SerializableDataOutputStream;
import org.hiero.consensus.model.node.NodeIdCache;

public class NodeId
implements Comparable<NodeId>,
SelfSerializable {
    private static final long CLASS_ID = -1562170937950090579L;
    public static final NodeId UNDEFINED_NODE_ID = null;
    public static final long LOWEST_NODE_NUMBER = 0L;
    public static final NodeId FIRST_NODE_ID = NodeId.of(0L);
    private long id;

    public static NodeId of(long id) {
        return NodeIdCache.getOrCreate(id);
    }

    public NodeId() {
    }

    protected NodeId(long id) {
        if (id < 0L) {
            throw new IllegalArgumentException("id must be non-negative");
        }
        this.id = id;
    }

    public long getClassId() {
        return -1562170937950090579L;
    }

    public int getVersion() {
        return 1;
    }

    public int getMinimumSupportedVersion() {
        return 1;
    }

    public long id() {
        return this.id;
    }

    public NodeId getOffset(long offset) {
        long newValue = this.id + offset;
        if (newValue < 0L) {
            throw new IllegalArgumentException("the new NodeId, %d, must not be below the minimum value of %d.".formatted(newValue, 0L));
        }
        return NodeId.of(newValue);
    }

    @Override
    public int compareTo(@NonNull NodeId other) {
        Objects.requireNonNull(other, "NodeId cannot be null");
        return Long.compare(this.id, other.id);
    }

    @NonNull
    public String toString() {
        return Long.toString(this.id);
    }

    public void serialize(SerializableDataOutputStream out) throws IOException {
        out.writeLong(this.id);
    }

    public void deserialize(SerializableDataInputStream in, int version) throws IOException {
        this.id = in.readLong();
    }

    public static NodeId deserializeLong(SerializableDataInputStream in, boolean allowNull) throws IOException {
        long longValue = in.readLong();
        if (longValue < 0L) {
            if (allowNull) {
                return null;
            }
            throw new IOException("id must be non-negative");
        }
        return NodeId.of(longValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || NodeId.class != o.getClass()) {
            return false;
        }
        NodeId nodeId = (NodeId)o;
        return this.id == nodeId.id;
    }

    public int hashCode() {
        return Long.hashCode(this.id);
    }

    public static final class ClassVersion {
        public static final int ORIGINAL = 1;
    }
}

