/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.gossip.sync;

import com.swirlds.common.metrics.FunctionGauge;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Set;
import org.hiero.consensus.gossip.FallenBehindManager;
import org.hiero.consensus.model.node.NodeId;

public class SyncManagerImpl
implements FallenBehindManager {
    private final FallenBehindManager fallenBehindManager;

    public SyncManagerImpl(@NonNull Metrics metrics, @NonNull FallenBehindManager fallenBehindManager) {
        this.fallenBehindManager = Objects.requireNonNull(fallenBehindManager);
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "hasFallenBehind", Object.class, this::hasFallenBehind).withDescription("has this node fallen behind?"));
        metrics.getOrCreate((MetricConfig)new FunctionGauge.Config("internal", "numReportFallenBehind", Integer.class, this::numReportedFallenBehind).withDescription("the number of nodes that have fallen behind").withUnit("count"));
    }

    public void reportFallenBehind(@NonNull NodeId id) {
        this.fallenBehindManager.reportFallenBehind(id);
    }

    public void clearFallenBehind(@NonNull NodeId id) {
        this.fallenBehindManager.clearFallenBehind(id);
    }

    public void resetFallenBehind() {
        this.fallenBehindManager.resetFallenBehind();
    }

    public boolean hasFallenBehind() {
        return this.fallenBehindManager.hasFallenBehind();
    }

    public boolean shouldReconnectFrom(@NonNull NodeId peerId) {
        return this.fallenBehindManager.shouldReconnectFrom(peerId);
    }

    public int numReportedFallenBehind() {
        return this.fallenBehindManager.numReportedFallenBehind();
    }

    public void addRemovePeers(@NonNull Set<NodeId> added, @NonNull Set<NodeId> removed) {
        this.fallenBehindManager.addRemovePeers(added, removed);
    }
}

