/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.demo.virtualmerkle.state;

import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.common.io.config.TemporaryFileConfig;
import com.swirlds.common.utility.AutoCloseableWrapper;
import com.swirlds.config.api.Configuration;
import com.swirlds.config.api.ConfigurationBuilder;
import com.swirlds.demo.platform.PlatformTestingToolState;
import com.swirlds.demo.platform.UnsafeMutablePTTStateAccessor;
import com.swirlds.demo.virtualmerkle.config.VirtualMerkleConfig;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapKey;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapKeySerializer;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapValue;
import com.swirlds.demo.virtualmerkle.map.account.AccountVirtualMapValueSerializer;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapKey;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapKeySerializer;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapValue;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.bytecode.SmartContractByteCodeMapValueSerializer;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapKey;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapKeySerializer;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapValue;
import com.swirlds.demo.virtualmerkle.map.smartcontracts.data.SmartContractMapValueSerializer;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.merkledb.MerkleDbDataSourceBuilder;
import com.swirlds.merkledb.MerkleDbTableConfig;
import com.swirlds.merkledb.config.MerkleDbConfig;
import com.swirlds.platform.system.Platform;
import com.swirlds.virtualmap.VirtualMap;
import com.swirlds.virtualmap.config.VirtualMapConfig;
import com.swirlds.virtualmap.datasource.VirtualDataSourceBuilder;
import com.swirlds.virtualmap.serialize.KeySerializer;
import com.swirlds.virtualmap.serialize.ValueSerializer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Marker;
import org.hiero.base.crypto.DigestType;

public final class VirtualMerkleStateInitializer {
    private static final Configuration CONFIGURATION = ConfigurationBuilder.create().withConfigDataType(MerkleDbConfig.class).withConfigDataType(VirtualMapConfig.class).withConfigDataType(TemporaryFileConfig.class).withConfigDataType(StateCommonConfig.class).build();
    private static final MerkleDbConfig MERKLE_DB_CONFIG = (MerkleDbConfig)CONFIGURATION.getConfigData(MerkleDbConfig.class);
    private static final Integer MAX_LIST_CAPACITY = 1000000;
    private static final MerkleDbTableConfig TABLE_CONFIG = new MerkleDbTableConfig(1, DigestType.SHA_384, (long)MAX_LIST_CAPACITY.intValue(), MERKLE_DB_CONFIG.hashesRamToDiskThreshold());
    private static final Logger logger = LogManager.getLogger(VirtualMerkleStateInitializer.class);
    private static final Marker LOGM_DEMO_INFO = LogMarker.DEMO_INFO.getMarker();

    private VirtualMerkleStateInitializer() {
    }

    public static void initStateChildren(Platform platform, long nodeId, VirtualMerkleConfig virtualMerkleConfig) {
        try (AutoCloseableWrapper<PlatformTestingToolState> wrapper = UnsafeMutablePTTStateAccessor.getInstance().getUnsafeMutableState(platform.getSelfId());){
            PlatformTestingToolState state = (PlatformTestingToolState)((Object)wrapper.get());
            logger.info(LOGM_DEMO_INFO, "State = {}", (Object)state);
            long totalAccounts = virtualMerkleConfig.getTotalAccountCreations();
            logger.info(LOGM_DEMO_INFO, "total accounts = {}", (Object)totalAccounts);
            if (state.getVirtualMap() == null && totalAccounts > 0L) {
                logger.info(LOGM_DEMO_INFO, "Creating virtualmap for {} accounts.", (Object)totalAccounts);
                VirtualMap<AccountVirtualMapKey, AccountVirtualMapValue> virtualMap = VirtualMerkleStateInitializer.createAccountsVM();
                logger.info(LOGM_DEMO_INFO, "accounts VM = {}, DS = {}", virtualMap, (Object)virtualMap.getDataSource());
                virtualMap.registerMetrics(platform.getContext().getMetrics());
                state.setVirtualMap(virtualMap);
            }
            long maximumNumberOfKeyValuePairs = virtualMerkleConfig.getMaximumNumberOfKeyValuePairsCreation();
            logger.info(LOGM_DEMO_INFO, "max KV pairs = {}", (Object)maximumNumberOfKeyValuePairs);
            if (state.getVirtualMapForSmartContracts() == null && maximumNumberOfKeyValuePairs > 0L) {
                logger.info(LOGM_DEMO_INFO, "Creating virtualmap for max {} key value pairs.", (Object)maximumNumberOfKeyValuePairs);
                VirtualMap<SmartContractMapKey, SmartContractMapValue> virtualMap = VirtualMerkleStateInitializer.createSmartContractsVM();
                logger.info(LOGM_DEMO_INFO, "SC VM = {}, DS = {}", virtualMap, (Object)virtualMap.getDataSource());
                virtualMap.registerMetrics(platform.getContext().getMetrics());
                state.setVirtualMapForSmartContracts(virtualMap);
            }
            long totalSmartContracts = virtualMerkleConfig.getTotalSmartContractCreations();
            logger.info(LOGM_DEMO_INFO, "total SC = {}", (Object)totalSmartContracts);
            if (state.getVirtualMapForSmartContractsByteCode() == null && totalSmartContracts > 0L) {
                logger.info(LOGM_DEMO_INFO, "Creating virtualmap for {} bytecodes.", (Object)totalSmartContracts);
                VirtualMap<SmartContractByteCodeMapKey, SmartContractByteCodeMapValue> virtualMap = VirtualMerkleStateInitializer.createSmartContractByteCodeVM();
                logger.info(LOGM_DEMO_INFO, "SCBC VM = {}, DS = {}", virtualMap, (Object)virtualMap.getDataSource());
                virtualMap.registerMetrics(platform.getContext().getMetrics());
                state.setVirtualMapForSmartContractsByteCode(virtualMap);
            }
        }
    }

    private static VirtualMap<AccountVirtualMapKey, AccountVirtualMapValue> createAccountsVM() {
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(TABLE_CONFIG, CONFIGURATION);
        return new VirtualMap("accounts", (KeySerializer)new AccountVirtualMapKeySerializer(), (ValueSerializer)new AccountVirtualMapValueSerializer(), (VirtualDataSourceBuilder)dsBuilder, CONFIGURATION);
    }

    private static VirtualMap<SmartContractMapKey, SmartContractMapValue> createSmartContractsVM() {
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(TABLE_CONFIG, CONFIGURATION);
        return new VirtualMap("smartContracts", (KeySerializer)new SmartContractMapKeySerializer(), (ValueSerializer)new SmartContractMapValueSerializer(), (VirtualDataSourceBuilder)dsBuilder, CONFIGURATION);
    }

    private static VirtualMap<SmartContractByteCodeMapKey, SmartContractByteCodeMapValue> createSmartContractByteCodeVM() {
        MerkleDbDataSourceBuilder dsBuilder = new MerkleDbDataSourceBuilder(TABLE_CONFIG, CONFIGURATION);
        return new VirtualMap("smartContractByteCode", (KeySerializer)new SmartContractByteCodeMapKeySerializer(), (ValueSerializer)new SmartContractByteCodeMapValueSerializer(), (VirtualDataSourceBuilder)dsBuilder, CONFIGURATION);
    }
}

